/*
 * Decompiled with CFR 0.152.
 */
import com.blackhillsoftware.json.EasySmfGsonBuilder;
import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.cics.Smf110Record;
import com.blackhillsoftware.smf.cics.monitoring.CicsClock;
import com.blackhillsoftware.smf.cics.monitoring.DictionaryEntry;
import com.blackhillsoftware.smf.cics.monitoring.PerformanceRecord;
import com.blackhillsoftware.smf.cics.monitoring.fields.ClockField;
import com.blackhillsoftware.smf.cics.monitoring.fields.Field;
import com.blackhillsoftware.smf.summary.Top;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Query02TopValues {
    public static void main(String[] args) throws IOException {
        Smf110Record.dictionariesFromName((String)"C:\\Users\\Andrew\\SMF\\dictionary.smf");
        Gson gson = new EasySmfGsonBuilder().includeEmptyStrings(false).includeZeroValues(false).includeUnsetFlags(false).cicsClockDetail(false).avoidScientificNotation(true).createGson();
        try (SmfRecordReader reader = SmfRecordReader.fromName((String)"C:\\Users\\Andrew\\SMF\\cics.smf").include(110, 1);){
            Map groups = reader.stream().map(record -> Smf110Record.from((SmfRecord)record)).filter(r110 -> r110.mnProductSection().smfmnprn().equals("CICS2A8B")).map(r110 -> r110.performanceRecords()).flatMap(Collection::stream).collect(Collectors.groupingBy(tx -> tx.getField(Field.TRAN), Top.values((int)10, Comparator.comparing(tx -> tx.elapsedSeconds()))));
            groups.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(group -> {
                System.out.println((String)group.getKey());
                for (PerformanceRecord entry : (List)group.getValue()) {
                    System.out.println(entry);
                }
            });
        }
    }

    private static void printClocks(PerformanceRecord tx) {
        System.out.format("%-4s %-30s Elapsed : %f ", tx.getField(Field.TRAN), tx.getField(Field.START), tx.elapsedSeconds());
        for (DictionaryEntry entry : tx.getDictionary().entries()) {
            CicsClock clock;
            if (!(entry.field() instanceof ClockField) || !((clock = (CicsClock)tx.getField(entry)).timerSeconds() > tx.elapsedSeconds() * 0.1)) continue;
            System.out.format("%-8s : %f  ", entry.cmodhead(), clock.timerSeconds());
        }
        System.out.println();
    }
}

