/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.json.cics;

import com.blackhillsoftware.json.util.CompositeEntry;
import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.cics.Smf110Record;
import com.blackhillsoftware.smf.cics.monitoring.ExceptionData;
import com.blackhillsoftware.smf2json.cli.Smf2JsonCLI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CicsExceptions {
    public static void main(String[] args) throws IOException {
        Smf2JsonCLI cli = Smf2JsonCLI.create().description("Convert CICS Exception Records to JSON").includeRecords(110);
        cli.easySmfGsonBuilder().exclude(ExceptionData.class, "excmnnsx").calculateEntry(ExceptionData.class, "excmnnsx", exData -> String.format("%16X", exData.excmnnsx())).exclude(ExceptionData.class, "excmntrf").calculateEntry(ExceptionData.class, "excmntrf", exData -> String.format("%16X", exData.excmntrf()));
        cli.start((Smf2JsonCLI.Client)new CliClient(), args);
    }

    private static class CliClient
    implements Smf2JsonCLI.Client {
        private CliClient() {
        }

        public List<Object> processRecord(SmfRecord record) {
            ArrayList<Object> result = new ArrayList<Object>();
            Smf110Record r110 = Smf110Record.from((SmfRecord)record);
            for (ExceptionData exception : r110.exceptionData()) {
                result.add(new CompositeEntry().add("time", (Object)exception.excmnsto()).add("recordtype", (Object)"CICS Exception").add("system", (Object)r110.smfsid()).add("smfmnjbn", (Object)r110.mnProductSection().smfmnjbn()).add("smfmnprn", (Object)r110.mnProductSection().smfmnprn()).add("smfmnspn", (Object)r110.mnProductSection().smfmnspn()).add((Object)exception));
            }
            return result;
        }

        public List<Object> onEndOfData() {
            System.err.println("Finished");
            return Collections.emptyList();
        }
    }
}

