/*
 * Decompiled with CFR 0.152.
 */
package com.smfreports.json.smf30;

import com.blackhillsoftware.json.util.CompositeEntry;
import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.smf30.IdentificationSection;
import com.blackhillsoftware.smf.smf30.Smf30Record;
import com.blackhillsoftware.smf2json.cli.Smf2JsonCLI;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class StepAndJobEnd {
    public static void main(String[] args) throws IOException {
        Smf2JsonCLI cli = Smf2JsonCLI.create().includeRecords(30, 4).includeRecords(30, 5).description("Format SMF 30 job and step end records");
        cli.easySmfGsonBuilder().includeZeroValues(false).includeEmptyStrings(false).includeUnsetFlags(false).exclude("smf30rsd").exclude("smf30rst").calculateEntry(IdentificationSection.class, "readStart", section -> section.smf30rsd().atTime(section.smf30rst())).exclude("smf30red").exclude("smf30ret").calculateEntry(IdentificationSection.class, "readEnd", section -> section.smf30red().atTime(section.smf30ret())).exclude("smf30std").exclude("smf30sit").calculateEntry(IdentificationSection.class, "start", section -> section.smf30std().atTime(section.smf30sit())).exclude("smf30cor").exclude("smf30casOa54589").exclude("smf30srv").exclude("smf30csu").exclude("smf30srb").exclude("smf30io").exclude("smf30mso").exclude("smf30esu").exclude("smf30tep");
        cli.start((Smf2JsonCLI.Client)new CliClient(), args);
    }

    private static class CliClient
    implements Smf2JsonCLI.Client {
        private CliClient() {
        }

        public List<Object> onEndOfData() {
            return null;
        }

        public List<Object> processRecord(SmfRecord record) {
            Smf30Record r30 = Smf30Record.from((SmfRecord)record);
            if (r30.header().smf30ton() > 0 || r30.header().smf30con() > 0 || r30.header().smf30pon() > 0 || r30.header().smf30ron() > 0 || r30.header().smf30uon() > 0 || r30.header().smf30oon() > 0 || r30.header().smf30aon() > 0 || r30.header().smf30arn() > 0 || r30.header().smf30drn() > 0) {
                CompositeEntry result = new CompositeEntry();
                result.add("event", (Object)(r30.subType() == 5 ? "Job End" : "Step End")).add("time", (Object)r30.smfDateTime()).add("system", (Object)r30.system()).add("sysplex", (Object)r30.subSystemSection().smf30syp()).add("smf30wid", (Object)r30.header().smf30wid()).add((Object)r30.identificationSection()).add((Object)r30.completionSection()).add((Object)r30.processorAccountingSection()).add((Object)r30.performanceSection()).add((Object)r30.storageSection()).add((Object)r30.ioActivitySection()).add((Object)r30.operatorSection()).add((Object)r30.appcCumulativeResourceSection()).add((Object)r30.appcResourceSection());
                if (r30.accountingSections() != null && r30.accountingSections().size() > 0) {
                    result.add("accounting", (Object)r30.accountingSections());
                }
                return Collections.singletonList(result);
            }
            return Collections.emptyList();
        }
    }
}

