/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.dcollect;

import com.blackhillsoftware.dcollect.DcollectRecord;
import com.blackhillsoftware.dcollect.DcollectType;
import com.blackhillsoftware.dcollect.values.MigrationLevel;
import com.blackhillsoftware.smf.VRecord;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;

public final class DasdCapacityPlanning
extends DcollectRecord {
    DasdCapacityPlanning(byte[] Data2) {
        super(Data2);
        if (!this.dcurctyp().equals((Object)DcollectType.C)) {
            throw new IllegalArgumentException("Wrong record type " + this.dcurctyp().toString());
        }
    }

    DasdCapacityPlanning(VRecord record) {
        super(record);
        if (!this.dcurctyp().equals((Object)DcollectType.C)) {
            throw new IllegalArgumentException("Wrong record type " + this.dcurctyp().toString());
        }
    }

    public static DasdCapacityPlanning from(VRecord record) {
        return new DasdCapacityPlanning(record);
    }

    public String ucvolsr() {
        return Util.ConvertEbcdic(this.data, 24, 6);
    }

    public LocalDate uccoldt() {
        return Util.Packed4YYYYDDD(this.data, 30);
    }

    public int uccoldtRawValue() {
        return Util.ConvertPacked4(this.data, 30);
    }

    public int ucflag1() {
        return Util.ConvertUnsignedBinary1(this.data, 34);
    }

    public MigrationLevel uclevel() {
        int value = Util.ConvertUnsignedBinary1(this.data, 34, 192);
        return MigrationLevel.from(value);
    }

    public int uclevelRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 34, 192);
    }

    public int uctotal() {
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public double uctotalMB() {
        return (double)Util.ConvertSignedBinary4(this.data, 36) / 1024.0;
    }

    public int uctgocc() {
        return Util.ConvertUnsignedBinary1(this.data, 40);
    }

    public int uctrocc() {
        return Util.ConvertUnsignedBinary1(this.data, 41);
    }

    public int ucbfocc() {
        return Util.ConvertUnsignedBinary1(this.data, 42);
    }

    public int ucafocc() {
        return Util.ConvertUnsignedBinary1(this.data, 43);
    }

    public int ucnomig() {
        return Util.ConvertUnsignedBinary1(this.data, 44);
    }

    public int ucnintv() {
        return Util.ConvertUnsignedBinary1(this.data, 45);
    }

    public int ucintvm() {
        return Util.ConvertUnsignedBinary1(this.data, 46);
    }

    static enum Field {
        ucvolsr(24, 6),
        uccoldt(30, 4),
        ucflag1(34, 1),
        uclevel(34, 1),
        uctotal(36, 4),
        uctgocc(40, 1),
        uctrocc(41, 1),
        ucbfocc(42, 1),
        ucafocc(43, 1),
        ucnomig(44, 1),
        ucnintv(45, 1),
        ucintvm(46, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

