/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.dcollect;

import com.blackhillsoftware.dcollect.DcollectRecord;
import com.blackhillsoftware.dcollect.DcollectType;
import com.blackhillsoftware.smf.VRecord;
import com.blackhillsoftware.smf.internal.Util;
import java.util.HashMap;
import java.util.Map;

public final class Volume
extends DcollectRecord {
    public static final int DCVINXST = 192;
    public static final int DCVINXEX = 128;
    public static final int DCVINXEN = 64;
    public static final int DCVUSATR = 56;
    public static final int DCVUSPVT = 32;
    public static final int DCVUSPUB = 16;
    public static final int DCVUSSTO = 8;
    public static final int DCVSHRDS = 4;
    public static final int DCVEVLCP = 128;
    public static final int DCVEBYTK = 64;
    public static final int DCVELSPC = 32;
    public static final int DCVCYLMG = 128;

    Volume(byte[] Data2) {
        super(Data2);
        if (!this.dcurctyp().equals((Object)DcollectType.V)) {
            throw new IllegalArgumentException("Wrong record type " + this.dcurctyp().toString());
        }
    }

    Volume(VRecord record) {
        super(record);
        if (!this.dcurctyp().equals((Object)DcollectType.V)) {
            throw new IllegalArgumentException("Wrong record type " + this.dcurctyp().toString());
        }
    }

    public static Volume from(VRecord record) {
        return new Volume(record);
    }

    public String dcvvolsr() {
        return Util.ConvertEbcdic(this.data, 24, 6);
    }

    public int dcvflag1() {
        return Util.ConvertUnsignedBinary1(this.data, 30);
    }

    public boolean dcvinxex() {
        return Util.ConvertFlag(this.data, this.dcvflag1(), 128);
    }

    public boolean dcvinxen() {
        return Util.ConvertFlag(this.data, this.dcvflag1(), 64);
    }

    public boolean dcvuspvt() {
        return Util.ConvertFlag(this.data, this.dcvflag1(), 32);
    }

    public boolean dcvuspub() {
        return Util.ConvertFlag(this.data, this.dcvflag1(), 16);
    }

    public boolean dcvussto() {
        return Util.ConvertFlag(this.data, this.dcvflag1(), 8);
    }

    public boolean dcvshrds() {
        return Util.ConvertFlag(this.data, this.dcvflag1(), 4);
    }

    public PhysicalStatus dcvphyst() {
        int value = Util.ConvertUnsignedBinary1(this.data, 30, 3);
        return PhysicalStatus.from(value);
    }

    public int dcvphystRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 30, 3);
    }

    public int dcverror() {
        return Util.ConvertUnsignedBinary1(this.data, 31);
    }

    public boolean dcvevlcp() {
        return Util.ConvertFlag(this.data, this.dcverror(), 128);
    }

    public boolean dcvebytk() {
        return Util.ConvertFlag(this.data, this.dcverror(), 64);
    }

    public boolean dcvelspc() {
        return Util.ConvertFlag(this.data, this.dcverror(), 32);
    }

    public int dcvperct() {
        return Util.ConvertUnsignedBinary1(this.data, 35);
    }

    public long dcvfresp() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public double dcvfrespMB() {
        return this.dcvcylmg() ? (double)this.dcvfresp() : (double)this.dcvfresp() / 1024.0;
    }

    public long dcvalloc() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public double dcvallocMB() {
        return this.dcvcylmg() ? (double)this.dcvalloc() : (double)this.dcvalloc() / 1024.0;
    }

    public long dcvvlcap() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public double dcvvlcapMB() {
        return this.dcvcylmg() ? (double)this.dcvvlcap() : (double)this.dcvvlcap() / 1024.0;
    }

    public int dcvfragi() {
        return Util.ConvertSignedBinary4(this.data, 48);
    }

    public long dcvlgext() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public double dcvlgextMB() {
        return (double)Util.ConvertUnsignedBinary4(this.data, 52) / 1024.0;
    }

    public int dcvfrext() {
        return Util.ConvertSignedBinary4(this.data, 56);
    }

    public int dcvfdscb() {
        return Util.ConvertSignedBinary4(this.data, 60);
    }

    public int dcvfvirs() {
        return Util.ConvertSignedBinary4(this.data, 64);
    }

    public String dcvdvtyp() {
        return Util.ConvertEbcdic(this.data, 68, 8);
    }

    public int dcvdvnum() {
        return Util.ConvertUnsignedBinary2(this.data, 76);
    }

    private int dcvsglng() {
        return Util.ConvertUnsignedBinary2(this.data, 80);
    }

    public String dcvstggp() {
        if (this.data.length >= 82 + this.dcvsglng()) {
            return Util.ConvertEbcdic(this.data, 82, this.dcvsglng());
        }
        return null;
    }

    public String dcvdptyp() {
        return Util.ConvertEbcdic(this.data, 112, 8);
    }

    public int dcvtrpct() {
        return Util.ConvertUnsignedBinary1(this.data, 120);
    }

    public int dcveavol() {
        return Util.ConvertUnsignedBinary1(this.data, 121);
    }

    public boolean dcvcylmg() {
        return Util.ConvertFlag(this.data, this.dcveavol(), 128);
    }

    public long dcvtrfsp() {
        return Util.ConvertUnsignedBinary4(this.data, 124);
    }

    public double dcvtrfspMB() {
        return this.dcvcylmg() ? (double)this.dcvtrfsp() : (double)this.dcvtrfsp() / 1024.0;
    }

    public long dcvtralc() {
        return Util.ConvertUnsignedBinary4(this.data, 128);
    }

    public double dcvtralcMB() {
        return this.dcvcylmg() ? (double)this.dcvtralc() : (double)this.dcvtralc() / 1024.0;
    }

    public long dcvtrvlc() {
        return Util.ConvertUnsignedBinary4(this.data, 132);
    }

    public double dcvtrvlcMB() {
        return this.dcvcylmg() ? (double)this.dcvtrvlc() : (double)this.dcvtrvlc() / 1024.0;
    }

    public int dcvtrfrg() {
        return Util.ConvertSignedBinary4(this.data, 136);
    }

    public long dcvtrlge() {
        return Util.ConvertUnsignedBinary4(this.data, 140);
    }

    public int dcvtrfrx() {
        return Util.ConvertSignedBinary4(this.data, 144);
    }

    public int dcvfcyls() {
        return Util.ConvertSignedBinary4(this.data, 148);
    }

    public int dcvftrks() {
        return Util.ConvertSignedBinary4(this.data, 152);
    }

    public static enum PhysicalStatus {
        MANAGED(3),
        INITIAL(1),
        NONSMS(0),
        NOT_DEFINED(-16);

        private static Map<Integer, PhysicalStatus> valueMap;
        private final transient int vphysicalstatus;

        private PhysicalStatus(int vphysicalstatus) {
            this.vphysicalstatus = vphysicalstatus;
        }

        public static PhysicalStatus from(int value) {
            PhysicalStatus result = valueMap.get(value);
            if (result == null) {
                return NOT_DEFINED;
            }
            return result;
        }

        int vphysicalstatus() {
            return this.vphysicalstatus;
        }

        static {
            valueMap = new HashMap<Integer, PhysicalStatus>();
            for (PhysicalStatus x : PhysicalStatus.values()) {
                if (x == NOT_DEFINED) continue;
                valueMap.put(x.vphysicalstatus, x);
            }
        }
    }

    static enum Field {
        dcvvolsr(24, 6),
        dcvflag1(30, 1),
        dcvphyst(30, 1),
        dcverror(31, 1),
        dcvperct(35, 1),
        dcvfresp(36, 4),
        dcvalloc(40, 4),
        dcvvlcap(44, 4),
        dcvfragi(48, 4),
        dcvlgext(52, 4),
        dcvfrext(56, 4),
        dcvfdscb(60, 4),
        dcvfvirs(64, 4),
        dcvdvtyp(68, 8),
        dcvdvnum(76, 2),
        dcvsglng(80, 2),
        dcvsgtcl(82, 0),
        dcvdptyp(112, 8),
        dcvtrpct(120, 1),
        dcveavol(121, 1),
        dcvtrfsp(124, 4),
        dcvtralc(128, 4),
        dcvtrvlc(132, 4),
        dcvtrfrg(136, 4),
        dcvtrlge(140, 4),
        dcvtrfrx(144, 4),
        dcvfcyls(148, 4),
        dcvftrks(152, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

