/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.dcollect.values;

import java.util.HashMap;
import java.util.Map;

public enum MigrationLevel {
    LEVEL0(0),
    LEVEL1(64),
    LEVEL2(128),
    NOT_DEFINED(-16);

    private static Map<Integer, MigrationLevel> valueMap;
    private final transient int mlevel;

    private MigrationLevel(int mdevcl) {
        this.mlevel = mdevcl;
    }

    public static MigrationLevel from(int value) {
        MigrationLevel result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int mlevel() {
        return this.mlevel;
    }

    static {
        valueMap = new HashMap<Integer, MigrationLevel>();
        for (MigrationLevel x : MigrationLevel.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.mlevel, x);
        }
    }
}

