/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.ToStringConfig;
import com.blackhillsoftware.smf.Token;
import com.blackhillsoftware.smf.internal.Util;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Data {
    protected byte[] data;
    private transient int hashcode = 0;
    private static final Object[] emptyArgs = new Object[0];
    private static Map<Class<?>, Map<String, Method>> classMethods = new HashMap();
    private static final String bigIntegerSuffix = "AsBigInteger";

    public Data(byte[] source, int offset, int length) {
        if (offset + length > source.length) {
            throw new ArrayIndexOutOfBoundsException(String.format("Section is outside the bounds of the data. Offset: 0x%X (%d)  Length: 0x%X (%d) Data Length: 0x%X (%d)", offset, offset, length, length, source.length, source.length));
        }
        this.data = Arrays.copyOfRange(source, offset, offset + length);
    }

    public Data(byte[] source) {
        this.data = source;
    }

    public int length() {
        return this.data.length;
    }

    public byte[] getBytes() {
        return Arrays.copyOfRange(this.data, 0, this.data.length);
    }

    public byte[] getBytes(int offset, int length) {
        return Arrays.copyOfRange(this.data, offset, offset + length);
    }

    protected byte[] getDataArray() {
        return this.data;
    }

    public String dump() {
        return Data.dump(this.data, 0, this.data.length);
    }

    public String dump(int offset, int length) {
        return Data.dump(this.data, offset, length);
    }

    public static String dump(byte[] data) {
        return Data.dump(data, 0, data.length);
    }

    public static String dump(byte[] data, int offset, int length) {
        int bytesPerLine = 16;
        int out = 0;
        StringBuilder result = new StringBuilder();
        length = Math.min(length, data.length - offset);
        int firstLineBytes = bytesPerLine - offset % bytesPerLine;
        if (firstLineBytes < 16) {
            int i;
            result.append(String.format("%08X  ", offset / bytesPerLine * bytesPerLine));
            int space = (bytesPerLine - firstLineBytes) / 4 * 9 + (bytesPerLine - firstLineBytes) % 4 * 2;
            result.append(String.format("%" + Integer.toString(space) + "s", " "));
            if (firstLineBytes % 4 != 0) {
                for (i = 0; i < firstLineBytes % 4; ++i) {
                    int bytes = Util.ConvertUnsignedBinary1(data, offset + out);
                    result.append(String.format("%02X", bytes));
                    ++out;
                }
                result.append(" ");
            }
            for (i = 0; i < firstLineBytes / 4; ++i) {
                long bytes = Util.ConvertUnsignedBinary4(data, offset + out);
                result.append(String.format("%08X ", bytes));
                out += 4;
            }
            space = bytesPerLine - firstLineBytes;
            result.append(String.format("%" + Integer.toString(space) + "s", " "));
            result.append(String.format("%s", Util.ConvertEbcdic(data, offset, firstLineBytes)));
        }
        while (out <= length - bytesPerLine) {
            if (out > 0) {
                result.append(System.lineSeparator());
            }
            result.append(String.format("%08X  ", offset + out));
            for (int i = 0; i < bytesPerLine / 4; ++i) {
                long bytes = Util.ConvertUnsignedBinary4(data, offset + out + i * 4);
                result.append(String.format("%08X ", bytes));
            }
            result.append(String.format("%s", Util.ConvertEbcdic(data, offset + out, bytesPerLine)));
            out += bytesPerLine;
        }
        if (out < length) {
            if (out > 0) {
                result.append(System.lineSeparator());
            }
            result.append(String.format("%08X  ", offset + out));
            while (out <= length - 4) {
                long bytes = Util.ConvertUnsignedBinary4(data, offset + out);
                result.append(String.format("%08X ", bytes));
                out += 4;
            }
            while (out <= length - 1) {
                int bytes = Util.ConvertUnsignedBinary1(data, offset + out);
                result.append(String.format("%02X", bytes));
                ++out;
            }
            int remaining = bytesPerLine - (offset + out) % bytesPerLine;
            int space = remaining / 4 * 9 + remaining % 4 * 2;
            result.append(String.format("%" + Integer.toString(space) + "s %s", " ", Util.ConvertEbcdic(data, offset + out - (offset + out) % bytesPerLine, (offset + out) % bytesPerLine)));
        }
        return result.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Data other = (Data)obj;
        return Arrays.equals(this.data, other.data);
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            this.hashcode = Arrays.hashCode(this.data);
        }
        return this.hashcode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map methods;
        Map<Class<?>, Map<String, Method>> map = classMethods;
        synchronized (map) {
            methods = classMethods.computeIfAbsent(this.getClass(), key -> Data.buildMethodList(key));
        }
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        for (Map.Entry methodEntry : methods.entrySet()) {
            try {
                Object value = this.getClass().getMethod(((Method)methodEntry.getValue()).getName(), ((Method)methodEntry.getValue()).getParameterTypes()).invoke((Object)this, emptyArgs);
                if (value == null) {
                    values.put((String)methodEntry.getKey(), "null");
                    continue;
                }
                if (value instanceof String) {
                    values.put((String)methodEntry.getKey(), "\"" + value + "\"");
                    continue;
                }
                if (value instanceof Token) {
                    values.put((String)methodEntry.getKey(), "\"" + value.toString() + "\"");
                    continue;
                }
                if (value instanceof Data) {
                    values.put((String)methodEntry.getKey(), value.getClass().getSimpleName());
                    continue;
                }
                if (value instanceof Collection) {
                    values.put((String)methodEntry.getKey(), "[" + Integer.toString(((Collection)value).size()) + "]");
                    continue;
                }
                if (value.getClass().isArray()) {
                    values.put((String)methodEntry.getKey(), "[" + Integer.toString(Array.getLength(value)) + "]");
                    continue;
                }
                values.put((String)methodEntry.getKey(), value.toString());
            }
            catch (InvocationTargetException e) {
                if (e.getCause() != null) {
                    if (e.getCause().getClass().equals(FieldNotPresentException.class) || e.getCause().getClass().equals(NotAvailableException.class)) continue;
                    values.put((String)methodEntry.getKey(), e.getCause().toString());
                    continue;
                }
                if (e.getTargetException() != null) {
                    if (e.getTargetException().getClass().equals(FieldNotPresentException.class) || e.getTargetException().getClass().equals(NotAvailableException.class)) continue;
                    values.put((String)methodEntry.getKey(), e.getTargetException().toString());
                    continue;
                }
                values.put((String)methodEntry.getKey(), e.toString());
            }
            catch (FieldNotPresentException e) {
            }
            catch (NotAvailableException e) {
            }
            catch (IllegalAccessException e) {
                values.put((String)methodEntry.getKey(), e.toString());
            }
            catch (IllegalArgumentException e) {
                values.put((String)methodEntry.getKey(), e.toString());
            }
            catch (NoSuchMethodException e) {
                values.put((String)methodEntry.getKey(), e.toString());
            }
            catch (SecurityException e) {
                values.put((String)methodEntry.getKey(), e.toString());
            }
        }
        return values.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + (String)entry.getValue()).collect(Collectors.toList()).toString();
    }

    private static Map<String, Method> buildMethodList(Class<?> clazz) {
        LinkedHashMap<String, Method> methods = new LinkedHashMap<String, Method>();
        ArrayList heirarchy = new ArrayList();
        heirarchy.add(clazz);
        while (clazz.getSuperclass() != Object.class && clazz.getSuperclass() != Data.class) {
            clazz = clazz.getSuperclass();
            heirarchy.add(clazz);
        }
        Collections.reverse(heirarchy);
        for (Class clazz2 : heirarchy) {
            List<Method> allMethods = Arrays.asList(clazz2.getDeclaredMethods());
            Map valueMethods = allMethods.stream().filter(x -> !Iterable.class.isAssignableFrom(x.getReturnType())).filter(x -> !Data.class.isAssignableFrom(x.getReturnType())).filter(x -> ToStringConfig.include(c, x)).sorted((a, b) -> a.getName().compareTo(b.getName())).collect(Collectors.toMap(Method::getName, Function.identity(), (o1, o2) -> o1, LinkedHashMap::new));
            Map otherMethods = allMethods.stream().filter(x -> !valueMethods.containsKey(x.getName())).sorted((a, b) -> a.getName().compareTo(b.getName())).filter(x -> ToStringConfig.include(c, x)).collect(Collectors.toMap(Method::getName, Function.identity(), (o1, o2) -> o1, LinkedHashMap::new));
            List bigIntegerNames = valueMethods.keySet().stream().filter(entry -> entry.endsWith(bigIntegerSuffix)).collect(Collectors.toList());
            for (String bigIntegerName : bigIntegerNames) {
                String nonBigIntegerName = bigIntegerName.substring(0, bigIntegerName.length() - bigIntegerSuffix.length());
                if (!valueMethods.containsKey(nonBigIntegerName)) continue;
                valueMethods.put(nonBigIntegerName, (Method)valueMethods.get(bigIntegerName));
                valueMethods.remove(bigIntegerName);
            }
            methods.putAll(valueMethods);
            methods.putAll(otherMethods);
        }
        return methods;
    }
}

