/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf;

import com.blackhillsoftware.smf.SmfRecord;
import com.ibm.jzos.RecordWriter;
import java.io.IOException;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JzosRecordWriter {
    boolean closed = false;
    private RecordWriter recordwriter;

    private JzosRecordWriter(RecordWriter aRecordWriter) {
        this.recordwriter = aRecordWriter;
    }

    public static JzosRecordWriter fromDD(String dd) throws IOException {
        try {
            return new JzosRecordWriter(RecordWriter.newWriterForDD((String)dd));
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
            boolean zos;
            String osname = System.getProperty("os.name").toLowerCase(Locale.US);
            boolean bl = zos = osname.indexOf("z/os") > -1;
            if (!zos) {
                Logger slf4jLogger = LoggerFactory.getLogger(SmfRecord.class);
                slf4jLogger.error("Error trying to open DDNAME " + dd);
                slf4jLogger.error("This error is expected if trying to write to a dataset on a non-z/OS system.");
            }
            throw e;
        }
    }

    public static JzosRecordWriter fromDatasetName(String name) throws IOException {
        try {
            return new JzosRecordWriter(RecordWriter.newWriter((String)name, (int)4));
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
            boolean zos;
            String osname = System.getProperty("os.name").toLowerCase(Locale.US);
            boolean bl = zos = osname.indexOf("z/os") > -1;
            if (!zos) {
                Logger slf4jLogger = LoggerFactory.getLogger(SmfRecord.class);
                slf4jLogger.error("Error trying to open dataset " + name);
                slf4jLogger.error("This error is expected if trying to write to a dataset on a non-z/OS system.");
            }
            throw e;
        }
    }

    public void write(SmfRecord record) throws IOException {
        byte[] data = record.getDataArray();
        this.recordwriter.write(data, 4, data.length - 4);
    }

    public void write(byte[] buf, int offset, int length) throws IOException {
        this.recordwriter.write(buf, offset, length);
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.recordwriter != null) {
                this.recordwriter.close();
            }
        }
    }
}

