/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf;

import com.blackhillsoftware.common.interfaces.Emptyable;
import com.blackhillsoftware.smf.ByteArrayRecordReader;
import com.blackhillsoftware.smf.JzosRecordReader;
import com.blackhillsoftware.smf.RecordReader;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReaderBuilder;
import com.blackhillsoftware.smf.StreamRecordReader;
import com.blackhillsoftware.smf.VRecord;
import com.blackhillsoftware.smf.VRecordReader;
import com.blackhillsoftware.smf.VRecordReaderIterator;
import com.blackhillsoftware.smf.VRecordReaderSpliterator;
import com.blackhillsoftware.smf.readerbuilder.Builders;
import com.blackhillsoftware.smf.readerbuilder.LogstreamBuilder;
import com.blackhillsoftware.smf.readerbuilder.StreamReaderBuilder;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Spliterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmfRecordReader
extends RecordReader<SmfRecord>
implements Iterable<SmfRecord>,
Closeable {
    private VRecordReader reader;
    private Emptyable maybeEmpty = null;
    private Map<Integer, Set<Integer>> includes = null;
    private Iterator<SmfRecord> theIterator = null;
    private Spliterator<SmfRecord> theSpliterator = null;

    private SmfRecordReader(VRecordReader reader) {
        this.reader = reader;
    }

    public static LogstreamBuilder<?> logstreamBuilder(String name) {
        return Builders.logstreamBuilder(name);
    }

    public static StreamReaderBuilder<?> streamBuilder(InputStream stream) {
        return Builders.streamBuilder(stream);
    }

    public static SmfRecordReaderBuilder ddnameBuilder(String ddname) {
        return Builders.ddnameBuilder(ddname);
    }

    public static SmfRecordReaderBuilder nameBuilder(String name) {
        return Builders.nameBuilder(name);
    }

    public static SmfRecordReaderBuilder byteArraysBuilder(Iterable<byte[]> source) {
        return Builders.byteArraysBuilder(source);
    }

    public static SmfRecordReader fromLogstream(String logstreamName) throws IOException {
        return new SmfRecordReader(JzosRecordReader.fromLogstream(logstreamName, null, null));
    }

    public static SmfRecordReader fromLogstream(String logstreamName, String subsysOptions1) throws IOException {
        return new SmfRecordReader(JzosRecordReader.fromLogstream(logstreamName, subsysOptions1, null));
    }

    public static SmfRecordReader fromLogstream(String logstreamName, String subsysOptions1, String subsysOptions2) throws IOException {
        return new SmfRecordReader(JzosRecordReader.fromLogstream(logstreamName, subsysOptions1, subsysOptions2));
    }

    public static SmfRecordReader fromDD(String dd) throws IOException {
        return new SmfRecordReader(JzosRecordReader.fromDD(dd));
    }

    public static SmfRecordReader fromName(String name) throws IOException, FileNotFoundException {
        try {
            if (name.startsWith("//DD:")) {
                return new SmfRecordReader(JzosRecordReader.fromDD(name.substring(5)));
            }
            if (name.startsWith("//LOGR:") || name.startsWith("//LOGSTREAM:")) {
                name = name.substring(name.indexOf(":") + 1);
                String lsParms = null;
                int cPos = name.indexOf(",");
                if (cPos != -1) {
                    lsParms = name.substring(cPos + 1);
                    name = name.substring(0, cPos);
                }
                return new SmfRecordReader(JzosRecordReader.fromLogstream(name, lsParms, null));
            }
            if (name.startsWith("//") && !name.startsWith("///")) {
                return new SmfRecordReader(JzosRecordReader.fromDatasetName(name));
            }
            return SmfRecordReader.fromStream(new FileInputStream(name));
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
            boolean zos;
            String osname = System.getProperty("os.name").toLowerCase(Locale.US);
            boolean bl = zos = osname.indexOf("z/os") > -1;
            if (!zos) {
                Logger slf4jLogger = LoggerFactory.getLogger(SmfRecord.class);
                slf4jLogger.error("Error trying to open " + name);
                slf4jLogger.error("This error is expected if trying to read from a DDNAME on a non-z/OS system.");
            }
            throw e;
        }
    }

    public static SmfRecordReader fromStream(InputStream stream) {
        return new SmfRecordReader(new StreamRecordReader(stream, RecordFormat.AUTODETECT));
    }

    public static SmfRecordReader fromStream(InputStream stream, RecordFormat format) {
        return new SmfRecordReader(new StreamRecordReader(stream, format));
    }

    public static SmfRecordReader fromByteArrays(Iterable<byte[]> source) {
        SmfRecordReader result = new SmfRecordReader(new ByteArrayRecordReader(source));
        if (source instanceof Emptyable) {
            result.maybeEmpty = (Emptyable)source;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (!this.closed) {
                this.closed = true;
                if (this.reader != null) {
                    this.reader.close();
                }
            }
        }
    }

    @Override
    public synchronized SmfRecord read() throws IOException {
        if (this.closed) {
            throw new IOException("Reader has been closed");
        }
        if (this.reader instanceof ByteArrayRecordReader) {
            VRecord record = this.reader.read();
            while (record != null && !this.includeRecord(new SmfRecord(record))) {
                record = this.reader.read();
            }
            return record != null ? new SmfRecord(record) : null;
        }
        byte[] buffer = new byte[32768];
        int bytesRead = this.reader.read(buffer);
        while (bytesRead > 0 && !this.includeRecord(new SmfRecord(buffer))) {
            bytesRead = this.reader.read(buffer);
        }
        return bytesRead > 0 ? new SmfRecord(Arrays.copyOfRange(buffer, 0, bytesRead)) : null;
    }

    public SmfRecordReader include(int smftype) {
        if (this.includes == null) {
            this.includes = new HashMap<Integer, Set<Integer>>();
        }
        this.includes.put(smftype, new HashSet());
        return this;
    }

    public SmfRecordReader include(int smftype, int subtype) {
        if (this.includes == null) {
            this.includes = new HashMap<Integer, Set<Integer>>();
        }
        this.includes.computeIfAbsent(smftype, x -> new HashSet()).add(subtype);
        return this;
    }

    protected boolean includeRecord(SmfRecord record) {
        if (this.includes == null) {
            return true;
        }
        int type = record.recordType();
        Set<Integer> subtypes = this.includes.get(type);
        if (subtypes == null) {
            return false;
        }
        return subtypes.isEmpty() || subtypes.contains(record.subType());
    }

    @Override
    public synchronized Iterator<SmfRecord> iterator() {
        if (this.theIterator != null || this.theSpliterator != null) {
            throw new IllegalStateException("An Iterator or Spliterator already exists for this connection");
        }
        if (this.theIterator != null || this.theSpliterator != null) {
            throw new IllegalStateException("An Iterator or Spliterator already exists for this connection");
        }
        this.theIterator = new VRecordReaderIterator<SmfRecord>(this);
        return this.theIterator;
    }

    @Override
    public synchronized Spliterator<SmfRecord> spliterator() {
        if (this.theIterator != null || this.theSpliterator != null) {
            throw new IllegalStateException("An Iterator or Spliterator already exists for this connection");
        }
        this.theSpliterator = new VRecordReaderSpliterator<SmfRecord>(this);
        return this.theSpliterator;
    }

    @Override
    synchronized int refill(Queue<SmfRecord> queue, int max) throws IOException {
        int count = 0;
        SmfRecord record = this.read();
        if (record != null) {
            queue.add(record);
            ++count;
            while (!(count >= max || this.maybeEmpty != null && this.maybeEmpty.isEmpty() || (record = this.read()) == null)) {
                queue.add(record);
                ++count;
            }
        }
        return count;
    }

    public synchronized Stream<SmfRecord> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    static RecordFormat detectStream(InputStream innerstream) throws IOException {
        int bytesread;
        int read;
        if (!innerstream.markSupported()) {
            throw new IOException("Mark/reset not supported");
        }
        innerstream.mark(32760);
        int headerbytes = 18;
        byte[] workdata = new byte[32760];
        for (bytesread = 0; bytesread < headerbytes && (read = innerstream.read(workdata, bytesread, headerbytes - bytesread)) > 0; bytesread += read) {
        }
        innerstream.reset();
        SmfData s = new SmfData(workdata, 0, bytesread);
        if (bytesread < headerbytes) {
            throw new IOException("Data is shorter than SMF header length\n\n" + s.dump());
        }
        if (SmfRecord.sanityCheck(workdata, 0)) {
            return RecordFormat.V;
        }
        if (SmfRecord.sanityCheck(workdata, 4)) {
            return RecordFormat.U;
        }
        if (SmfRecord.sanityCheck(workdata, -4)) {
            throw new IOException("Data might be SMF data missing the RDW\n\n" + s.dump());
        }
        throw new IOException("Data does not look like SMF data\n\n" + s.dump());
    }

    static {
        SmfRecord.checkPrereqs();
    }

    public static enum RecordFormat {
        AUTODETECT,
        U,
        V;

    }
}

