/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf;

import com.blackhillsoftware.smf.internal.Util;

class VbsSegmentInfo {
    public static final int SDWLENGTH = 4;
    public static final int RDWLENGTH = 4;
    private static final int LENGTHMASK = Short.MAX_VALUE;
    int length = 0;
    SegmentType segmentType;

    public VbsSegmentInfo(byte[] data, int offset) {
        this.segmentType = VbsSegmentInfo.segmentType(data, offset);
        this.length = VbsSegmentInfo.length(data, offset);
    }

    public static int length(byte[] data, int offset) {
        return Util.ConvertUnsignedBinary2(data, offset) & Short.MAX_VALUE;
    }

    public static SegmentType segmentType(byte[] data, int offset) {
        return SegmentType.fromData(data, offset);
    }

    public int length() {
        return this.length;
    }

    public SegmentType segmentType() {
        return this.segmentType;
    }

    public static enum SegmentType {
        completeRecord,
        firstSegment,
        lastSegment,
        middleSegment,
        nullSegment;

        private static final int segmentcontroloffset = 2;
        private static final int segmentcontrolmask = 3;
        private static final int completerecord = 0;
        private static final int firstsegment = 1;
        private static final int lastsegment = 2;
        private static final int middlesegment = 3;
        private static final int nullsegment = 128;

        static SegmentType fromData(byte[] data, int offset) {
            if ((data[offset] & 0x80) == 128) {
                return nullSegment;
            }
            int segmentControl = data[offset + 2] & 3;
            switch (segmentControl) {
                case 0: {
                    return completeRecord;
                }
                case 1: {
                    return firstSegment;
                }
                case 2: {
                    return lastSegment;
                }
                case 3: {
                    return middleSegment;
                }
            }
            throw new IllegalArgumentException("Segment type not recognized");
        }
    }
}

