/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics;

import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.cics.CicsInstanceId;
import com.blackhillsoftware.smf.cics.JcProductSection;
import com.blackhillsoftware.smf.cics.MnHeader;
import com.blackhillsoftware.smf.cics.MnProductSection;
import com.blackhillsoftware.smf.cics.StProductSection;
import com.blackhillsoftware.smf.cics.monitoring.Dictionary;
import com.blackhillsoftware.smf.cics.monitoring.DictionaryEntry;
import com.blackhillsoftware.smf.cics.monitoring.ExceptionData;
import com.blackhillsoftware.smf.cics.monitoring.IdentityRecord;
import com.blackhillsoftware.smf.cics.monitoring.PerformanceRecord;
import com.blackhillsoftware.smf.cics.monitoring.TransactionResourceRecord;
import com.blackhillsoftware.smf.cics.statistics.AsynchronousServiceGlobalStatistics;
import com.blackhillsoftware.smf.cics.statistics.AtomserviceStatistics;
import com.blackhillsoftware.smf.cics.statistics.CapturespecResourceStatistics;
import com.blackhillsoftware.smf.cics.statistics.CfListStructureStatistics;
import com.blackhillsoftware.smf.cics.statistics.CfRequestStatistics;
import com.blackhillsoftware.smf.cics.statistics.CfServerStorageStatistics;
import com.blackhillsoftware.smf.cics.statistics.CfTableStatistics;
import com.blackhillsoftware.smf.cics.statistics.Db2GlobalStatistics;
import com.blackhillsoftware.smf.cics.statistics.Db2ResourceStatistics;
import com.blackhillsoftware.smf.cics.statistics.DbctlUnsolicitedStatistics;
import com.blackhillsoftware.smf.cics.statistics.DispatcherMvsTcbGlobalStatistics;
import com.blackhillsoftware.smf.cics.statistics.DispatcherMvsTcbResourceStatistics;
import com.blackhillsoftware.smf.cics.statistics.DoctemplateResourceStatistics;
import com.blackhillsoftware.smf.cics.statistics.EnqueueManagerGlobalStatistics;
import com.blackhillsoftware.smf.cics.statistics.EnqueuePoolStatistics;
import com.blackhillsoftware.smf.cics.statistics.EventBindingResourceStatistics;
import com.blackhillsoftware.smf.cics.statistics.EventProcessGlobalStatistics;
import com.blackhillsoftware.smf.cics.statistics.EventProcessResourceStatistics;
import com.blackhillsoftware.smf.cics.statistics.EventbindingGlobalStatistics;
import com.blackhillsoftware.smf.cics.statistics.FepiConnectionStatistics;
import com.blackhillsoftware.smf.cics.statistics.FepiPoolStatistics;
import com.blackhillsoftware.smf.cics.statistics.FepiTargetStatistics;
import com.blackhillsoftware.smf.cics.statistics.FileControlStatistics;
import com.blackhillsoftware.smf.cics.statistics.IpconnStatistics;
import com.blackhillsoftware.smf.cics.statistics.IscIrcModeStatistics;
import com.blackhillsoftware.smf.cics.statistics.IscIrcSystemStatistics;
import com.blackhillsoftware.smf.cics.statistics.IscLuitSntStatistics;
import com.blackhillsoftware.smf.cics.statistics.JvmServerStatistics;
import com.blackhillsoftware.smf.cics.statistics.LoaderGlobalDsaStatistics;
import com.blackhillsoftware.smf.cics.statistics.LoaderGlobalStatistics;
import com.blackhillsoftware.smf.cics.statistics.LoaderPrivateLibraryStatistics;
import com.blackhillsoftware.smf.cics.statistics.LoaderPrivateProgramStatistics;
import com.blackhillsoftware.smf.cics.statistics.LoaderPublicLibraryStatistics;
import com.blackhillsoftware.smf.cics.statistics.LoaderPublicProgramStatistics;
import com.blackhillsoftware.smf.cics.statistics.LogManagerGlobalStatistics;
import com.blackhillsoftware.smf.cics.statistics.LogManagerJournalStatistics;
import com.blackhillsoftware.smf.cics.statistics.LogManagerLogstreamStatistics;
import com.blackhillsoftware.smf.cics.statistics.LsrPoolFileStatistics;
import com.blackhillsoftware.smf.cics.statistics.LsrPoolStatistics;
import com.blackhillsoftware.smf.cics.statistics.MonitoringGlobalStatistics;
import com.blackhillsoftware.smf.cics.statistics.MqConnectionGlobalStatistics;
import com.blackhillsoftware.smf.cics.statistics.MqMonitorStatistics;
import com.blackhillsoftware.smf.cics.statistics.NcListStructureStatistics;
import com.blackhillsoftware.smf.cics.statistics.NcStorageStatistics;
import com.blackhillsoftware.smf.cics.statistics.NodeJsAppStatistics;
import com.blackhillsoftware.smf.cics.statistics.PipelineStatistics;
import com.blackhillsoftware.smf.cics.statistics.PipelineWebserviceStatistics;
import com.blackhillsoftware.smf.cics.statistics.PolicyStatistics;
import com.blackhillsoftware.smf.cics.statistics.PrivateJvmProgramStatistics;
import com.blackhillsoftware.smf.cics.statistics.PrivateProgramdefStatistics;
import com.blackhillsoftware.smf.cics.statistics.ProgramManagerGlobalStatistics;
import com.blackhillsoftware.smf.cics.statistics.PublicJvmProgramStatistics;
import com.blackhillsoftware.smf.cics.statistics.PublicProgramdefStatistics;
import com.blackhillsoftware.smf.cics.statistics.RecoveryManagerGlobalStatistics;
import com.blackhillsoftware.smf.cics.statistics.ResLifeBundleStatistics;
import com.blackhillsoftware.smf.cics.statistics.SecurityDomainGlobalStatistics;
import com.blackhillsoftware.smf.cics.statistics.SocketsGlobalStatistics;
import com.blackhillsoftware.smf.cics.statistics.SocketsServiceStatistics;
import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.StatisticsStatistics;
import com.blackhillsoftware.smf.cics.statistics.StorageDomainSubpoolStatistics;
import com.blackhillsoftware.smf.cics.statistics.StorageManagerDsaStatistics;
import com.blackhillsoftware.smf.cics.statistics.StorageManagerGlobalStatistics;
import com.blackhillsoftware.smf.cics.statistics.StorageManagerStatistics;
import com.blackhillsoftware.smf.cics.statistics.StorageTaskSubpoolStatistics;
import com.blackhillsoftware.smf.cics.statistics.StorageTaskSubpoolStatisticsEntry;
import com.blackhillsoftware.smf.cics.statistics.SystemDumpGlobalStatistics;
import com.blackhillsoftware.smf.cics.statistics.SystemDumpcodeStatistics;
import com.blackhillsoftware.smf.cics.statistics.TableManagerGlobalStatistics;
import com.blackhillsoftware.smf.cics.statistics.TableManagerTableStatistics;
import com.blackhillsoftware.smf.cics.statistics.TemporaryStorageStatistics;
import com.blackhillsoftware.smf.cics.statistics.TerminalAutoinstallStatistics;
import com.blackhillsoftware.smf.cics.statistics.TerminalStatistics;
import com.blackhillsoftware.smf.cics.statistics.TlsCipherStatistics;
import com.blackhillsoftware.smf.cics.statistics.TransactionDumpGlobalStatistics;
import com.blackhillsoftware.smf.cics.statistics.TransactionDumpcodeStatistics;
import com.blackhillsoftware.smf.cics.statistics.TransactionManagerGlobalStatistics;
import com.blackhillsoftware.smf.cics.statistics.TransactionManagerTclassStatistics;
import com.blackhillsoftware.smf.cics.statistics.TransactionManagerTransactionStatistics;
import com.blackhillsoftware.smf.cics.statistics.TransientDataGlobalStatistics;
import com.blackhillsoftware.smf.cics.statistics.TransientDataQueueStatistics;
import com.blackhillsoftware.smf.cics.statistics.UserDomainGlobalStatistics;
import com.blackhillsoftware.smf.cics.statistics.VtamGlobalStatistics;
import com.blackhillsoftware.smf.cics.statistics.WebUrimapGlobalStatistics;
import com.blackhillsoftware.smf.cics.statistics.WebUrimapResourceStatistics;
import com.blackhillsoftware.smf.cics.statistics.XmlTransformStatistics;
import com.blackhillsoftware.smf.cics.statistics.XqListStructureStatistics;
import com.blackhillsoftware.smf.cics.statistics.XqQueueBufferPoolStatistics;
import com.blackhillsoftware.smf.cics.statistics.XqServerStorageStatistics;
import com.blackhillsoftware.smf.cics.statistics.cics510.DispatcherGlobalStatistics;
import com.blackhillsoftware.smf.cics.statistics.cics530.MonitoringTransactionStatistics;
import com.blackhillsoftware.smf.internal.CicsDictionaryCollection;
import com.blackhillsoftware.smf.internal.Csrcesrv;
import com.blackhillsoftware.smf.internal.Util;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public final class Smf110Record
extends SmfRecord {
    private transient int originalCompressedLength = 0;
    private static AtomicLong compressedByteCount = new AtomicLong();
    private static AtomicLong decompressedByteCount = new AtomicLong();
    private transient int hashcode = 0;
    private transient byte[] originalData = null;
    private List<TransactionManagerGlobalStatistics> m_transactionManagerGlobalStatistics = null;
    private List<TransactionManagerTransactionStatistics> m_transactionManagerTransactionStatistics = null;
    private List<TransactionManagerTclassStatistics> m_transactionManagerTclassStatistics = null;
    private List<StorageDomainSubpoolStatistics> m_storageDomainSubpoolStatistics = null;
    private List<FepiPoolStatistics> m_fepiPoolStatistics = null;
    private List<FepiConnectionStatistics> m_fepiConnectionStatistics = null;
    private List<FepiTargetStatistics> m_fepiTargetStatistics = null;
    private List<StorageTaskSubpoolStatistics> m_storageTaskSubpoolStatistics = null;
    private List<StorageTaskSubpoolStatisticsEntry> m_storageTaskSubpoolStatisticsEntries = null;
    private List<VtamGlobalStatistics> m_vtamGlobalStatistics = null;
    private List<ProgramManagerGlobalStatistics> m_programManagerGlobalStatistics = null;
    private List<TerminalAutoinstallStatistics> m_terminalAutoinstallStatistics = null;
    private List<LoaderPublicProgramStatistics> m_loaderPublicProgramStatistics = null;
    private List<DbctlUnsolicitedStatistics> m_dbctlUnsolicitedStatistics = null;
    private List<StorageManagerStatistics> m_storageManagerStatistics = null;
    private List<StorageManagerGlobalStatistics> m_storageManagerGlobalStatistics = null;
    private List<StorageManagerDsaStatistics> m_storageManagerDsaStatistics = null;
    private List<LoaderGlobalStatistics> m_loaderGlobalStatistics = null;
    private List<LoaderGlobalDsaStatistics> m_loaderGlobalDsaStatistics = null;
    private List<LoaderPublicLibraryStatistics> m_loaderPublicLibraryStatistics = null;
    private List<LoaderPrivateLibraryStatistics> m_loaderPrivateLibraryStatistics = null;
    private List<TerminalStatistics> m_terminalResidStatistics = null;
    private List<TerminalStatistics> m_terminalBtamLineStatistics = null;
    private List<LoaderPrivateProgramStatistics> m_loaderPrivateProgramStatistics = null;
    private List<LsrPoolStatistics> m_lsrPoolStatistics = null;
    private List<LsrPoolFileStatistics> m_lsrPoolFileStatistics = null;
    private List<LsrPoolFileStatistics> m_lsrPoolFileTotals = null;
    private List<TransientDataQueueStatistics> m_transientDataQueueStatistics = null;
    private List<TransientDataGlobalStatistics> m_transientDataGlobalStatistics = null;
    private List<SecurityDomainGlobalStatistics> m_securityDomainGlobalStatistics = null;
    private List<TemporaryStorageStatistics> m_temporaryStorageStatistics = null;
    private List<IscIrcSystemStatistics> m_iscIrcSystemStatistics = null;
    private List<IscIrcSystemStatistics> m_iscIrcSystemTotals = null;
    private List<IscLuitSntStatistics> m_iscLuitSntStatistics = null;
    private List<UserDomainGlobalStatistics> m_userDomainGlobalStatistics = null;
    private List<com.blackhillsoftware.smf.cics.statistics.DispatcherGlobalStatistics> m_dispatcherGlobalStatistics = null;
    private List<TableManagerGlobalStatistics> m_tableManagerGlobalStatistics = null;
    private List<TableManagerTableStatistics> m_tableManagerTableStatistics = null;
    private List<DispatcherMvsTcbGlobalStatistics> m_dispatcherMvsTcbGlobalStatistics = null;
    private List<DispatcherMvsTcbResourceStatistics> m_dispatcherMvsTcbResourceStatistics = null;
    private List<StatisticsStatistics> m_statisticsStatistics = null;
    private List<FileControlStatistics> m_fileControlStatistics = null;
    private List<MqConnectionGlobalStatistics> m_mqConnectionGlobalStatistics = null;
    private List<IscIrcModeStatistics> m_iscIrcModeStatistics = null;
    private List<MonitoringGlobalStatistics> m_monitoringGlobalStatistics = null;
    private List<com.blackhillsoftware.smf.cics.statistics.MonitoringTransactionStatistics> m_monitoringTransactionStatistics = null;
    private List<TransactionDumpcodeStatistics> m_transactionDumpcodeStatistics = null;
    private List<TransactionDumpGlobalStatistics> m_transactionDumpGlobalStatistics = null;
    private List<SystemDumpcodeStatistics> m_systemDumpcodeStatistics = null;
    private List<SystemDumpGlobalStatistics> m_systemDumpGlobalStatistics = null;
    private List<LogManagerGlobalStatistics> m_logManagerGlobalStatistics = null;
    private List<LogManagerJournalStatistics> m_logManagerJournalStatistics = null;
    private List<LogManagerLogstreamStatistics> m_logManagerLogstreamStatistics = null;
    private List<EnqueueManagerGlobalStatistics> m_enqueueManagerGlobalStatistics = null;
    private List<EnqueuePoolStatistics> m_enqueuePoolStatistics = null;
    private List<RecoveryManagerGlobalStatistics> m_recoveryManagerGlobalStatistics = null;
    private List<ResLifeBundleStatistics> m_resLifeBundleStatistics = null;
    private List<WebUrimapGlobalStatistics> m_webUrimapGlobalStatistics = null;
    private List<Db2GlobalStatistics> m_db2GlobalStatistics = null;
    private List<Db2ResourceStatistics> m_db2ResourceStatistics = null;
    private List<WebUrimapResourceStatistics> m_webUrimapResourceStatistics = null;
    private List<PipelineStatistics> m_pipelineStatistics = null;
    private List<PipelineWebserviceStatistics> m_pipelineWebserviceStatistics = null;
    private List<SocketsGlobalStatistics> m_socketsGlobalStatistics = null;
    private List<SocketsServiceStatistics> m_socketsServiceStatistics = null;
    private List<IpconnStatistics> m_ipconnStatistics = null;
    private List<AtomserviceStatistics> m_atomserviceStatistics = null;
    private List<DoctemplateResourceStatistics> m_doctemplateResourceStatistics = null;
    private List<XmlTransformStatistics> m_xmlTransformStatistics = null;
    private List<JvmServerStatistics> m_jvmServerStatistics = null;
    private List<PublicJvmProgramStatistics> m_publicJvmProgramStatistics = null;
    private List<PublicProgramdefStatistics> m_publicProgramdefStatistics = null;
    private List<EventbindingGlobalStatistics> m_eventbindingGlobalStatistics = null;
    private List<EventBindingResourceStatistics> m_eventBindingResourceStatistics = null;
    private List<EventProcessGlobalStatistics> m_eventProcessGlobalStatistics = null;
    private List<CapturespecResourceStatistics> m_capturespecResourceStatistics = null;
    private List<EventProcessResourceStatistics> m_eventProcessResourceStatistics = null;
    private List<PolicyStatistics> m_policyStatistics = null;
    private List<PrivateJvmProgramStatistics> m_privateJvmProgramStatistics = null;
    private List<PrivateProgramdefStatistics> m_privateProgramdefStatistics = null;
    private List<MqMonitorStatistics> m_mqMonitorStatistics = null;
    private List<AsynchronousServiceGlobalStatistics> m_asynchronousServiceGlobalStatistics = null;
    private List<NodeJsAppStatistics> m_nodeJsAppStatistics = null;
    private List<TlsCipherStatistics> m_tlsCipherStatistics = null;
    private List<XqListStructureStatistics> m_xqListStructureStatistics = null;
    private List<XqQueueBufferPoolStatistics> m_xqQueueBufferPoolStatistics = null;
    private List<XqServerStorageStatistics> m_xqServerStorageStatistics = null;
    private List<CfListStructureStatistics> m_cfListStructureStatistics = null;
    private List<CfTableStatistics> m_cfTableStatistics = null;
    private List<CfRequestStatistics> m_cfRequestStatistics = null;
    private List<CfServerStorageStatistics> m_cfServerStorageStatistics = null;
    private List<NcListStructureStatistics> m_ncListStructureStatistics = null;
    private List<NcStorageStatistics> m_ncStorageStatistics = null;
    private CicsInstanceId cicsInstance;
    private JcProductSection m_JcProductSection = null;
    private MnProductSection m_MnProductSection = null;
    private MnHeader m_MnHeader = null;
    private StProductSection m_StProductSection = null;
    private List<StatisticsDataSection> m_statisticsDataSection = null;
    private List<DictionaryEntry> m_DictionaryEntries = null;
    private Dictionary m_Dictionary = null;
    private List<Integer> m_FieldConnectors = null;
    private List<PerformanceRecord> m_PerformanceRecords = null;
    private List<ExceptionData> m_ExceptionData = null;
    private List<TransactionResourceRecord> m_TransactionResourceRecord = null;
    private List<IdentityRecord> m_IdentityRecord = null;
    public static final int SMFESA = 192;
    public static final int SMFJCSTY = 0;
    public static final int SMFMNSTY = 1;
    public static final int SMFSTSTY = 2;
    public static final int SMFXQSTY = 3;
    public static final int SMFCFSTY = 4;
    public static final int SMFNCSTY = 5;

    public Smf110Record(byte[] data) {
        super(data);
        if (this.recordType() != 110) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
        this.init();
    }

    public Smf110Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 110) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
        if (record instanceof Smf110Record) {
            Smf110Record orig = (Smf110Record)record;
            this.originalData = orig.originalData;
            this.m_Dictionary = orig.m_Dictionary;
            this.cicsInstance = orig.cicsInstance;
            this.originalCompressedLength = orig.originalCompressedLength;
        } else {
            this.init();
        }
    }

    public static Smf110Record from(SmfRecord record) {
        return new Smf110Record(record);
    }

    public static Smf110Record from(byte[] data) {
        return new Smf110Record(data);
    }

    private void init() {
        this.originalData = this.data;
        if (this.smfmnsty() && this.mnProductSection().monitoringClassDictionary()) {
            this.m_Dictionary = Dictionary.create(this.dictionaryEntries(), this.cicsInstance());
            CicsDictionaryCollection.putDictionary(this.m_Dictionary.getCicsInstance(), this.m_Dictionary);
        }
    }

    @Override
    public int hashCode() {
        if (this.hashcode == 0) {
            this.hashcode = Arrays.hashCode(this.originalData);
        }
        return this.hashcode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Smf110Record other = (Smf110Record)obj;
        return Arrays.equals(this.originalData, other.originalData);
    }

    public boolean usedCompression() {
        return this.compressed() || this.originalCompressedLength > 0;
    }

    public boolean compressed() {
        return this.smfmnsty() && this.mnProductSection().smfmncrl() > 0;
    }

    private void checkCompression() {
        if (this.compressed()) {
            this.originalCompressedLength = this.mnProductSection().smfmncrl();
            compressedByteCount.addAndGet(this.originalCompressedLength);
            byte[] newdata = new byte[32760];
            System.arraycopy(this.data, 0, newdata, 0, this.smfass());
            int decompressed = Csrcesrv.decompress(this.data, newdata, this.smfass(), this.mnProductSection().smfmncrl(), this.smfass());
            Util.WriteUnsignedBinary2(newdata, 0, this.smfass() + decompressed);
            int crlOffset = this.smfaps() + MnProductSection.Field.smfmncrl.offset();
            Util.WriteUnsignedBinary2(newdata, crlOffset, 0);
            this.mnProductSection().clearCompression();
            Util.WriteUnsignedBinary2(newdata, Field.smfasl.offset, decompressed);
            decompressedByteCount.addAndGet(decompressed);
            this.data = newdata;
        }
    }

    @Override
    protected byte[] getDataArray() {
        return this.originalData;
    }

    public Smf110Record decompress() {
        this.checkCompression();
        return new Smf110Record(Arrays.copyOfRange(this.data, 0, this.recordLength()));
    }

    public static int dictionariesFromDD(String ddname) throws IOException {
        try (SmfRecordReader reader = SmfRecordReader.fromDD(ddname).include(110, 1);){
            int n = Smf110Record.loadDictionaries(reader);
            return n;
        }
    }

    public static int dictionariesFromName(String name) throws FileNotFoundException, IOException {
        try (SmfRecordReader reader = SmfRecordReader.fromName(name).include(110, 1);){
            int n = Smf110Record.loadDictionaries(reader);
            return n;
        }
    }

    public static int dictionariesFromStream(InputStream stream) throws IOException {
        try (SmfRecordReader reader = SmfRecordReader.fromStream(stream).include(110, 1);){
            int n = Smf110Record.loadDictionaries(reader);
            return n;
        }
    }

    private static int loadDictionaries(SmfRecordReader reader) {
        int count = 0;
        for (SmfRecord record : reader) {
            Smf110Record r110 = Smf110Record.from(record);
            if (!r110.mnProductSection().monitoringClassDictionary()) continue;
            ++count;
        }
        return count;
    }

    public CicsInstanceId cicsInstance() {
        if (this.cicsInstance == null) {
            this.cicsInstance = new CicsInstanceId(this);
        }
        return this.cicsInstance;
    }

    public JcProductSection jcProductSection() {
        if (this.m_JcProductSection == null) {
            if (!this.smfjcsty()) {
                throw new NotAvailableException("This method is only supported for  JC (subtype 0) records");
            }
            this.m_JcProductSection = JcProductSection.create(this.data, this.smfaps(), this.smflps());
        }
        return this.m_JcProductSection;
    }

    public MnProductSection mnProductSection() {
        if (this.m_MnProductSection == null) {
            if (!this.smfmnsty()) {
                throw new NotAvailableException("This method is only supported for MN (subtype 1) records");
            }
            this.m_MnProductSection = MnProductSection.create(this.data, this.smfaps(), this.smflps());
        }
        return this.m_MnProductSection;
    }

    public MnHeader mnHeader() {
        if (this.m_MnHeader == null) {
            if (!this.smfmnsty()) {
                throw new NotAvailableException("This method is only supported for MN (subtype 1) records");
            }
            this.m_MnHeader = MnHeader.create(this);
        }
        return this.m_MnHeader;
    }

    public StProductSection stProductSection() {
        if (this.m_StProductSection == null) {
            if (!(this.smfststy() || this.smfxqsty() || this.smfcfsty() || this.smfncsty())) {
                throw new NotAvailableException("This method is only supported for ST, XQ, CF and NC (subtypes 2,3,4,5) records");
            }
            this.m_StProductSection = StProductSection.create(this.data, this.smfaps(), this.smflps());
        }
        return this.m_StProductSection;
    }

    public List<StatisticsDataSection> statisticsDataSections() {
        if (this.m_statisticsDataSection == null) {
            int length;
            if (!(this.smfststy() || this.smfxqsty() || this.smfcfsty() || this.smfncsty())) {
                return Collections.emptyList();
            }
            this.m_statisticsDataSection = new ArrayList<StatisticsDataSection>();
            int datastart = this.smfass();
            int totalLength = this.smfasl();
            int smfstrvn = this.stProductSection().smfstrvn();
            for (int ixData = 0; ixData < totalLength; ixData += length) {
                length = StatisticsDataSection.stilen(this.data, datastart + ixData);
                this.m_statisticsDataSection.add(StatisticsDataSection.create(this.data, datastart + ixData, length, smfstrvn));
            }
        }
        return this.m_statisticsDataSection;
    }

    public List<TransactionManagerGlobalStatistics> transactionManagerGlobalStatistics() {
        this.m_transactionManagerGlobalStatistics = this.statisticsSections(this.m_transactionManagerGlobalStatistics, TransactionManagerGlobalStatistics::create, 10);
        return this.m_transactionManagerGlobalStatistics;
    }

    public List<TransactionManagerTransactionStatistics> transactionManagerTransactionStatistics() {
        this.m_transactionManagerTransactionStatistics = this.statisticsSections(this.m_transactionManagerTransactionStatistics, TransactionManagerTransactionStatistics::create, 11);
        return this.m_transactionManagerTransactionStatistics;
    }

    public List<TransactionManagerTclassStatistics> transactionManagerTclassStatistics() {
        this.m_transactionManagerTclassStatistics = this.statisticsSections(this.m_transactionManagerTclassStatistics, TransactionManagerTclassStatistics::create, 12);
        return this.m_transactionManagerTclassStatistics;
    }

    public List<StorageDomainSubpoolStatistics> storageDomainSubpoolStatistics() {
        this.m_storageDomainSubpoolStatistics = this.statisticsSections(this.m_storageDomainSubpoolStatistics, StorageDomainSubpoolStatistics::create, 19);
        return this.m_storageDomainSubpoolStatistics;
    }

    public List<FepiPoolStatistics> fepiPoolStatistics() {
        this.m_fepiPoolStatistics = this.statisticsSections(this.m_fepiPoolStatistics, FepiPoolStatistics::create, 16);
        return this.m_fepiPoolStatistics;
    }

    public List<FepiConnectionStatistics> fepiConnectionStatistics() {
        this.m_fepiConnectionStatistics = this.statisticsSections(this.m_fepiConnectionStatistics, FepiConnectionStatistics::create, 17);
        return this.m_fepiConnectionStatistics;
    }

    public List<FepiTargetStatistics> fepiTargetStatistics() {
        this.m_fepiTargetStatistics = this.statisticsSections(this.m_fepiTargetStatistics, FepiTargetStatistics::create, 18);
        return this.m_fepiTargetStatistics;
    }

    public List<StorageTaskSubpoolStatistics> storageTaskSubpoolStatistics() {
        this.m_storageTaskSubpoolStatistics = this.statisticsSections(this.m_storageTaskSubpoolStatistics, StorageTaskSubpoolStatistics::create, 20);
        return this.m_storageTaskSubpoolStatistics;
    }

    public List<StorageTaskSubpoolStatisticsEntry> storageTaskSubpoolStatisticsEntries() {
        if (this.m_storageTaskSubpoolStatisticsEntries != null) {
            return this.m_storageTaskSubpoolStatisticsEntries;
        }
        ArrayList<StorageTaskSubpoolStatisticsEntry> result = new ArrayList<StorageTaskSubpoolStatisticsEntry>();
        for (StorageTaskSubpoolStatistics h : this.storageTaskSubpoolStatistics()) {
            result.addAll(h.storageTaskSubpoolStatisticsEntries());
        }
        this.m_storageTaskSubpoolStatisticsEntries = Collections.unmodifiableList(result);
        return this.m_storageTaskSubpoolStatisticsEntries;
    }

    public List<VtamGlobalStatistics> vtamGlobalStatistics() {
        this.m_vtamGlobalStatistics = this.statisticsSections(this.m_vtamGlobalStatistics, VtamGlobalStatistics::create, 21);
        return this.m_vtamGlobalStatistics;
    }

    public List<ProgramManagerGlobalStatistics> programManagerGlobalStatistics() {
        this.m_programManagerGlobalStatistics = this.statisticsSections(this.m_programManagerGlobalStatistics, ProgramManagerGlobalStatistics::create, 23);
        return this.m_programManagerGlobalStatistics;
    }

    public List<TerminalAutoinstallStatistics> terminalAutoinstallStatistics() {
        this.m_terminalAutoinstallStatistics = this.statisticsSections(this.m_terminalAutoinstallStatistics, TerminalAutoinstallStatistics::create, 24);
        return this.m_terminalAutoinstallStatistics;
    }

    public List<LoaderPublicProgramStatistics> loaderPublicProgramStatistics() {
        this.m_loaderPublicProgramStatistics = this.statisticsSections(this.m_loaderPublicProgramStatistics, LoaderPublicProgramStatistics::create, 25);
        return this.m_loaderPublicProgramStatistics;
    }

    public List<DbctlUnsolicitedStatistics> dbctlUnsolicitedStatistics() {
        this.m_dbctlUnsolicitedStatistics = this.statisticsSections(this.m_dbctlUnsolicitedStatistics, DbctlUnsolicitedStatistics::create, 28);
        return this.m_dbctlUnsolicitedStatistics;
    }

    public List<StorageManagerStatistics> storageManagerStatistics() {
        this.m_storageManagerStatistics = this.statisticsSections(this.m_storageManagerStatistics, StorageManagerStatistics::create, 29);
        return this.m_storageManagerStatistics;
    }

    public List<StorageManagerGlobalStatistics> storageManagerGlobalStatistics() {
        if (this.m_storageManagerGlobalStatistics != null) {
            return this.m_storageManagerGlobalStatistics;
        }
        ArrayList<StorageManagerGlobalStatistics> result = new ArrayList<StorageManagerGlobalStatistics>();
        for (StorageManagerStatistics h : this.storageManagerStatistics()) {
            result.add(h.storageManagerGlobalStatistics());
        }
        this.m_storageManagerGlobalStatistics = Collections.unmodifiableList(result);
        return this.m_storageManagerGlobalStatistics;
    }

    public List<StorageManagerDsaStatistics> storageManagerDsaStatistics() {
        if (this.m_storageManagerDsaStatistics != null) {
            return this.m_storageManagerDsaStatistics;
        }
        ArrayList<StorageManagerDsaStatistics> result = new ArrayList<StorageManagerDsaStatistics>();
        for (StorageManagerStatistics h : this.storageManagerStatistics()) {
            result.addAll(h.storageManagerDsaStatistics());
        }
        this.m_storageManagerDsaStatistics = Collections.unmodifiableList(result);
        return this.m_storageManagerDsaStatistics;
    }

    public List<LoaderGlobalStatistics> loaderGlobalStatistics() {
        this.m_loaderGlobalStatistics = this.statisticsSections(this.m_loaderGlobalStatistics, LoaderGlobalStatistics::create, 30);
        return this.m_loaderGlobalStatistics;
    }

    public List<LoaderGlobalDsaStatistics> loaderGlobalDsaStatistics() {
        if (this.m_loaderGlobalDsaStatistics != null) {
            return this.m_loaderGlobalDsaStatistics;
        }
        ArrayList<LoaderGlobalDsaStatistics> result = new ArrayList<LoaderGlobalDsaStatistics>();
        for (LoaderGlobalStatistics h : this.loaderGlobalStatistics()) {
            result.addAll(h.loaderGlobalDsaStatistics());
        }
        this.m_loaderGlobalDsaStatistics = Collections.unmodifiableList(result);
        return this.m_loaderGlobalDsaStatistics;
    }

    public List<LoaderPublicLibraryStatistics> loaderPublicLibraryStatistics() {
        this.m_loaderPublicLibraryStatistics = this.statisticsSections(this.m_loaderPublicLibraryStatistics, LoaderPublicLibraryStatistics::create, 31);
        return this.m_loaderPublicLibraryStatistics;
    }

    public List<LoaderPrivateLibraryStatistics> loaderPrivateLibraryStatistics() {
        this.m_loaderPrivateLibraryStatistics = this.statisticsSections(this.m_loaderPrivateLibraryStatistics, LoaderPrivateLibraryStatistics::create, 32);
        return this.m_loaderPrivateLibraryStatistics;
    }

    public List<TerminalStatistics> terminalResidStatistics() {
        this.m_terminalResidStatistics = this.statisticsSections(this.m_terminalResidStatistics, TerminalStatistics::create, 34);
        return this.m_terminalResidStatistics;
    }

    public List<TerminalStatistics> terminalBtamLineStatistics() {
        this.m_terminalBtamLineStatistics = this.statisticsSections(this.m_terminalBtamLineStatistics, TerminalStatistics::create, 82);
        return this.m_terminalBtamLineStatistics;
    }

    public List<LoaderPrivateProgramStatistics> loaderPrivateProgramStatistics() {
        this.m_loaderPrivateProgramStatistics = this.statisticsSections(this.m_loaderPrivateProgramStatistics, LoaderPrivateProgramStatistics::create, 36);
        return this.m_loaderPrivateProgramStatistics;
    }

    public List<LsrPoolStatistics> lsrPoolStatistics() {
        this.m_lsrPoolStatistics = this.statisticsSections(this.m_lsrPoolStatistics, LsrPoolStatistics::create, 39);
        return this.m_lsrPoolStatistics;
    }

    public List<LsrPoolFileStatistics> lsrPoolFileStatistics() {
        this.m_lsrPoolFileStatistics = this.statisticsSections(this.m_lsrPoolFileStatistics, LsrPoolFileStatistics::create, 40);
        return this.m_lsrPoolFileStatistics;
    }

    public List<LsrPoolFileStatistics> lsrPoolFileTotals() {
        this.m_lsrPoolFileTotals = this.statisticsSections(this.m_lsrPoolFileTotals, LsrPoolFileStatistics::create, 41);
        return this.m_lsrPoolFileTotals;
    }

    @Deprecated
    public List<LsrPoolFileStatistics> LsrPoolFileTotals() {
        return this.lsrPoolFileTotals();
    }

    public List<TransientDataQueueStatistics> transientDataQueueStatistics() {
        this.m_transientDataQueueStatistics = this.statisticsSections(this.m_transientDataQueueStatistics, TransientDataQueueStatistics::create, 42);
        return this.m_transientDataQueueStatistics;
    }

    public List<TransientDataGlobalStatistics> transientDataGlobalStatistics() {
        this.m_transientDataGlobalStatistics = this.statisticsSections(this.m_transientDataGlobalStatistics, TransientDataGlobalStatistics::create, 45);
        return this.m_transientDataGlobalStatistics;
    }

    public List<SecurityDomainGlobalStatistics> securityDomainGlobalStatistics() {
        this.m_securityDomainGlobalStatistics = this.statisticsSections(this.m_securityDomainGlobalStatistics, SecurityDomainGlobalStatistics::create, 46);
        return this.m_securityDomainGlobalStatistics;
    }

    public List<TemporaryStorageStatistics> temporaryStorageStatistics() {
        this.m_temporaryStorageStatistics = this.statisticsSections(this.m_temporaryStorageStatistics, TemporaryStorageStatistics::create, 48);
        return this.m_temporaryStorageStatistics;
    }

    public List<IscIrcSystemStatistics> iscIrcSystemStatistics() {
        this.m_iscIrcSystemStatistics = this.statisticsSections(this.m_iscIrcSystemStatistics, IscIrcSystemStatistics::create, 52);
        return this.m_iscIrcSystemStatistics;
    }

    public List<IscIrcSystemStatistics> iscIrcSystemTotals() {
        this.m_iscIrcSystemTotals = this.statisticsSections(this.m_iscIrcSystemTotals, IscIrcSystemStatistics::create, 53);
        return this.m_iscIrcSystemTotals;
    }

    public List<IscLuitSntStatistics> iscLuitSntStatistics() {
        this.m_iscLuitSntStatistics = this.statisticsSections(this.m_iscLuitSntStatistics, IscLuitSntStatistics::create, 54);
        return this.m_iscLuitSntStatistics;
    }

    public List<UserDomainGlobalStatistics> userDomainGlobalStatistics() {
        this.m_userDomainGlobalStatistics = this.statisticsSections(this.m_userDomainGlobalStatistics, UserDomainGlobalStatistics::create, 61);
        return this.m_userDomainGlobalStatistics;
    }

    public List<com.blackhillsoftware.smf.cics.statistics.DispatcherGlobalStatistics> dispatcherGlobalStatistics() {
        if (this.m_dispatcherGlobalStatistics != null) {
            return this.m_dispatcherGlobalStatistics;
        }
        if (this.smfststy() || this.smfxqsty() || this.smfcfsty() || this.smfncsty()) {
            if (this.stProductSection().smfstrvn() >= 1680) {
                this.m_dispatcherGlobalStatistics = this.statisticsSections(this.m_dispatcherGlobalStatistics, com.blackhillsoftware.smf.cics.statistics.DispatcherGlobalStatistics::create, 62);
                return this.m_dispatcherGlobalStatistics;
            }
            if (this.stProductSection().smfstrvn() >= 1664) {
                this.m_dispatcherGlobalStatistics = this.statisticsSections(this.m_dispatcherGlobalStatistics, DispatcherGlobalStatistics::create, 62);
                return this.m_dispatcherGlobalStatistics;
            }
            this.m_dispatcherGlobalStatistics = this.statisticsSections(this.m_dispatcherGlobalStatistics, com.blackhillsoftware.smf.cics.statistics.cics420.DispatcherGlobalStatistics::create, 60);
            return this.m_dispatcherGlobalStatistics;
        }
        this.m_dispatcherGlobalStatistics = Collections.emptyList();
        return this.m_dispatcherGlobalStatistics;
    }

    public List<TableManagerGlobalStatistics> tableManagerGlobalStatistics() {
        this.m_tableManagerGlobalStatistics = this.statisticsSections(this.m_tableManagerGlobalStatistics, TableManagerGlobalStatistics::create, 63);
        return this.m_tableManagerGlobalStatistics;
    }

    public List<TableManagerTableStatistics> tableManagerTableStatistics() {
        if (this.m_tableManagerTableStatistics != null) {
            return this.m_tableManagerTableStatistics;
        }
        ArrayList<TableManagerTableStatistics> result = new ArrayList<TableManagerTableStatistics>();
        for (TableManagerGlobalStatistics h : this.tableManagerGlobalStatistics()) {
            result.addAll(h.tableStatistics());
        }
        this.m_tableManagerTableStatistics = Collections.unmodifiableList(result);
        return this.m_tableManagerTableStatistics;
    }

    public List<DispatcherMvsTcbGlobalStatistics> dispatcherMvsTcbGlobalStatistics() {
        this.m_dispatcherMvsTcbGlobalStatistics = this.statisticsSections(this.m_dispatcherMvsTcbGlobalStatistics, DispatcherMvsTcbGlobalStatistics::create, 64);
        return this.m_dispatcherMvsTcbGlobalStatistics;
    }

    public List<DispatcherMvsTcbResourceStatistics> dispatcherMvsTcbResourceStatistics() {
        this.m_dispatcherMvsTcbResourceStatistics = this.statisticsSections(this.m_dispatcherMvsTcbResourceStatistics, DispatcherMvsTcbResourceStatistics::create, 65);
        return this.m_dispatcherMvsTcbResourceStatistics;
    }

    public List<StatisticsStatistics> statisticsStatistics() {
        this.m_statisticsStatistics = this.statisticsSections(this.m_statisticsStatistics, StatisticsStatistics::create, 66);
        return this.m_statisticsStatistics;
    }

    public List<FileControlStatistics> fileControlStatistics() {
        this.m_fileControlStatistics = this.statisticsSections(this.m_fileControlStatistics, FileControlStatistics::create, 67);
        return this.m_fileControlStatistics;
    }

    public List<MqConnectionGlobalStatistics> mqConnectionGlobalStatistics() {
        this.m_mqConnectionGlobalStatistics = this.statisticsSections(this.m_mqConnectionGlobalStatistics, MqConnectionGlobalStatistics::create, 74);
        return this.m_mqConnectionGlobalStatistics;
    }

    public List<IscIrcModeStatistics> iscIrcModeStatistics() {
        this.m_iscIrcModeStatistics = this.statisticsSections(this.m_iscIrcModeStatistics, IscIrcModeStatistics::create, 76);
        return this.m_iscIrcModeStatistics;
    }

    public List<MonitoringGlobalStatistics> monitoringGlobalStatistics() {
        this.m_monitoringGlobalStatistics = this.statisticsSections(this.m_monitoringGlobalStatistics, MonitoringGlobalStatistics::create, 81);
        return this.m_monitoringGlobalStatistics;
    }

    public List<com.blackhillsoftware.smf.cics.statistics.MonitoringTransactionStatistics> monitoringTransactionStatistics() {
        if (this.m_monitoringTransactionStatistics != null) {
            return this.m_monitoringTransactionStatistics;
        }
        if (this.smfststy() || this.smfxqsty() || this.smfcfsty() || this.smfncsty()) {
            if (this.stProductSection().smfstrvn() >= 1872) {
                this.m_monitoringTransactionStatistics = this.statisticsSections(this.m_monitoringTransactionStatistics, com.blackhillsoftware.smf.cics.statistics.MonitoringTransactionStatistics::create, 84);
                return this.m_monitoringTransactionStatistics;
            }
            if (this.stProductSection().smfstrvn() >= 1856) {
                this.m_monitoringTransactionStatistics = this.statisticsSections(this.m_monitoringTransactionStatistics, com.blackhillsoftware.smf.cics.statistics.cics610.MonitoringTransactionStatistics::create, 84);
                return this.m_monitoringTransactionStatistics;
            }
            if (this.stProductSection().smfstrvn() >= 1840) {
                this.m_monitoringTransactionStatistics = this.statisticsSections(this.m_monitoringTransactionStatistics, com.blackhillsoftware.smf.cics.statistics.cics560.MonitoringTransactionStatistics::create, 84);
                return this.m_monitoringTransactionStatistics;
            }
            if (this.stProductSection().smfstrvn() >= 1824) {
                this.m_monitoringTransactionStatistics = this.statisticsSections(this.m_monitoringTransactionStatistics, com.blackhillsoftware.smf.cics.statistics.cics550.MonitoringTransactionStatistics::create, 84);
                return this.m_monitoringTransactionStatistics;
            }
            if (this.stProductSection().smfstrvn() >= 1808) {
                this.m_monitoringTransactionStatistics = this.statisticsSections(this.m_monitoringTransactionStatistics, com.blackhillsoftware.smf.cics.statistics.cics540.MonitoringTransactionStatistics::create, 84);
                return this.m_monitoringTransactionStatistics;
            }
            if (this.stProductSection().smfstrvn() >= 1792) {
                this.m_monitoringTransactionStatistics = this.statisticsSections(this.m_monitoringTransactionStatistics, MonitoringTransactionStatistics::create, 84);
                return this.m_monitoringTransactionStatistics;
            }
            if (this.stProductSection().smfstrvn() >= 1664) {
                this.m_monitoringTransactionStatistics = this.statisticsSections(this.m_monitoringTransactionStatistics, com.blackhillsoftware.smf.cics.statistics.cics510.MonitoringTransactionStatistics::create, 84);
                return this.m_monitoringTransactionStatistics;
            }
            this.m_monitoringTransactionStatistics = this.statisticsSections(this.m_monitoringTransactionStatistics, com.blackhillsoftware.smf.cics.statistics.cics420.MonitoringTransactionStatistics::create, 84);
            return this.m_monitoringTransactionStatistics;
        }
        return Collections.emptyList();
    }

    public List<TransactionDumpcodeStatistics> transactionDumpcodeStatistics() {
        this.m_transactionDumpcodeStatistics = this.statisticsSections(this.m_transactionDumpcodeStatistics, TransactionDumpcodeStatistics::create, 85);
        return this.m_transactionDumpcodeStatistics;
    }

    public List<TransactionDumpGlobalStatistics> transactionDumpGlobalStatistics() {
        this.m_transactionDumpGlobalStatistics = this.statisticsSections(this.m_transactionDumpGlobalStatistics, TransactionDumpGlobalStatistics::create, 87);
        return this.m_transactionDumpGlobalStatistics;
    }

    public List<SystemDumpcodeStatistics> systemDumpcodeStatistics() {
        this.m_systemDumpcodeStatistics = this.statisticsSections(this.m_systemDumpcodeStatistics, SystemDumpcodeStatistics::create, 88);
        return this.m_systemDumpcodeStatistics;
    }

    public List<SystemDumpGlobalStatistics> systemDumpGlobalStatistics() {
        this.m_systemDumpGlobalStatistics = this.statisticsSections(this.m_systemDumpGlobalStatistics, SystemDumpGlobalStatistics::create, 90);
        return this.m_systemDumpGlobalStatistics;
    }

    public List<LogManagerGlobalStatistics> logManagerGlobalStatistics() {
        this.m_logManagerGlobalStatistics = this.statisticsSections(this.m_logManagerGlobalStatistics, LogManagerGlobalStatistics::create, 92);
        return this.m_logManagerGlobalStatistics;
    }

    public List<LogManagerJournalStatistics> logManagerJournalStatistics() {
        this.m_logManagerJournalStatistics = this.statisticsSections(this.m_logManagerJournalStatistics, LogManagerJournalStatistics::create, 93);
        return this.m_logManagerJournalStatistics;
    }

    public List<LogManagerLogstreamStatistics> logManagerLogstreamStatistics() {
        this.m_logManagerLogstreamStatistics = this.statisticsSections(this.m_logManagerLogstreamStatistics, LogManagerLogstreamStatistics::create, 94);
        return this.m_logManagerLogstreamStatistics;
    }

    public List<EnqueueManagerGlobalStatistics> enqueueManagerGlobalStatistics() {
        this.m_enqueueManagerGlobalStatistics = this.statisticsSections(this.m_enqueueManagerGlobalStatistics, EnqueueManagerGlobalStatistics::create, 97);
        return this.m_enqueueManagerGlobalStatistics;
    }

    public List<EnqueuePoolStatistics> enqueuePoolStatistics() {
        if (this.m_enqueuePoolStatistics != null) {
            return this.m_enqueuePoolStatistics;
        }
        ArrayList<EnqueuePoolStatistics> result = new ArrayList<EnqueuePoolStatistics>();
        for (EnqueueManagerGlobalStatistics h : this.enqueueManagerGlobalStatistics()) {
            result.addAll(h.enqueuePoolStatistics());
        }
        this.m_enqueuePoolStatistics = Collections.unmodifiableList(result);
        return this.m_enqueuePoolStatistics;
    }

    public List<RecoveryManagerGlobalStatistics> recoveryManagerGlobalStatistics() {
        this.m_recoveryManagerGlobalStatistics = this.statisticsSections(this.m_recoveryManagerGlobalStatistics, RecoveryManagerGlobalStatistics::create, 99);
        return this.m_recoveryManagerGlobalStatistics;
    }

    public List<ResLifeBundleStatistics> resLifeBundleStatistics() {
        this.m_resLifeBundleStatistics = this.statisticsSections(this.m_resLifeBundleStatistics, ResLifeBundleStatistics::create, 100);
        return this.m_resLifeBundleStatistics;
    }

    public List<WebUrimapGlobalStatistics> webUrimapGlobalStatistics() {
        this.m_webUrimapGlobalStatistics = this.statisticsSections(this.m_webUrimapGlobalStatistics, WebUrimapGlobalStatistics::create, 101);
        return this.m_webUrimapGlobalStatistics;
    }

    public List<Db2GlobalStatistics> db2GlobalStatistics() {
        this.m_db2GlobalStatistics = this.statisticsSections(this.m_db2GlobalStatistics, Db2GlobalStatistics::create, 102);
        return this.m_db2GlobalStatistics;
    }

    public List<Db2ResourceStatistics> db2ResourceStatistics() {
        this.m_db2ResourceStatistics = this.statisticsSections(this.m_db2ResourceStatistics, Db2ResourceStatistics::create, 103);
        return this.m_db2ResourceStatistics;
    }

    public List<WebUrimapResourceStatistics> webUrimapResourceStatistics() {
        this.m_webUrimapResourceStatistics = this.statisticsSections(this.m_webUrimapResourceStatistics, WebUrimapResourceStatistics::create, 104);
        return this.m_webUrimapResourceStatistics;
    }

    public List<PipelineStatistics> pipelineStatistics() {
        this.m_pipelineStatistics = this.statisticsSections(this.m_pipelineStatistics, PipelineStatistics::create, 105);
        return this.m_pipelineStatistics;
    }

    public List<PipelineWebserviceStatistics> pipelineWebserviceStatistics() {
        this.m_pipelineWebserviceStatistics = this.statisticsSections(this.m_pipelineWebserviceStatistics, PipelineWebserviceStatistics::create, 106);
        return this.m_pipelineWebserviceStatistics;
    }

    public List<SocketsGlobalStatistics> socketsGlobalStatistics() {
        this.m_socketsGlobalStatistics = this.statisticsSections(this.m_socketsGlobalStatistics, SocketsGlobalStatistics::create, 107);
        return this.m_socketsGlobalStatistics;
    }

    public List<SocketsServiceStatistics> socketsServiceStatistics() {
        this.m_socketsServiceStatistics = this.statisticsSections(this.m_socketsServiceStatistics, SocketsServiceStatistics::create, 108);
        return this.m_socketsServiceStatistics;
    }

    public List<IpconnStatistics> ipconnStatistics() {
        this.m_ipconnStatistics = this.statisticsSections(this.m_ipconnStatistics, IpconnStatistics::create, 109);
        return this.m_ipconnStatistics;
    }

    public List<AtomserviceStatistics> atomserviceStatistics() {
        this.m_atomserviceStatistics = this.statisticsSections(this.m_atomserviceStatistics, AtomserviceStatistics::create, 110);
        return this.m_atomserviceStatistics;
    }

    public List<DoctemplateResourceStatistics> doctemplateResourceStatistics() {
        this.m_doctemplateResourceStatistics = this.statisticsSections(this.m_doctemplateResourceStatistics, DoctemplateResourceStatistics::create, 112);
        return this.m_doctemplateResourceStatistics;
    }

    public List<XmlTransformStatistics> xmlTransformStatistics() {
        this.m_xmlTransformStatistics = this.statisticsSections(this.m_xmlTransformStatistics, XmlTransformStatistics::create, 113);
        return this.m_xmlTransformStatistics;
    }

    public List<JvmServerStatistics> jvmServerStatistics() {
        this.m_jvmServerStatistics = this.statisticsSections(this.m_jvmServerStatistics, JvmServerStatistics::create, 116);
        return this.m_jvmServerStatistics;
    }

    public List<PublicJvmProgramStatistics> publicJvmProgramStatistics() {
        this.m_publicJvmProgramStatistics = this.statisticsSections(this.m_publicJvmProgramStatistics, PublicJvmProgramStatistics::create, 119);
        return this.m_publicJvmProgramStatistics;
    }

    public List<PublicProgramdefStatistics> publicProgramdefStatistics() {
        this.m_publicProgramdefStatistics = this.statisticsSections(this.m_publicProgramdefStatistics, PublicProgramdefStatistics::create, 120);
        return this.m_publicProgramdefStatistics;
    }

    public List<EventbindingGlobalStatistics> eventbindingGlobalStatistics() {
        this.m_eventbindingGlobalStatistics = this.statisticsSections(this.m_eventbindingGlobalStatistics, EventbindingGlobalStatistics::create, 140);
        return this.m_eventbindingGlobalStatistics;
    }

    public List<EventBindingResourceStatistics> eventBindingResourceStatistics() {
        this.m_eventBindingResourceStatistics = this.statisticsSections(this.m_eventBindingResourceStatistics, EventBindingResourceStatistics::create, 141);
        return this.m_eventBindingResourceStatistics;
    }

    public List<EventProcessGlobalStatistics> eventProcessGlobalStatistics() {
        this.m_eventProcessGlobalStatistics = this.statisticsSections(this.m_eventProcessGlobalStatistics, EventProcessGlobalStatistics::create, 142);
        return this.m_eventProcessGlobalStatistics;
    }

    public List<CapturespecResourceStatistics> capturespecResourceStatistics() {
        this.m_capturespecResourceStatistics = this.statisticsSections(this.m_capturespecResourceStatistics, CapturespecResourceStatistics::create, 143);
        return this.m_capturespecResourceStatistics;
    }

    public List<EventProcessResourceStatistics> eventProcessResourceStatistics() {
        this.m_eventProcessResourceStatistics = this.statisticsSections(this.m_eventProcessResourceStatistics, EventProcessResourceStatistics::create, 144);
        return this.m_eventProcessResourceStatistics;
    }

    public List<PolicyStatistics> policyStatistics() {
        this.m_policyStatistics = this.statisticsSections(this.m_policyStatistics, PolicyStatistics::create, 145);
        return this.m_policyStatistics;
    }

    public List<PrivateJvmProgramStatistics> privateJvmProgramStatistics() {
        this.m_privateJvmProgramStatistics = this.statisticsSections(this.m_privateJvmProgramStatistics, PrivateJvmProgramStatistics::create, 146);
        return this.m_privateJvmProgramStatistics;
    }

    public List<PrivateProgramdefStatistics> privateProgramdefStatistics() {
        this.m_privateProgramdefStatistics = this.statisticsSections(this.m_privateProgramdefStatistics, PrivateProgramdefStatistics::create, 147);
        return this.m_privateProgramdefStatistics;
    }

    public List<MqMonitorStatistics> mqMonitorStatistics() {
        this.m_mqMonitorStatistics = this.statisticsSections(this.m_mqMonitorStatistics, MqMonitorStatistics::create, 148);
        return this.m_mqMonitorStatistics;
    }

    public List<AsynchronousServiceGlobalStatistics> asynchronousServiceGlobalStatistics() {
        this.m_asynchronousServiceGlobalStatistics = this.statisticsSections(this.m_asynchronousServiceGlobalStatistics, AsynchronousServiceGlobalStatistics::create, 149);
        return this.m_asynchronousServiceGlobalStatistics;
    }

    public List<NodeJsAppStatistics> nodeJsAppStatistics() {
        this.m_nodeJsAppStatistics = this.statisticsSections(this.m_nodeJsAppStatistics, NodeJsAppStatistics::create, 150);
        return this.m_nodeJsAppStatistics;
    }

    public List<TlsCipherStatistics> tlsCipherStatistics() {
        this.m_tlsCipherStatistics = this.statisticsSections(this.m_tlsCipherStatistics, TlsCipherStatistics::create, 151);
        return this.m_tlsCipherStatistics;
    }

    public List<XqListStructureStatistics> xqListStructureStatistics() {
        this.m_xqListStructureStatistics = this.statisticsSections(this.m_xqListStructureStatistics, XqListStructureStatistics::create, 121);
        return this.m_xqListStructureStatistics;
    }

    public List<XqQueueBufferPoolStatistics> xqQueueBufferPoolStatistics() {
        this.m_xqQueueBufferPoolStatistics = this.statisticsSections(this.m_xqQueueBufferPoolStatistics, XqQueueBufferPoolStatistics::create, 122);
        return this.m_xqQueueBufferPoolStatistics;
    }

    public List<XqServerStorageStatistics> xqServerStorageStatistics() {
        this.m_xqServerStorageStatistics = this.statisticsSections(this.m_xqServerStorageStatistics, XqServerStorageStatistics::create, 123);
        return this.m_xqServerStorageStatistics;
    }

    public List<CfListStructureStatistics> cfListStructureStatistics() {
        this.m_cfListStructureStatistics = this.statisticsSections(this.m_cfListStructureStatistics, CfListStructureStatistics::create, 126);
        return this.m_cfListStructureStatistics;
    }

    public List<CfTableStatistics> cfTableStatistics() {
        this.m_cfTableStatistics = this.statisticsSections(this.m_cfTableStatistics, CfTableStatistics::create, 127);
        return this.m_cfTableStatistics;
    }

    public List<CfRequestStatistics> cfRequestStatistics() {
        this.m_cfRequestStatistics = this.statisticsSections(this.m_cfRequestStatistics, CfRequestStatistics::create, 128);
        return this.m_cfRequestStatistics;
    }

    public List<CfServerStorageStatistics> cfServerStorageStatistics() {
        this.m_cfServerStorageStatistics = this.statisticsSections(this.m_cfServerStorageStatistics, CfServerStorageStatistics::create, 129);
        return this.m_cfServerStorageStatistics;
    }

    public List<NcListStructureStatistics> ncListStructureStatistics() {
        this.m_ncListStructureStatistics = this.statisticsSections(this.m_ncListStructureStatistics, NcListStructureStatistics::create, 124);
        return this.m_ncListStructureStatistics;
    }

    public List<NcStorageStatistics> ncStorageStatistics() {
        this.m_ncStorageStatistics = this.statisticsSections(this.m_ncStorageStatistics, NcStorageStatistics::create, 125);
        return this.m_ncStorageStatistics;
    }

    private <T extends StatisticsDataSection> List<T> statisticsSections(List<T> current, CreateStatisticsSection<T> builder, int stid) {
        int length;
        if (current != null) {
            return current;
        }
        if (!(this.smfststy() || this.smfxqsty() || this.smfcfsty() || this.smfncsty())) {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>();
        int datastart = this.smfass();
        int totalLength = this.smfasl();
        for (int ixData = 0; ixData < totalLength; ixData += length) {
            length = StatisticsDataSection.stilen(this.data, datastart + ixData);
            if (StatisticsDataSection.stid(this.data, datastart + ixData) != stid) continue;
            result.add(builder.createStatisticsSection(this.data, datastart + ixData, length));
        }
        return Collections.unmodifiableList(result);
    }

    public List<DictionaryEntry> dictionaryEntries() {
        if (this.m_DictionaryEntries != null) {
            return this.m_DictionaryEntries;
        }
        if (!this.smfmnsty() || !this.mnProductSection().monitoringClassDictionary()) {
            return Collections.emptyList();
        }
        this.checkCompression();
        this.m_DictionaryEntries = Util.sectionsFromTriplet(this.m_DictionaryEntries, this.data, () -> this.mnProductSection().smfmndra(), () -> this.mnProductSection().smfmndrl(), () -> this.mnProductSection().smfmndrn(), DictionaryEntry::create);
        return this.m_DictionaryEntries;
    }

    public Dictionary dictionary() {
        if (this.m_Dictionary == null && this.smfmnsty()) {
            this.m_Dictionary = CicsDictionaryCollection.getDictionary(this.cicsInstance());
        }
        return this.m_Dictionary;
    }

    public boolean haveDictionary() {
        return this.dictionary() != null;
    }

    public List<Integer> fieldConnectors() {
        if (this.m_FieldConnectors != null) {
            return this.m_FieldConnectors;
        }
        if (!this.smfmnsty() || !this.mnProductSection().monitoringClassPerformance()) {
            this.m_FieldConnectors = Collections.emptyList();
            return this.m_FieldConnectors;
        }
        this.checkCompression();
        int offset = this.mnProductSection().smfmndca();
        int length = this.mnProductSection().smfmndcl();
        if (length != 2) {
            throw new RuntimeException("Invalid connector length: " + Integer.toString(length));
        }
        int count = this.mnProductSection().smfmndcn();
        ArrayList<Integer> result = new ArrayList<Integer>(count);
        for (int i = 0; i < count; ++i) {
            result.add(Util.ConvertUnsignedBinary2(this.data, offset + i * length));
        }
        this.m_FieldConnectors = Collections.unmodifiableList(result);
        return this.m_FieldConnectors;
    }

    public List<PerformanceRecord> performanceRecords() {
        if (this.m_PerformanceRecords != null) {
            return this.m_PerformanceRecords;
        }
        if (!this.smfmnsty() || !this.mnProductSection().monitoringClassPerformance()) {
            return Collections.emptyList();
        }
        this.checkCompression();
        int count = this.mnProductSection().smfmndrn();
        if (count == 0) {
            return Collections.emptyList();
        }
        int length = this.mnProductSection().smfmndrl();
        int offset = this.mnProductSection().smfmndra();
        ArrayList<PerformanceRecord> result = new ArrayList<PerformanceRecord>(count);
        Dictionary dict = this.dictionary();
        for (int i = 0; i < count; ++i) {
            result.add(PerformanceRecord.create(this.data, offset + i * length, length, this.cicsInstance(), dict, this.mnProductSection(), this.mnHeader()));
        }
        this.m_PerformanceRecords = Collections.unmodifiableList(result);
        return this.m_PerformanceRecords;
    }

    public List<ExceptionData> exceptionData() {
        if (this.m_ExceptionData != null) {
            return this.m_ExceptionData;
        }
        if (!this.smfmnsty() || !this.mnProductSection().monitoringClassException()) {
            return Collections.emptyList();
        }
        this.checkCompression();
        int count = this.mnProductSection().smfmndrn();
        if (count == 0) {
            return Collections.emptyList();
        }
        int length = this.mnProductSection().smfmndrl();
        int offset = this.mnProductSection().smfmndra();
        ArrayList<ExceptionData> result = new ArrayList<ExceptionData>(count);
        for (int i = 0; i < count; ++i) {
            result.add(ExceptionData.create(this.data, offset + i * length, length, this.mnProductSection(), this.mnHeader()));
        }
        this.m_ExceptionData = Collections.unmodifiableList(result);
        return this.m_ExceptionData;
    }

    public List<TransactionResourceRecord> transactionResourceRecords() {
        if (this.m_TransactionResourceRecord != null) {
            return this.m_TransactionResourceRecord;
        }
        if (!this.smfmnsty() || !this.mnProductSection().monitoringClassResource()) {
            return Collections.emptyList();
        }
        this.checkCompression();
        int offset = this.mnProductSection().smfmndra();
        int count = this.mnProductSection().smfmndrn();
        ArrayList<TransactionResourceRecord> result = new ArrayList<TransactionResourceRecord>(count);
        for (int i = 0; i < count; ++i) {
            int length = Util.ConvertUnsignedBinary2(this.data, offset);
            result.add(TransactionResourceRecord.create(this.data, offset, length));
            offset += length;
        }
        this.m_TransactionResourceRecord = Collections.unmodifiableList(result);
        return this.m_TransactionResourceRecord;
    }

    public List<IdentityRecord> identityRecords() {
        if (this.m_IdentityRecord != null) {
            return this.m_IdentityRecord;
        }
        if (!this.smfmnsty() || !this.mnProductSection().monitoringClassIdentity()) {
            return Collections.emptyList();
        }
        this.checkCompression();
        int offset = this.mnProductSection().smfmndra();
        int count = this.mnProductSection().smfmndrn();
        ArrayList<IdentityRecord> result = new ArrayList<IdentityRecord>(count);
        for (int i = 0; i < count; ++i) {
            int length = Util.ConvertUnsignedBinary2(this.data, offset);
            result.add(IdentityRecord.create(this.data, offset, length));
            offset += length;
        }
        this.m_IdentityRecord = Collections.unmodifiableList(result);
        return this.m_IdentityRecord;
    }

    public int smflen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smfseg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smfflg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public boolean smfesa() {
        return Util.ConvertEquateValue(this.data, this.smfflg(), 192);
    }

    public int smfrty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smftme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smftmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smfdte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smfdteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smfsid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smfssi() {
        return Util.ConvertEbcdic(this.data, 18, 4);
    }

    public int smfsty() {
        return Util.ConvertUnsignedBinary2(this.data, 22);
    }

    public boolean smfjcsty() {
        return Util.ConvertEquateValue(this.data, this.smfsty(), 0);
    }

    public boolean smfmnsty() {
        return Util.ConvertEquateValue(this.data, this.smfsty(), 1);
    }

    public boolean smfststy() {
        return Util.ConvertEquateValue(this.data, this.smfsty(), 2);
    }

    public boolean smfxqsty() {
        return Util.ConvertEquateValue(this.data, this.smfsty(), 3);
    }

    public boolean smfcfsty() {
        return Util.ConvertEquateValue(this.data, this.smfsty(), 4);
    }

    public boolean smfncsty() {
        return Util.ConvertEquateValue(this.data, this.smfsty(), 5);
    }

    public int smftrn() {
        return Util.ConvertUnsignedBinary2(this.data, 24);
    }

    public int smfaps() {
        return Util.ConvertSignedBinary4(this.data, 28);
    }

    public int smflps() {
        return Util.ConvertUnsignedBinary2(this.data, 32);
    }

    public int smfnps() {
        return Util.ConvertUnsignedBinary2(this.data, 34);
    }

    public int smfass() {
        return Util.ConvertSignedBinary4(this.data, 36);
    }

    public int smfasl() {
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public int smfasn() {
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public static long getCompressedByteCount() {
        return compressedByteCount.get();
    }

    public static long getDecompressedByteCount() {
        return decompressedByteCount.get();
    }

    static enum Field {
        smflen(0, 2),
        smfseg(2, 2),
        smfflg(4, 1),
        smfrty(5, 1),
        smftme(6, 4),
        smfdte(10, 4),
        smfsid(14, 4),
        smfssi(18, 4),
        smfsty(22, 2),
        smftrn(24, 2),
        smfaps(28, 4),
        smflps(32, 2),
        smfnps(34, 2),
        smfass(36, 4),
        smfasl(40, 2),
        smfasn(42, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }

    private static interface CreateStatisticsSection<T extends StatisticsDataSection> {
        public T createStatisticsSection(byte[] var1, int var2, int var3);
    }
}

