/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.monitoring;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;

public class CicsClock
extends SmfData
implements Comparable<CicsClock> {
    int length;

    CicsClock(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
        this.length = length;
    }

    @Override
    public String toString() {
        return String.format("%s : 0x%02X : %d", this.timer(), this.flags(), this.periodCount());
    }

    public Duration timer() {
        switch (this.length) {
            case 12: {
                return Util.Binary8StckInterval(this.data, 0);
            }
            case 8: {
                return Util.Binary4_16_US(this.data, 0);
            }
        }
        throw new IllegalArgumentException("Unrecognized Clock length: " + Integer.toString(this.length));
    }

    public double timerSeconds() {
        return Util.ToSeconds(this.timer());
    }

    public BigInteger timerRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 0);
    }

    public int flags() {
        return Util.ConvertUnsignedBinary1(this.data, this.length - 4);
    }

    public int count() {
        return Util.ConvertUnsignedBinary3(this.data, this.length - 3);
    }

    @Deprecated
    public int periodCount() {
        return Util.ConvertUnsignedBinary3(this.data, this.length - 3);
    }

    public static CicsClock create(byte[] Data2, int offset, int length) {
        return new CicsClock(Data2, offset, length);
    }

    @Override
    public int compareTo(CicsClock o) {
        return this.timer().compareTo(o.timer());
    }
}

