/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.monitoring;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.ZonedDateTime;

public final class MnrIdentificationData
extends SmfData {
    public static final int MNR_ID_NATURE_NOTAPPLIC = 0;
    public static final int MNR_ID_NATURE_TERMINAL = 1;
    public static final int MNR_ID_NATURE_SESSION = 2;
    public static final int MNR_ID_SESSTYPE_NOTAPPLIC = 0;
    public static final int MNR_ID_SESSTYPE_IRC = 1;
    public static final int MNR_ID_SESSTYPE_IRC_XM = 2;
    public static final int MNR_ID_SESSTYPE_IRC_XCF = 3;
    public static final int MNR_ID_SESSTYPE_LU61 = 4;
    public static final int MNR_ID_SESSTYPE_LU62_SING = 5;
    public static final int MNR_ID_SESSTYPE_LU62_PARA = 6;
    public static final int MNR_ID_ACMETH_NOTAPPLIC = 0;
    public static final int MNR_ID_ACMETH_VTAM = 1;
    public static final int MNR_ID_ACMETH_BSAM = 3;
    public static final int MNR_ID_ACMETH_TCAM = 4;
    public static final int MNR_ID_ACMETH_BGAM = 6;
    public static final int MNR_ID_ACMETH_CONSOLE = 7;
    public static final int MNR_FILE_LIMIT_EXCEEDED = 128;
    public static final int MNR_TSQUEUE_LIMIT_EXCEEDED = 64;
    public static final int MNR_DPL_LIMIT_EXCEEDED = 32;
    public static final int MNR_URIMAP_LIMIT_EXCEEDED = 16;
    public static final int MNR_WEBSVC_LIMIT_EXCEEDED = 8;
    public static final int MNR_ID_LENGTH = 476;

    private MnrIdentificationData(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String mnrIdTranid() {
        return Util.ConvertEbcdic(this.data, 0, 4);
    }

    public String mnrIdTermid() {
        return Util.ConvertEbcdic(this.data, 4, 4);
    }

    public String mnrIdUserid() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public String mnrIdStype() {
        return Util.ConvertEbcdic(this.data, 16, 4);
    }

    public ZonedDateTime mnrIdStart() {
        return Util.Binary8xStckTime(this.data, 20);
    }

    public BigInteger mnrIdStartRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 20);
    }

    public ZonedDateTime mnrIdStop() {
        return Util.Binary8xStckTime(this.data, 28);
    }

    public BigInteger mnrIdStopRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 28);
    }

    public long mnrIdTaskno() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public String mnrIdLuname() {
        return Util.ConvertEbcdic(this.data, 40, 8);
    }

    public String mnrIdPgmname() {
        return Util.ConvertEbcdic(this.data, 48, 8);
    }

    public String mnrIdUowPx() {
        return Util.ConvertEbcdic(this.data, 56, 20);
    }

    public String mnrIdUowSx() {
        return Util.ConvertEbcdic(this.data, 76, 8);
    }

    public String mnrIdRsysid() {
        return Util.ConvertEbcdic(this.data, 84, 4);
    }

    public long mnrIdTrnFlags() {
        return Util.ConvertUnsignedBinary8(this.data, 88);
    }

    public BigInteger mnrIdTrnFlagsAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 88);
    }

    public String mnrIdFctyname() {
        return Util.ConvertEbcdic(this.data, 96, 4);
    }

    public String mnrIdRtype() {
        return Util.ConvertEbcdic(this.data, 100, 4);
    }

    public long mnrIdTerminfo() {
        return Util.ConvertUnsignedBinary4(this.data, 104);
    }

    public int mnrIdNature() {
        return Util.ConvertUnsignedBinary1(this.data, 104);
    }

    public boolean mnrIdNatureNotapplic() {
        return Util.ConvertEquateValue(this.data, this.mnrIdNature(), 0);
    }

    public boolean mnrIdNatureTerminal() {
        return Util.ConvertEquateValue(this.data, this.mnrIdNature(), 1);
    }

    public boolean mnrIdNatureSession() {
        return Util.ConvertEquateValue(this.data, this.mnrIdNature(), 2);
    }

    public int mnrIdSesstype() {
        return Util.ConvertUnsignedBinary1(this.data, 105);
    }

    public boolean mnrIdSesstypeNotapplic() {
        return Util.ConvertEquateValue(this.data, this.mnrIdSesstype(), 0);
    }

    public boolean mnrIdSesstypeIrc() {
        return Util.ConvertEquateValue(this.data, this.mnrIdSesstype(), 1);
    }

    public boolean mnrIdSesstypeIrcXm() {
        return Util.ConvertEquateValue(this.data, this.mnrIdSesstype(), 2);
    }

    public boolean mnrIdSesstypeIrcXcf() {
        return Util.ConvertEquateValue(this.data, this.mnrIdSesstype(), 3);
    }

    public boolean mnrIdSesstypeLu61() {
        return Util.ConvertEquateValue(this.data, this.mnrIdSesstype(), 4);
    }

    public boolean mnrIdSesstypeLu62Sing() {
        return Util.ConvertEquateValue(this.data, this.mnrIdSesstype(), 5);
    }

    public boolean mnrIdSesstypeLu62Para() {
        return Util.ConvertEquateValue(this.data, this.mnrIdSesstype(), 6);
    }

    public int mnrIdAcmeth() {
        return Util.ConvertUnsignedBinary1(this.data, 106);
    }

    public boolean mnrIdAcmethNotapplic() {
        return Util.ConvertEquateValue(this.data, this.mnrIdAcmeth(), 0);
    }

    public boolean mnrIdAcmethVtam() {
        return Util.ConvertEquateValue(this.data, this.mnrIdAcmeth(), 1);
    }

    public boolean mnrIdAcmethBsam() {
        return Util.ConvertEquateValue(this.data, this.mnrIdAcmeth(), 3);
    }

    public boolean mnrIdAcmethTcam() {
        return Util.ConvertEquateValue(this.data, this.mnrIdAcmeth(), 4);
    }

    public boolean mnrIdAcmethBgam() {
        return Util.ConvertEquateValue(this.data, this.mnrIdAcmeth(), 6);
    }

    public boolean mnrIdAcmethConsole() {
        return Util.ConvertEquateValue(this.data, this.mnrIdAcmeth(), 7);
    }

    public int mnrIdDevcode() {
        return Util.ConvertUnsignedBinary1(this.data, 107);
    }

    public String mnrIdTermcnnm() {
        return Util.ConvertEbcdic(this.data, 108, 4);
    }

    public long mnrIdResFlags() {
        return Util.ConvertUnsignedBinary4(this.data, 112);
    }

    public int mnrIdResFlag1() {
        return Util.ConvertUnsignedBinary1(this.data, 112);
    }

    public boolean mnrFileLimitExceeded() {
        return Util.ConvertFlag(this.data, this.mnrIdResFlag1(), 128);
    }

    public boolean mnrTsqueueLimitExceeded() {
        return Util.ConvertFlag(this.data, this.mnrIdResFlag1(), 64);
    }

    public boolean mnrDplLimitExceeded() {
        return Util.ConvertFlag(this.data, this.mnrIdResFlag1(), 32);
    }

    public boolean mnrUrimapLimitExceeded() {
        return Util.ConvertFlag(this.data, this.mnrIdResFlag1(), 16);
    }

    public boolean mnrWebsvcLimitExceeded() {
        return Util.ConvertFlag(this.data, this.mnrIdResFlag1(), 8);
    }

    public String mnrIdIsipicnm() {
        return Util.ConvertEbcdic(this.data, 116, 8);
    }

    public String mnrIdClipaddr() {
        return Util.ConvertEbcdic(this.data, 140, 40);
    }

    public InetAddress mnrIdClipaddrAsInetAddress() throws UnknownHostException {
        return Util.ConvertInetTextAddress(this.data, 140, 40);
    }

    public String mnrIdOriginNetwkid() {
        return Util.ConvertEbcdic(this.data, 180, 8);
    }

    public String mnrIdOriginApplid() {
        return Util.ConvertEbcdic(this.data, 188, 8);
    }

    public ZonedDateTime mnrIdOriginAttTime() {
        return Util.Binary8xStckTime(this.data, 196);
    }

    public BigInteger mnrIdOriginAttTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 196);
    }

    public int mnrIdOriginTrannum() {
        return Util.ConvertPacked4(this.data, 204);
    }

    public String mnrIdOriginTranid() {
        return Util.ConvertEbcdic(this.data, 208, 4);
    }

    public String mnrIdOriginUserid() {
        return Util.ConvertEbcdic(this.data, 212, 8);
    }

    public byte[] mnrIdOriginUserCorr() {
        if (this.data.length >= 284) {
            byte[] result = new byte[64];
            System.arraycopy(this.data, 220, result, 0, 64);
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(220) + " Data length: " + Integer.toString(64));
    }

    public String mnrIdOriginTcpipserv() {
        return Util.ConvertEbcdic(this.data, 284, 8);
    }

    public long mnrIdOriginPortnum() {
        return Util.ConvertUnsignedBinary4(this.data, 292);
    }

    public String mnrIdOriginClipaddr() {
        return Util.ConvertEbcdic(this.data, 296, 40);
    }

    public InetAddress mnrIdOriginClipaddrAsInetAddress() throws UnknownHostException {
        return Util.ConvertInetTextAddress(this.data, 296, 40);
    }

    public long mnrIdOriginClipport() {
        return Util.ConvertUnsignedBinary4(this.data, 336);
    }

    public long mnrIdOriginTranflag() {
        return Util.ConvertUnsignedBinary8(this.data, 340);
    }

    public BigInteger mnrIdOriginTranflagAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 340);
    }

    public String mnrIdOriginFctyname() {
        return Util.ConvertEbcdic(this.data, 348, 8);
    }

    public String mnrPhdNetwkid() {
        return Util.ConvertEbcdic(this.data, 364, 8);
    }

    public String mnrPhdApplid() {
        return Util.ConvertEbcdic(this.data, 372, 8);
    }

    public ZonedDateTime mnrPhdAttachTime() {
        return Util.Binary8xStckTime(this.data, 380);
    }

    public BigInteger mnrPhdAttachTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 380);
    }

    public String mnrPhdTrannum() {
        return Util.ConvertEbcdic(this.data, 388, 4);
    }

    public String mnrPhdTranid() {
        return Util.ConvertEbcdic(this.data, 392, 4);
    }

    public long mnrPhdCount() {
        return Util.ConvertUnsignedBinary4(this.data, 396);
    }

    public String mnrIdTrngrpid() {
        return Util.ConvertEbcdic(this.data, 404, 28);
    }

    public ZonedDateTime mnrPtdAttachTime() {
        return Util.Binary8xStckTime(this.data, 444);
    }

    public BigInteger mnrPtdAttachTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 444);
    }

    public long mnrPtdTrannum() {
        return Util.ConvertUnsignedBinary4(this.data, 452);
    }

    public String mnrPtdTranid() {
        return Util.ConvertEbcdic(this.data, 456, 4);
    }

    public long mnrPtdCount() {
        return Util.ConvertUnsignedBinary4(this.data, 460);
    }

    public static MnrIdentificationData create(byte[] Data2, int offset, int length) {
        return new MnrIdentificationData(Data2, offset, length);
    }

    static enum Field {
        mnrIdTranid(0, 4),
        mnrIdTermid(4, 4),
        mnrIdUserid(8, 8),
        mnrIdStype(16, 4),
        mnrIdStart(20, 8),
        mnrIdStop(28, 8),
        mnrIdTaskno(36, 4),
        mnrIdLuname(40, 8),
        mnrIdPgmname(48, 8),
        mnrIdUowPx(56, 20),
        mnrIdUowSx(76, 8),
        mnrIdRsysid(84, 4),
        mnrIdTrnFlags(88, 8),
        mnrIdFctyname(96, 4),
        mnrIdRtype(100, 4),
        mnrIdTerminfo(104, 4),
        mnrIdNature(104, 1),
        mnrIdSesstype(105, 1),
        mnrIdAcmeth(106, 1),
        mnrIdDevcode(107, 1),
        mnrIdTermcnnm(108, 4),
        mnrIdResFlags(112, 4),
        mnrIdResFlag1(112, 1),
        mnrIdIsipicnm(116, 8),
        mnrIdClipaddr(140, 40),
        mnrIdOriginNetwkid(180, 8),
        mnrIdOriginApplid(188, 8),
        mnrIdOriginAttTime(196, 8),
        mnrIdOriginTrannum(204, 4),
        mnrIdOriginTranid(208, 4),
        mnrIdOriginUserid(212, 8),
        mnrIdOriginUserCorr(220, 64),
        mnrIdOriginTcpipserv(284, 8),
        mnrIdOriginPortnum(292, 4),
        mnrIdOriginClipaddr(296, 40),
        mnrIdOriginClipport(336, 4),
        mnrIdOriginTranflag(340, 8),
        mnrIdOriginFctyname(348, 8),
        mnrPhdNetwkid(364, 8),
        mnrPhdApplid(372, 8),
        mnrPhdAttachTime(380, 8),
        mnrPhdTrannum(388, 4),
        mnrPhdTranid(392, 4),
        mnrPhdCount(396, 4),
        mnrIdTrngrpid(404, 28),
        mnrPtdAttachTime(444, 8),
        mnrPtdTrannum(452, 4),
        mnrPtdTranid(456, 4),
        mnrPtdCount(460, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

