/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.monitoring;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.cics.monitoring.CicsClock;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class MnrTsqEntry
extends SmfData {
    public static final int MNR_TSQUEUE_LEN = 120;

    private MnrTsqEntry(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String mnrTsqueueName() {
        return Util.ConvertEbcdic(this.data, 0, 16);
    }

    public CicsClock mnrTsqueueGet() {
        return CicsClock.create(this.data, 16, 8);
    }

    @Deprecated
    public Duration mnrTsqueueGetTime() {
        return Util.Binary4_16_US(this.data, 16);
    }

    @Deprecated
    public double mnrTsqueueGetTimeSeconds() {
        return Util.ToSeconds(this.mnrTsqueueGetTime());
    }

    @Deprecated
    public long mnrTsqueueGetTimeRawValue() {
        return Util.ConvertSignedBinary4(this.data, 16);
    }

    @Deprecated
    public int mnrTsqueueGetFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 20);
    }

    @Deprecated
    public int mnrTsqueueGetCount() {
        return Util.ConvertUnsignedBinary3(this.data, 21);
    }

    public CicsClock mnrTsqueuePutAux() {
        return CicsClock.create(this.data, 24, 8);
    }

    @Deprecated
    public Duration mnrTsqueuePutAuxTime() {
        return Util.Binary4_16_US(this.data, 24);
    }

    @Deprecated
    public double mnrTsqueuePutAuxTimeSeconds() {
        return Util.ToSeconds(this.mnrTsqueuePutAuxTime());
    }

    @Deprecated
    public long mnrTsqueuePutAuxTimeRawValue() {
        return Util.ConvertSignedBinary4(this.data, 24);
    }

    @Deprecated
    public int mnrTsqueuePutAuxFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 28);
    }

    @Deprecated
    public int mnrTsqueuePutAuxCount() {
        return Util.ConvertUnsignedBinary3(this.data, 29);
    }

    public CicsClock mnrTsqueuePutMain() {
        return CicsClock.create(this.data, 32, 8);
    }

    @Deprecated
    public Duration mnrTsqueuePutMainTime() {
        return Util.Binary4_16_US(this.data, 32);
    }

    @Deprecated
    public double mnrTsqueuePutMainTimeSeconds() {
        return Util.ToSeconds(this.mnrTsqueuePutMainTime());
    }

    @Deprecated
    public long mnrTsqueuePutMainTimeRawValue() {
        return Util.ConvertSignedBinary4(this.data, 32);
    }

    @Deprecated
    public int mnrTsqueuePutMainFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 36);
    }

    @Deprecated
    public int mnrTsqueuePutMainCount() {
        return Util.ConvertUnsignedBinary3(this.data, 37);
    }

    public CicsClock mnrTsqueueTotal() {
        return CicsClock.create(this.data, 40, 8);
    }

    @Deprecated
    public Duration mnrTsqueueTotalTime() {
        return Util.Binary4_16_US(this.data, 40);
    }

    @Deprecated
    public double mnrTsqueueTotalTimeSeconds() {
        return Util.ToSeconds(this.mnrTsqueueTotalTime());
    }

    @Deprecated
    public long mnrTsqueueTotalTimeRawValue() {
        return Util.ConvertSignedBinary4(this.data, 40);
    }

    @Deprecated
    public int mnrTsqueueTotalFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 44);
    }

    @Deprecated
    public int mnrTsqueueTotalCount() {
        return Util.ConvertUnsignedBinary3(this.data, 45);
    }

    public long mnrTsqueueGetIteml() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long mnrTsqueuePutAuxIteml() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public long mnrTsqueuePutMainIteml() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public CicsClock mnrTsqueueIoWt() {
        return CicsClock.create(this.data, 72, 8);
    }

    @Deprecated
    public Duration mnrTsqueueIoWtTime() {
        return Util.Binary4_16_US(this.data, 72);
    }

    @Deprecated
    public double mnrTsqueueIoWtTimeSeconds() {
        return Util.ToSeconds(this.mnrTsqueueIoWtTime());
    }

    @Deprecated
    public long mnrTsqueueIoWtTimeRawValue() {
        return Util.ConvertSignedBinary4(this.data, 72);
    }

    @Deprecated
    public int mnrTsqueueIoWtFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 76);
    }

    @Deprecated
    public int mnrTsqueueIoWtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 77);
    }

    public CicsClock mnrShrTsqueueIoWt() {
        return CicsClock.create(this.data, 80, 8);
    }

    @Deprecated
    public Duration mnrShrTsqueueIoWtTime() {
        return Util.Binary4_16_US(this.data, 80);
    }

    @Deprecated
    public double mnrShrTsqueueIoWtTimeSeconds() {
        return Util.ToSeconds(this.mnrShrTsqueueIoWtTime());
    }

    @Deprecated
    public long mnrShrTsqueueIoWtTimeRawValue() {
        return Util.ConvertSignedBinary4(this.data, 80);
    }

    @Deprecated
    public int mnrShrTsqueueIoWtFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 84);
    }

    @Deprecated
    public int mnrShrTsqueueIoWtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 85);
    }

    public CicsClock mnrTsqueueGetShr() {
        return CicsClock.create(this.data, 96, 8);
    }

    @Deprecated
    public Duration mnrTsqueueGetShrTime() {
        return Util.Binary4_16_US(this.data, 96);
    }

    @Deprecated
    public double mnrTsqueueGetShrTimeSeconds() {
        return Util.ToSeconds(this.mnrTsqueueGetShrTime());
    }

    @Deprecated
    public long mnrTsqueueGetShrTimeRawValue() {
        return Util.ConvertSignedBinary4(this.data, 96);
    }

    @Deprecated
    public int mnrTsqueueGetShrFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 100);
    }

    @Deprecated
    public int mnrTsqueueGetShrCount() {
        return Util.ConvertUnsignedBinary3(this.data, 101);
    }

    public CicsClock mnrTsqueuePutShr() {
        return CicsClock.create(this.data, 104, 8);
    }

    @Deprecated
    public Duration mnrTsqueuePutShrTime() {
        return Util.Binary4_16_US(this.data, 104);
    }

    @Deprecated
    public double mnrTsqueuePutShrTimeSeconds() {
        return Util.ToSeconds(this.mnrTsqueuePutShrTime());
    }

    @Deprecated
    public long mnrTsqueuePutShrTimeRawValue() {
        return Util.ConvertSignedBinary4(this.data, 104);
    }

    @Deprecated
    public int mnrTsqueuePutShrFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 108);
    }

    @Deprecated
    public int mnrTsqueuePutShrCount() {
        return Util.ConvertUnsignedBinary3(this.data, 109);
    }

    public long mnrTsqueueGetShrIteml() {
        return Util.ConvertUnsignedBinary4(this.data, 112);
    }

    public long mnrTsqueuePutShrIteml() {
        return Util.ConvertUnsignedBinary4(this.data, 116);
    }

    public static MnrTsqEntry create(byte[] Data2, int offset, int length) {
        return new MnrTsqEntry(Data2, offset, length);
    }

    static enum Field {
        mnrTsqueueName(0, 16),
        mnrTsqueueGet(16, 8),
        mnrTsqueuePutAux(24, 8),
        mnrTsqueuePutMain(32, 8),
        mnrTsqueueTotal(40, 8),
        mnrTsqueueGetIteml(52, 4),
        mnrTsqueuePutAuxIteml(56, 4),
        mnrTsqueuePutMainIteml(60, 4),
        mnrTsqueueIoWt(72, 8),
        mnrShrTsqueueIoWt(80, 8),
        mnrTsqueueGetShr(96, 8),
        mnrTsqueuePutShr(104, 8),
        mnrTsqueueGetShrIteml(112, 4),
        mnrTsqueuePutShrIteml(116, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

