/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.monitoring;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.cics.monitoring.MnrDplEntry;
import com.blackhillsoftware.smf.cics.monitoring.MnrFileEntry;
import com.blackhillsoftware.smf.cics.monitoring.MnrIdentificationData;
import com.blackhillsoftware.smf.cics.monitoring.MnrTsqEntry;
import com.blackhillsoftware.smf.cics.monitoring.MnrUriMapEntry;
import com.blackhillsoftware.smf.cics.monitoring.MnrWebSvcEntry;
import com.blackhillsoftware.smf.internal.Util;
import java.util.List;

public final class TransactionResourceRecord
extends SmfData {
    private List<MnrIdentificationData> m_MnrIdentificationData = null;
    private List<MnrFileEntry> m_MnrFileEntry = null;
    private List<MnrTsqEntry> m_MnrTsqEntry = null;
    private List<MnrDplEntry> m_MnrDplEntry = null;
    private List<MnrUriMapEntry> m_MnrUriMapEntry = null;
    private List<MnrWebSvcEntry> m_MnrWebSvcEntry = null;
    public static final int MNR_ID_EQUATE = 79;
    public static final int MNR_VERSION = 1;
    public static final int MNR_HDR_LENGTH = 64;

    private TransactionResourceRecord(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public List<MnrIdentificationData> identificationData() {
        this.m_MnrIdentificationData = Util.sectionsFromTriplet(this.m_MnrIdentificationData, this.data, () -> this.mnrIso(), () -> this.mnrIsl(), () -> this.mnrIsn(), MnrIdentificationData::create);
        return this.m_MnrIdentificationData;
    }

    public List<MnrFileEntry> fileEntries() {
        this.m_MnrFileEntry = Util.sectionsFromTriplet(this.m_MnrFileEntry, this.data, () -> this.mnrFso(), () -> this.mnrFsl(), () -> this.mnrFsn(), MnrFileEntry::create);
        return this.m_MnrFileEntry;
    }

    public List<MnrTsqEntry> tsqEntries() {
        this.m_MnrTsqEntry = Util.sectionsFromTriplet(this.m_MnrTsqEntry, this.data, () -> this.mnrTso(), () -> this.mnrTsl(), () -> this.mnrTsn(), MnrTsqEntry::create);
        return this.m_MnrTsqEntry;
    }

    public List<MnrDplEntry> dplEntries() {
        this.m_MnrDplEntry = Util.sectionsFromTriplet(this.m_MnrDplEntry, this.data, () -> this.mnrDso(), () -> this.mnrDsl(), () -> this.mnrDsn(), MnrDplEntry::create);
        return this.m_MnrDplEntry;
    }

    public List<MnrUriMapEntry> uriMapEntries() {
        this.m_MnrUriMapEntry = Util.sectionsFromTriplet(this.m_MnrUriMapEntry, this.data, () -> this.mnrUso(), () -> this.mnrUsl(), () -> this.mnrUsn(), MnrUriMapEntry::create);
        return this.m_MnrUriMapEntry;
    }

    public List<MnrWebSvcEntry> MnrWebSvcEntries() {
        this.m_MnrWebSvcEntry = Util.sectionsFromTriplet(this.m_MnrWebSvcEntry, this.data, () -> this.mnrWso(), () -> this.mnrWsl(), () -> this.mnrWsn(), MnrWebSvcEntry::create);
        return this.m_MnrWebSvcEntry;
    }

    public int mnrLength() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int mnrId() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int mnrDsectVers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int mnrHdrlen() {
        return Util.ConvertUnsignedBinary2(this.data, 8);
    }

    public int mnrTrn() {
        return Util.ConvertUnsignedBinary2(this.data, 20);
    }

    public int mnrIso() {
        return Util.ConvertSignedBinary4(this.data, 24);
    }

    public int mnrIsl() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public int mnrIsn() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public int mnrFso() {
        return Util.ConvertSignedBinary4(this.data, 32);
    }

    public int mnrFsl() {
        return Util.ConvertUnsignedBinary2(this.data, 36);
    }

    public int mnrFsn() {
        return Util.ConvertUnsignedBinary2(this.data, 38);
    }

    public int mnrTso() {
        return Util.ConvertSignedBinary4(this.data, 40);
    }

    public int mnrTsl() {
        return Util.ConvertUnsignedBinary2(this.data, 44);
    }

    public int mnrTsn() {
        return Util.ConvertUnsignedBinary2(this.data, 46);
    }

    public int mnrDso() {
        return Util.ConvertSignedBinary4(this.data, 48);
    }

    public int mnrDsl() {
        return Util.ConvertUnsignedBinary2(this.data, 52);
    }

    public int mnrDsn() {
        return Util.ConvertUnsignedBinary2(this.data, 54);
    }

    public int mnrUso() {
        return Util.ConvertSignedBinary4(this.data, 56);
    }

    public int mnrUsl() {
        return Util.ConvertUnsignedBinary2(this.data, 60);
    }

    public int mnrUsn() {
        return Util.ConvertUnsignedBinary2(this.data, 62);
    }

    public int mnrWso() {
        return Util.ConvertSignedBinary4(this.data, 64);
    }

    public int mnrWsl() {
        return Util.ConvertUnsignedBinary2(this.data, 68);
    }

    public int mnrWsn() {
        return Util.ConvertUnsignedBinary2(this.data, 70);
    }

    public static TransactionResourceRecord create(byte[] Data2, int offset, int length) {
        return new TransactionResourceRecord(Data2, offset, length);
    }

    static enum Field {
        mnrLength(0, 2),
        mnrId(2, 2),
        mnrDsectVers(4, 1),
        mnrHdrlen(8, 2),
        mnrTrn(20, 2),
        mnrIso(24, 4),
        mnrIsl(28, 2),
        mnrIsn(30, 2),
        mnrFso(32, 4),
        mnrFsl(36, 2),
        mnrFsn(38, 2),
        mnrTso(40, 4),
        mnrTsl(44, 2),
        mnrTsn(46, 2),
        mnrDso(48, 4),
        mnrDsl(52, 2),
        mnrDsn(54, 2),
        mnrUso(56, 4),
        mnrUsl(60, 2),
        mnrUsn(62, 2),
        mnrWso(64, 4),
        mnrWsl(68, 2),
        mnrWsn(70, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

