/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;

public final class BeanStatistics
extends SmfData {
    public static final int EJBIDR = 115;
    public static final int EJB_VERS = 1;

    private BeanStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int ejbdsLen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int ejbdsId() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int ejbdsVers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String ejbBeanName() {
        return Util.ConvertEbcdic(this.data, 8, 240);
    }

    public String ejbCorbaserverName() {
        return Util.ConvertEbcdic(this.data, 248, 4);
    }

    public String ejbDjarName() {
        return Util.ConvertEbcdic(this.data, 252, 32);
    }

    public long ejbBeanActivations() {
        return Util.ConvertUnsignedBinary4(this.data, 292);
    }

    public long ejbBeanPassivations() {
        return Util.ConvertUnsignedBinary4(this.data, 296);
    }

    public long ejbBeanCreates() {
        return Util.ConvertUnsignedBinary4(this.data, 300);
    }

    public long ejbBeanRemoves() {
        return Util.ConvertUnsignedBinary4(this.data, 304);
    }

    public long ejbBeanMethodCalls() {
        return Util.ConvertUnsignedBinary4(this.data, 308);
    }

    public static BeanStatistics create(byte[] Data2, int offset, int length) {
        return new BeanStatistics(Data2, offset, length);
    }

    static enum Field {
        ejbdsLen(0, 2),
        ejbdsId(2, 2),
        ejbdsVers(4, 1),
        ejbBeanName(8, 240),
        ejbCorbaserverName(248, 4),
        ejbDjarName(252, 32),
        ejbBeanActivations(292, 4),
        ejbBeanPassivations(296, 4),
        ejbBeanCreates(300, 4),
        ejbBeanRemoves(304, 4),
        ejbBeanMethodCalls(308, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

