/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.cics.statistics.values.CIAgent;
import com.blackhillsoftware.smf.cics.statistics.values.EjrOutPrivacy;
import com.blackhillsoftware.smf.cics.statistics.values.IpFamily;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDateTime;

public final class CorbaserverStatistics
extends SmfData {
    public static final int EJRIDR = 114;
    public static final int EJR_VERS = 1;

    private CorbaserverStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int ejrdsLen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int ejrdsId() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int ejrdsVers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String ejrCorbaserverName() {
        return Util.ConvertEbcdic(this.data, 8, 4);
    }

    public String ejrJndiPrefix() {
        return Util.ConvertEbcdic(this.data, 12, 255);
    }

    public String ejrTcpipHostName() {
        return Util.ConvertEbcdic(this.data, 267, 255);
    }

    public String ejrShelfDirectory() {
        return Util.ConvertEbcdic(this.data, 522, 255);
    }

    public EjrOutPrivacy ejrOutPrivacy() {
        int value = Util.ConvertUnsignedBinary1(this.data, 789);
        return EjrOutPrivacy.from(value);
    }

    public int ejrOutPrivacyRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 789);
    }

    public long ejrSessionTimeout() {
        return Util.ConvertUnsignedBinary4(this.data, 792);
    }

    public long ejrObjectActivates() {
        return Util.ConvertUnsignedBinary4(this.data, 796);
    }

    public long ejrObjectStores() {
        return Util.ConvertUnsignedBinary4(this.data, 800);
    }

    public long ejrFailedActivates() {
        return Util.ConvertUnsignedBinary4(this.data, 804);
    }

    public String ejrDjarDirectory() {
        return Util.ConvertEbcdic(this.data, 812, 255);
    }

    public String ejrTcpipUnauth() {
        return Util.ConvertEbcdic(this.data, 1076, 8);
    }

    public String ejrTcpipClientcert() {
        return Util.ConvertEbcdic(this.data, 1084, 8);
    }

    public String ejrTcpipUnauthSsl() {
        return Util.ConvertEbcdic(this.data, 1092, 8);
    }

    public String ejrTcpipAsserted() {
        return Util.ConvertEbcdic(this.data, 1100, 8);
    }

    public String ejrIpAddress() {
        return Util.ConvertEbcdic(this.data, 1140, 39);
    }

    public IpFamily ejrIpFamily() {
        int value = Util.ConvertUnsignedBinary1(this.data, 1179);
        return IpFamily.from(value);
    }

    public int ejrIpFamilyRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 1179);
    }

    public String ejrCorbasDefineSource() {
        return Util.ConvertEbcdic(this.data, 1180, 8);
    }

    public long ejrCorbasChangeTime() {
        return Util.ConvertUnsignedBinary8(this.data, 1188);
    }

    public BigInteger ejrCorbasChangeTimeAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1188);
    }

    public LocalDateTime ejrCorbasChangeUserid() {
        return Util.Binary8xStckLocalTime(this.data, 1196);
    }

    public BigInteger ejrCorbasChangeUseridRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1196);
    }

    public CIAgent ejrCorbasChangeAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 1204);
        return CIAgent.from(value);
    }

    public int ejrCorbasChangeAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 1204);
    }

    public CIAgent ejrCorbasInstallAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 1206);
        return CIAgent.from(value);
    }

    public int ejrCorbasInstallAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 1206);
    }

    public LocalDateTime ejrCorbasInstallTime() {
        return Util.Binary8xStckLocalTime(this.data, 1208);
    }

    public BigInteger ejrCorbasInstallTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1208);
    }

    public String ejrCorbasInstallUserid() {
        return Util.ConvertEbcdic(this.data, 1216, 8);
    }

    public static CorbaserverStatistics create(byte[] Data2, int offset, int length) {
        return new CorbaserverStatistics(Data2, offset, length);
    }

    static enum Field {
        ejrdsLen(0, 2),
        ejrdsId(2, 2),
        ejrdsVers(4, 1),
        ejrCorbaserverName(8, 4),
        ejrJndiPrefix(12, 255),
        ejrTcpipHostName(267, 255),
        ejrShelfDirectory(522, 255),
        ejrOutPrivacy(789, 1),
        ejrSessionTimeout(792, 4),
        ejrObjectActivates(796, 4),
        ejrObjectStores(800, 4),
        ejrFailedActivates(804, 4),
        ejrDjarDirectory(812, 255),
        ejrTcpipUnauth(1076, 8),
        ejrTcpipClientcert(1084, 8),
        ejrTcpipUnauthSsl(1092, 8),
        ejrTcpipAsserted(1100, 8),
        ejrIpAddress(1140, 39),
        ejrIpFamily(1179, 1),
        ejrCorbasDefineSource(1180, 8),
        ejrCorbasChangeTime(1188, 8),
        ejrCorbasChangeUserid(1196, 8),
        ejrCorbasChangeAgent(1204, 2),
        ejrCorbasInstallAgent(1206, 2),
        ejrCorbasInstallTime(1208, 8),
        ejrCorbasInstallUserid(1216, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

