/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.CIAgent;
import com.blackhillsoftware.smf.cics.statistics.values.D2rAccountrec;
import com.blackhillsoftware.smf.cics.statistics.values.D2rAuthtype;
import com.blackhillsoftware.smf.cics.statistics.values.D2rPriority;
import com.blackhillsoftware.smf.cics.statistics.values.Threadwait;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDateTime;

public final class Db2ResourceStatistics
extends StatisticsDataSection {
    public static final int D2RIDE = 103;
    public static final int D2RVERS = 1;
    public static final int D2R_LENGTH = 204;
    public static final int D2R_SHARELOCKS_YES = 1;
    public static final int D2R_SHARELOCKS_NO = 2;

    private Db2ResourceStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int d2rlen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int d2rid() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int d2rdvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String d2rDb2entryName() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public String d2rPlanName() {
        return Util.ConvertEbcdic(this.data, 16, 8);
    }

    public String d2rPlanexitName() {
        return Util.ConvertEbcdic(this.data, 24, 8);
    }

    public String d2rAuthid() {
        return Util.ConvertEbcdic(this.data, 32, 8);
    }

    public D2rAuthtype d2rAuthtype() {
        int value = Util.ConvertUnsignedBinary1(this.data, 40);
        return D2rAuthtype.from(value);
    }

    public int d2rAuthtypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 40);
    }

    public D2rAccountrec d2rAccountrec() {
        int value = Util.ConvertUnsignedBinary1(this.data, 41);
        return D2rAccountrec.from(value);
    }

    public int d2rAccountrecRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 41);
    }

    public Threadwait d2rThreadwait() {
        int value = Util.ConvertUnsignedBinary1(this.data, 42);
        return Threadwait.from(value);
    }

    public int d2rThreadwaitRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 42);
    }

    public D2rPriority d2rPriority() {
        int value = Util.ConvertUnsignedBinary1(this.data, 43);
        return D2rPriority.from(value);
    }

    public int d2rPriorityRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 43);
    }

    public long d2rCalls() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long d2rSignons() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long d2rCommits() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long d2rAborts() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public long d2rSinglePhase() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public long d2rThreadReuse() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public long d2rThreadTerm() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public long d2rThreadWaitOrOverfl() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public long d2rThreadLimit() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public long d2rThreadCurrent() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public long d2rThreadHwm() {
        return Util.ConvertUnsignedBinary4(this.data, 84);
    }

    public long d2rPthreadLimit() {
        return Util.ConvertUnsignedBinary4(this.data, 88);
    }

    public long d2rPthreadCurrent() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    public long d2rPthreadHwm() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public long d2rTaskCurrent() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    public long d2rTaskHwm() {
        return Util.ConvertUnsignedBinary4(this.data, 104);
    }

    public long d2rTaskTotal() {
        return Util.ConvertUnsignedBinary4(this.data, 108);
    }

    public long d2rReadyqCurrent() {
        return Util.ConvertUnsignedBinary4(this.data, 112);
    }

    public long d2rReadyqHwm() {
        return Util.ConvertUnsignedBinary4(this.data, 116);
    }

    public long d2rPartialSignons() {
        return Util.ConvertUnsignedBinary4(this.data, 120);
    }

    public long d2rThreadCreate() {
        return Util.ConvertUnsignedBinary4(this.data, 124);
    }

    public long d2rReuselimitCount() {
        return Util.ConvertUnsignedBinary4(this.data, 128);
    }

    public int d2rSharelocks() {
        return Util.ConvertUnsignedBinary1(this.data, 132);
    }

    public String d2rDefineSource() {
        return Util.ConvertEbcdic(this.data, 156, 8);
    }

    public LocalDateTime d2rChangeTime() {
        return Util.Binary8xStckLocalTime(this.data, 164);
    }

    public BigInteger d2rChangeTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 164);
    }

    public String d2rChangeUserid() {
        return Util.ConvertEbcdic(this.data, 172, 8);
    }

    public CIAgent d2rChangeAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 180);
        return CIAgent.from(value);
    }

    public int d2rChangeAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 180);
    }

    public CIAgent d2rInstallAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 182);
        return CIAgent.from(value);
    }

    public int d2rInstallAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 182);
    }

    public LocalDateTime d2rInstallTime() {
        return Util.Binary8xStckLocalTime(this.data, 184);
    }

    public BigInteger d2rInstallTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 184);
    }

    public String d2rInstallUserid() {
        return Util.ConvertEbcdic(this.data, 192, 8);
    }

    public boolean d2rSharelocksYes() {
        return Util.ConvertEquateValue(this.data, this.d2rSharelocks(), 1);
    }

    public static Db2ResourceStatistics create(byte[] Data2, int offset, int length) {
        return new Db2ResourceStatistics(Data2, offset, length);
    }

    static enum Field {
        d2rlen(0, 2),
        d2rid(2, 2),
        d2rdvers(4, 1),
        d2rDb2entryName(8, 8),
        d2rPlanName(16, 8),
        d2rPlanexitName(24, 8),
        d2rAuthid(32, 8),
        d2rAuthtype(40, 1),
        d2rAccountrec(41, 1),
        d2rThreadwait(42, 1),
        d2rPriority(43, 1),
        d2rCalls(44, 4),
        d2rSignons(48, 4),
        d2rCommits(52, 4),
        d2rAborts(56, 4),
        d2rSinglePhase(60, 4),
        d2rThreadReuse(64, 4),
        d2rThreadTerm(68, 4),
        d2rThreadWaitOrOverfl(72, 4),
        d2rThreadLimit(76, 4),
        d2rThreadCurrent(80, 4),
        d2rThreadHwm(84, 4),
        d2rPthreadLimit(88, 4),
        d2rPthreadCurrent(92, 4),
        d2rPthreadHwm(96, 4),
        d2rTaskCurrent(100, 4),
        d2rTaskHwm(104, 4),
        d2rTaskTotal(108, 4),
        d2rReadyqCurrent(112, 4),
        d2rReadyqHwm(116, 4),
        d2rPartialSignons(120, 4),
        d2rThreadCreate(124, 4),
        d2rReuselimitCount(128, 4),
        d2rSharelocks(132, 1),
        d2rDefineSource(156, 8),
        d2rChangeTime(164, 8),
        d2rChangeUserid(172, 8),
        d2rChangeAgent(180, 2),
        d2rInstallAgent(182, 2),
        d2rInstallTime(184, 8),
        d2rInstallUserid(192, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

