/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.cics.statistics.values.DsgTcbMode;
import com.blackhillsoftware.smf.cics.statistics.values.DsgTcbPool;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public class DispatcherTcbModeStatistics
extends SmfData {
    public static final int DSGMDLEN = 160;

    protected DispatcherTcbModeStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String dsgtcbnm() {
        return Util.ConvertEbcdic(this.data, 0, 2);
    }

    public DsgTcbMode dsgtcbmd() {
        int value = Util.ConvertUnsignedBinary1(this.data, 2);
        return DsgTcbMode.from(value);
    }

    public int dsgtcbmdRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 2);
    }

    public DsgTcbPool dsgtcbmp() {
        int value = Util.ConvertUnsignedBinary2(this.data, 4);
        return DsgTcbPool.from(value);
    }

    public int dsgtcbmpRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 4);
    }

    public long dsgntcba() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public long dsgtcbaf() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long dsgtcbca() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long dsgtcbpa() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long dsgtcbcu() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public long dsgtcbpu() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long dsgtcbal() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long dsgtcbdu() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long dsgtcbds() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public long dsgtcbdx() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public long dsgtcbdo() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public long dsgtcbst() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public long dsgtcbmm() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public long dsgsysw() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public long dsgtmcdq() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public long dsgtmpdq() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    public double dsgtmadq() {
        return (double)Util.ConvertUnsignedBinary4(this.data, 104) / 100.0;
    }

    public Duration dsgtwt() {
        return Util.Binary8StckInterval(this.data, 112);
    }

    public double dsgtwtSeconds() {
        return Util.ToSeconds(this.dsgtwt());
    }

    public long dsgtwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 112);
    }

    public Duration dsgtdt() {
        return Util.Binary8StckInterval(this.data, 120);
    }

    public double dsgtdtSeconds() {
        return Util.ToSeconds(this.dsgtdt());
    }

    public long dsgtdtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 120);
    }

    public Duration dsgtct() {
        return Util.Binary8StckInterval(this.data, 128);
    }

    public double dsgtctSeconds() {
        return Util.ToSeconds(this.dsgtct());
    }

    public long dsgtctRawValue() {
        return Util.ConvertSignedBinary8(this.data, 128);
    }

    public Duration dsgact() {
        return Util.Binary8StckInterval(this.data, 136);
    }

    public double dsgactSeconds() {
        return Util.ToSeconds(this.dsgact());
    }

    public long dsgactRawValue() {
        return Util.ConvertSignedBinary8(this.data, 136);
    }

    public static DispatcherTcbModeStatistics create(byte[] Data2, int offset, int length) {
        return new DispatcherTcbModeStatistics(Data2, offset, length);
    }

    static enum Field {
        dsgtcbnm(0, 2),
        dsgtcbmd(2, 1),
        dsgtcbmp(4, 2),
        dsgntcba(8, 4),
        dsgtcbaf(12, 4),
        dsgtcbca(16, 4),
        dsgtcbpa(20, 4),
        dsgtcbcu(28, 4),
        dsgtcbpu(32, 4),
        dsgtcbal(44, 4),
        dsgtcbdu(52, 4),
        dsgtcbds(56, 4),
        dsgtcbdx(60, 4),
        dsgtcbdo(64, 4),
        dsgtcbst(72, 4),
        dsgtcbmm(76, 4),
        dsgsysw(80, 4),
        dsgtmcdq(96, 4),
        dsgtmpdq(100, 4),
        dsgtmadq(104, 2),
        dsgtwt(112, 8),
        dsgtdt(120, 8),
        dsgtct(128, 8),
        dsgact(136, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

