/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.CIAgent;
import com.blackhillsoftware.smf.cics.statistics.values.EprAdapterType;
import com.blackhillsoftware.smf.cics.statistics.values.EprEmissionMode;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDateTime;

public final class EventProcessResourceStatistics
extends StatisticsDataSection {
    public static final int EPRDS_LENGTH = 108;
    public static final int EPRIDE = 144;
    public static final int EPR_VERS = 1;

    private EventProcessResourceStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int eprdsLen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int eprdsId() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int eprdsVers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String eprAdapterName() {
        return Util.ConvertEbcdic(this.data, 8, 32);
    }

    public EprAdapterType eprAdapterType() {
        int value = Util.ConvertUnsignedBinary1(this.data, 40);
        return EprAdapterType.from(value);
    }

    public int eprAdapterTypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 40);
    }

    public EprEmissionMode eprEmissionMode() {
        int value = Util.ConvertUnsignedBinary1(this.data, 41);
        return EprEmissionMode.from(value);
    }

    public int eprEmissionModeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 41);
    }

    public long eprPutEvents() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public String eprAdaDefineSource() {
        return Util.ConvertEbcdic(this.data, 64, 8);
    }

    public LocalDateTime eprAdaChangeTime() {
        return Util.Binary8xStckLocalTime(this.data, 72);
    }

    public BigInteger eprAdaChangeTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 72);
    }

    public String eprAdaChangeUserid() {
        return Util.ConvertEbcdic(this.data, 80, 8);
    }

    public CIAgent eprAdaChangeAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 88);
        return CIAgent.from(value);
    }

    public int eprAdaChangeAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 88);
    }

    public CIAgent eprAdaInstallAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 90);
        return CIAgent.from(value);
    }

    public int eprAdaInstallAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 90);
    }

    public LocalDateTime eprAdaInstallTime() {
        return Util.Binary8xStckLocalTime(this.data, 92);
    }

    public BigInteger eprAdaInstallTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 92);
    }

    public String eprAdaInstallUserid() {
        return Util.ConvertEbcdic(this.data, 100, 8);
    }

    public static EventProcessResourceStatistics create(byte[] Data2, int offset, int length) {
        return new EventProcessResourceStatistics(Data2, offset, length);
    }

    static enum Field {
        eprdsLen(0, 2),
        eprdsId(2, 2),
        eprdsVers(4, 1),
        eprAdapterName(8, 32),
        eprAdapterType(40, 1),
        eprEmissionMode(41, 1),
        eprPutEvents(44, 4),
        eprAdaDefineSource(64, 8),
        eprAdaChangeTime(72, 8),
        eprAdaChangeUserid(80, 8),
        eprAdaChangeAgent(88, 2),
        eprAdaInstallAgent(90, 2),
        eprAdaInstallTime(92, 8),
        eprAdaInstallUserid(100, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

