/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.internal.Util;

public final class FepiPoolStatistics
extends StatisticsDataSection {
    public static final int A22IDR = 16;
    public static final int A22VERS = 1;

    private FepiPoolStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int a22len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int a22id() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int a22dvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String a22pool() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public long a22trgct() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long a22ndct() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long a22conct() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long a22conpk() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public long a22alloc() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long a22pkall() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long a22wait() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long a22totwt() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long a22pkwt() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long a22tiout() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public static FepiPoolStatistics create(byte[] Data2, int offset, int length) {
        return new FepiPoolStatistics(Data2, offset, length);
    }

    static enum Field {
        a22len(0, 2),
        a22id(2, 2),
        a22dvers(4, 1),
        a22pool(8, 8),
        a22trgct(16, 4),
        a22ndct(20, 4),
        a22conct(24, 4),
        a22conpk(28, 4),
        a22alloc(32, 4),
        a22pkall(36, 4),
        a22wait(40, 4),
        a22totwt(44, 4),
        a22pkwt(48, 4),
        a22tiout(52, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

