/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class IscLuitSntStatistics
extends StatisticsDataSection {
    public static final int A21IDR = 54;
    public static final int A21VERS = 1;
    public static final int A21CLEN = 36;

    private IscLuitSntStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int a21len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int a21id() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int a21dvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public Duration a21SitLuitTime() {
        return Util.Binary2Minutes(this.data, 10);
    }

    public double a21SitLuitTimeSeconds() {
        return Util.ToSeconds(this.a21SitLuitTime());
    }

    public long a21SitLuitTimeRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 10);
    }

    public long a21LuitTotalReuses() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long a21LuitTotalTimeouts() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public Duration a21LuitAvReuseTime() {
        throw new NotAvailableException("Units for this field are undefined - please contact Black Hill Software");
    }

    public double a21LuitAvReuseTimeSeconds() {
        return Util.ToSeconds(this.a21LuitAvReuseTime());
    }

    public long a21LuitAvReuseTimeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public static IscLuitSntStatistics create(byte[] Data2, int offset, int length) {
        return new IscLuitSntStatistics(Data2, offset, length);
    }

    static enum Field {
        a21len(0, 2),
        a21id(2, 2),
        a21dvers(4, 1),
        a21SitLuitTime(10, 2),
        a21LuitTotalReuses(24, 4),
        a21LuitTotalTimeouts(28, 4),
        a21LuitAvReuseTime(32, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

