/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.CIAgent;
import com.blackhillsoftware.smf.cics.statistics.values.SjsJvmserverState;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;

public final class JvmServerStatistics
extends StatisticsDataSection {
    public static final int SJSDS_LENGTH = 384;
    public static final int SJSIDR = 116;
    public static final int SJS_VERS = 1;

    private JvmServerStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int sjsdsLen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int sjsdsId() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int sjsdsVers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String sjsJvmserverName() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public String sjsJvmserverJvmprofile() {
        return Util.ConvertEbcdic(this.data, 16, 8);
    }

    public String sjsJvmserverLeRunopts() {
        return Util.ConvertEbcdic(this.data, 24, 8);
    }

    public long sjsJvmserverUseCount() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public SjsJvmserverState sjsJvmserverState() {
        int value = Util.ConvertUnsignedBinary1(this.data, 44);
        return SjsJvmserverState.from(value);
    }

    public int sjsJvmserverStateRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 44);
    }

    public long sjsJvmserverThreadLimit() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long sjsJvmserverThreadCurrent() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long sjsJvmserverThreadHwm() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public long sjsJvmserverThreadWaits() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public Duration sjsJvmserverThreadWaitTime() {
        return Util.Binary8StckInterval(this.data, 64);
    }

    public double sjsJvmserverThreadWaitTimeSeconds() {
        return Util.ToSeconds(this.sjsJvmserverThreadWaitTime());
    }

    public long sjsJvmserverThreadWaitTimeRawValue() {
        return Util.ConvertSignedBinary8(this.data, 64);
    }

    public long sjsJvmserverThreadWaitCur() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public long sjsJvmserverThreadWaitHwm() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public long sjsJvmserverThreadWlpActv() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public String sjsJvmserverDefineSource() {
        return Util.ConvertEbcdic(this.data, 112, 8);
    }

    public LocalDateTime sjsJvmserverChangeTime() {
        return Util.Binary8xStckLocalTime(this.data, 120);
    }

    public BigInteger sjsJvmserverChangeTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 120);
    }

    public String sjsJvmserverChangeUserid() {
        return Util.ConvertEbcdic(this.data, 128, 8);
    }

    public CIAgent sjsJvmserverChangeAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 136);
        return CIAgent.from(value);
    }

    public int sjsJvmserverChangeAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 136);
    }

    public CIAgent sjsJvmserverInstallAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 138);
        return CIAgent.from(value);
    }

    public int sjsJvmserverInstallAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 138);
    }

    public LocalDateTime sjsJvmserverInstallTime() {
        return Util.Binary8xStckLocalTime(this.data, 140);
    }

    public BigInteger sjsJvmserverInstallTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 140);
    }

    public String sjsJvmserverInstallUserid() {
        return Util.ConvertEbcdic(this.data, 148, 8);
    }

    public long sjsJvmserverSysUseCount() {
        return Util.ConvertUnsignedBinary4(this.data, 156);
    }

    public long sjsJvmserverSysWaited() {
        return Util.ConvertUnsignedBinary4(this.data, 160);
    }

    public Duration sjsJvmserverSysWaitedTime() {
        return Util.Binary8StckInterval(this.data, 164);
    }

    public double sjsJvmserverSysWaitedTimeSeconds() {
        return Util.ToSeconds(this.sjsJvmserverSysWaitedTime());
    }

    public long sjsJvmserverSysWaitedTimeRawValue() {
        return Util.ConvertSignedBinary8(this.data, 164);
    }

    public long sjsJvmserverSysWaitCur() {
        return Util.ConvertUnsignedBinary4(this.data, 172);
    }

    public long sjsJvmserverSysWaitHwm() {
        return Util.ConvertUnsignedBinary4(this.data, 176);
    }

    public ZonedDateTime sjsJvmserverJvmCreationGmt() {
        return Util.Binary8xStckTime(this.data, 180);
    }

    public BigInteger sjsJvmserverJvmCreationGmtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 180);
    }

    public LocalDateTime sjsJvmserverJvmCreationLcl() {
        return Util.Binary8xStckLocalTime(this.data, 188);
    }

    public BigInteger sjsJvmserverJvmCreationLclRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 188);
    }

    public long sjsJvmserverCurrentHeap() {
        return Util.ConvertUnsignedBinary8(this.data, 200);
    }

    public BigInteger sjsJvmserverCurrentHeapAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 200);
    }

    public long sjsJvmserverInitialHeap() {
        return Util.ConvertUnsignedBinary8(this.data, 208);
    }

    public BigInteger sjsJvmserverInitialHeapAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 208);
    }

    public long sjsJvmserverMaxHeap() {
        return Util.ConvertUnsignedBinary8(this.data, 216);
    }

    public BigInteger sjsJvmserverMaxHeapAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 216);
    }

    public long sjsJvmserverPeakHeap() {
        return Util.ConvertUnsignedBinary8(this.data, 224);
    }

    public BigInteger sjsJvmserverPeakHeapAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 224);
    }

    public long sjsJvmserverOccupancy() {
        return Util.ConvertUnsignedBinary8(this.data, 232);
    }

    public BigInteger sjsJvmserverOccupancyAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 232);
    }

    public String sjsJvmserverGcPolicy() {
        return Util.ConvertEbcdic(this.data, 240, 32);
    }

    public long sjsJvmserverMjrGcEvents() {
        return Util.ConvertUnsignedBinary4(this.data, 272);
    }

    public Duration sjsJvmserverMjrGcCpu() {
        return Util.Binary8StckInterval(this.data, 280);
    }

    public double sjsJvmserverMjrGcCpuSeconds() {
        return Util.ToSeconds(this.sjsJvmserverMjrGcCpu());
    }

    public long sjsJvmserverMjrGcCpuRawValue() {
        return Util.ConvertSignedBinary8(this.data, 280);
    }

    public long sjsJvmserverMjrHeapFreed() {
        return Util.ConvertUnsignedBinary8(this.data, 288);
    }

    public BigInteger sjsJvmserverMjrHeapFreedAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 288);
    }

    public long sjsJvmserverMnrGcEvents() {
        return Util.ConvertUnsignedBinary4(this.data, 296);
    }

    public Duration sjsJvmserverMnrGcCpu() {
        return Util.Binary8StckInterval(this.data, 304);
    }

    public double sjsJvmserverMnrGcCpuSeconds() {
        return Util.ToSeconds(this.sjsJvmserverMnrGcCpu());
    }

    public long sjsJvmserverMnrGcCpuRawValue() {
        return Util.ConvertSignedBinary8(this.data, 304);
    }

    public long sjsJvmserverMnrHeapFreed() {
        return Util.ConvertUnsignedBinary8(this.data, 312);
    }

    public BigInteger sjsJvmserverMnrHeapFreedAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 312);
    }

    public long sjsJvmserverCodeCacheUsed() {
        return Util.ConvertUnsignedBinary8(this.data, 320);
    }

    public BigInteger sjsJvmserverCodeCacheUsedAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 320);
    }

    public long sjsJvmserverCodeCacheAlloc() {
        return Util.ConvertUnsignedBinary8(this.data, 328);
    }

    public BigInteger sjsJvmserverCodeCacheAllocAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 328);
    }

    public long sjsJvmserverDataCacheUsed() {
        return Util.ConvertUnsignedBinary8(this.data, 336);
    }

    public BigInteger sjsJvmserverDataCacheUsedAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 336);
    }

    public long sjsJvmserverDataCacheAlloc() {
        return Util.ConvertUnsignedBinary8(this.data, 344);
    }

    public BigInteger sjsJvmserverDataCacheAllocAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 344);
    }

    public long sjsJvmserverClassStrgUsed() {
        return Util.ConvertUnsignedBinary8(this.data, 352);
    }

    public BigInteger sjsJvmserverClassStrgUsedAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 352);
    }

    public long sjsJvmserverClassStrgAlloc() {
        return Util.ConvertUnsignedBinary8(this.data, 360);
    }

    public BigInteger sjsJvmserverClassStrgAllocAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 360);
    }

    public long sjsJvmserverClasscacheSize() {
        return Util.ConvertUnsignedBinary8(this.data, 368);
    }

    public BigInteger sjsJvmserverClasscacheSizeAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 368);
    }

    public long sjsJvmserverClasscacheFree() {
        return Util.ConvertUnsignedBinary8(this.data, 376);
    }

    public BigInteger sjsJvmserverClasscacheFreeAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 376);
    }

    public static JvmServerStatistics create(byte[] Data2, int offset, int length) {
        return new JvmServerStatistics(Data2, offset, length);
    }

    static enum Field {
        sjsdsLen(0, 2),
        sjsdsId(2, 2),
        sjsdsVers(4, 1),
        sjsJvmserverName(8, 8),
        sjsJvmserverJvmprofile(16, 8),
        sjsJvmserverLeRunopts(24, 8),
        sjsJvmserverUseCount(40, 4),
        sjsJvmserverState(44, 1),
        sjsJvmserverThreadLimit(48, 4),
        sjsJvmserverThreadCurrent(52, 4),
        sjsJvmserverThreadHwm(56, 4),
        sjsJvmserverThreadWaits(60, 4),
        sjsJvmserverThreadWaitTime(64, 8),
        sjsJvmserverThreadWaitCur(72, 4),
        sjsJvmserverThreadWaitHwm(76, 4),
        sjsJvmserverThreadWlpActv(80, 4),
        sjsJvmserverDefineSource(112, 8),
        sjsJvmserverChangeTime(120, 8),
        sjsJvmserverChangeUserid(128, 8),
        sjsJvmserverChangeAgent(136, 2),
        sjsJvmserverInstallAgent(138, 2),
        sjsJvmserverInstallTime(140, 8),
        sjsJvmserverInstallUserid(148, 8),
        sjsJvmserverSysUseCount(156, 4),
        sjsJvmserverSysWaited(160, 4),
        sjsJvmserverSysWaitedTime(164, 8),
        sjsJvmserverSysWaitCur(172, 4),
        sjsJvmserverSysWaitHwm(176, 4),
        sjsJvmserverJvmCreationGmt(180, 8),
        sjsJvmserverJvmCreationLcl(188, 8),
        sjsJvmserverCurrentHeap(200, 8),
        sjsJvmserverInitialHeap(208, 8),
        sjsJvmserverMaxHeap(216, 8),
        sjsJvmserverPeakHeap(224, 8),
        sjsJvmserverOccupancy(232, 8),
        sjsJvmserverGcPolicy(240, 32),
        sjsJvmserverMjrGcEvents(272, 4),
        sjsJvmserverMjrGcCpu(280, 8),
        sjsJvmserverMjrHeapFreed(288, 8),
        sjsJvmserverMnrGcEvents(296, 4),
        sjsJvmserverMnrGcCpu(304, 8),
        sjsJvmserverMnrHeapFreed(312, 8),
        sjsJvmserverCodeCacheUsed(320, 8),
        sjsJvmserverCodeCacheAlloc(328, 8),
        sjsJvmserverDataCacheUsed(336, 8),
        sjsJvmserverDataCacheAlloc(344, 8),
        sjsJvmserverClassStrgUsed(352, 8),
        sjsJvmserverClassStrgAlloc(360, 8),
        sjsJvmserverClasscacheSize(368, 8),
        sjsJvmserverClasscacheFree(376, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

