/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.LoaderGlobalDsaStatistics;
import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class LoaderGlobalStatistics
extends StatisticsDataSection {
    public static final int LDGIDE = 30;
    public static final int LDGVERS = 1;
    public static final int LDGHLEN = 8;
    public static final int LDGGLEN = 60;

    private LoaderGlobalStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int ldglen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int ldgid() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int ldgdvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public long ldgllr() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public Duration ldgllt() {
        return Util.Binary4_16_US(this.data, 12);
    }

    public double ldglltSeconds() {
        return Util.ToSeconds(this.ldgllt());
    }

    public double ldglltRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long ldgpuses() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long ldgwlr() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long ldgwlrhw() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long ldghwmt() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public Duration ldgttw() {
        return Util.Binary4_16_US(this.data, 32);
    }

    public double ldgttwSeconds() {
        return Util.ToSeconds(this.ldgttw());
    }

    public double ldgttwRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long ldgdrebs() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long ldgwtdlr() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long ldgllrro() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public Duration ldglltro() {
        return Util.Binary4_16_US(this.data, 48);
    }

    public double ldglltroSeconds() {
        return Util.ToSeconds(this.ldglltro());
    }

    public double ldglltroRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long ldglwsou() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public Duration ldglsort() {
        return Util.Binary8StckInterval(this.data, 56);
    }

    public double ldglsortSeconds() {
        return Util.ToSeconds(this.ldglsort());
    }

    public long ldglsortRawValue() {
        return Util.ConvertSignedBinary8(this.data, 56);
    }

    public long ldglbsou() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public List<LoaderGlobalDsaStatistics> loaderGlobalDsaStatistics() {
        int datastart = 68;
        int count = 6;
        ArrayList<LoaderGlobalDsaStatistics> result = new ArrayList<LoaderGlobalDsaStatistics>(count);
        for (int i = 0; i < count; ++i) {
            result.add(LoaderGlobalDsaStatistics.create(this.data, datastart + i * 48, 48));
        }
        return Collections.unmodifiableList(result);
    }

    public static LoaderGlobalStatistics create(byte[] Data2, int offset, int length) {
        return new LoaderGlobalStatistics(Data2, offset, length);
    }

    static enum Field {
        ldglen(0, 2),
        ldgid(2, 2),
        ldgdvers(4, 1),
        ldgllr(8, 4),
        ldgllt(12, 4),
        ldgpuses(16, 4),
        ldgwlr(20, 4),
        ldgwlrhw(24, 4),
        ldghwmt(28, 4),
        ldgttw(32, 4),
        ldgdrebs(36, 4),
        ldgwtdlr(40, 4),
        ldgllrro(44, 4),
        ldglltro(48, 4),
        ldglwsou(52, 4),
        ldglsort(56, 8),
        ldglbsou(64, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

