/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.internal.Util;

public final class NcStorageStatistics
extends StatisticsDataSection {
    public static final int S5IDE = 125;
    public static final int S5VERS = 1;
    public static final int S5CLEN = 104;

    private NcStorageStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int s5len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int s5id() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int s5dvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String s5anynam() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public long s5anysiz() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long s5anyptr() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long s5anymx() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long s5anyus() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public long s5anyfr() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long s5anylo() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long s5anyrqg() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long s5anyrqf() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long s5anyrqs() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long s5anyrqc() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public String s5lownam() {
        return Util.ConvertEbcdic(this.data, 56, 8);
    }

    public long s5lowsiz() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public long s5lowptr() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public long s5lowmx() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public long s5lowus() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public long s5lowfr() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public long s5lowlo() {
        return Util.ConvertUnsignedBinary4(this.data, 84);
    }

    public long s5lowrqg() {
        return Util.ConvertUnsignedBinary4(this.data, 88);
    }

    public long s5lowrqf() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    public long s5lowrqs() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public long s5lowrqc() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    public static NcStorageStatistics create(byte[] Data2, int offset, int length) {
        return new NcStorageStatistics(Data2, offset, length);
    }

    static enum Field {
        s5len(0, 2),
        s5id(2, 2),
        s5dvers(4, 1),
        s5anynam(8, 8),
        s5anysiz(16, 4),
        s5anyptr(20, 4),
        s5anymx(24, 4),
        s5anyus(28, 4),
        s5anyfr(32, 4),
        s5anylo(36, 4),
        s5anyrqg(40, 4),
        s5anyrqf(44, 4),
        s5anyrqs(48, 4),
        s5anyrqc(52, 4),
        s5lownam(56, 8),
        s5lowsiz(64, 4),
        s5lowptr(68, 4),
        s5lowmx(72, 4),
        s5lowus(76, 4),
        s5lowfr(80, 4),
        s5lowlo(84, 4),
        s5lowrqg(88, 4),
        s5lowrqf(92, 4),
        s5lowrqs(96, 4),
        s5lowrqc(100, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

