/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.CIAgent;
import com.blackhillsoftware.smf.cics.statistics.values.PiwProgramInterface;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDateTime;

public final class PipelineWebserviceStatistics
extends StatisticsDataSection {
    public static final int PIWDS_LENGTH = 1484;
    public static final int PIWIDR = 106;
    public static final int PIW_VERS = 1;
    public static final int PIW_VALIDATION_NO = 1;
    public static final int PIW_VALIDATION_YES = 2;

    private PipelineWebserviceStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int piwdsLen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int piwdsId() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int piwdsVers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String piwWebserviceName() {
        return Util.ConvertEbcdic(this.data, 8, 32);
    }

    public PiwProgramInterface piwProgramInterface() {
        int value = Util.ConvertUnsignedBinary1(this.data, 40);
        return PiwProgramInterface.from(value);
    }

    public int piwProgramInterfaceRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 40);
    }

    public int piwMsgValidation() {
        return Util.ConvertUnsignedBinary1(this.data, 41);
    }

    public String piwPipelineName() {
        return Util.ConvertEbcdic(this.data, 48, 8);
    }

    public String piwUrimapName() {
        return Util.ConvertEbcdic(this.data, 56, 8);
    }

    public String piwWsbindFile() {
        return Util.ConvertEbcdic(this.data, 72, 255);
    }

    public String piwWsdlFile() {
        return Util.ConvertEbcdic(this.data, 328, 255);
    }

    public String piwWsdlBinding() {
        return Util.ConvertEbcdic(this.data, 584, 255);
    }

    public String piwEndpointUri() {
        return Util.ConvertEbcdic(this.data, 840, 255);
    }

    public String piwWebserviceProgram() {
        return Util.ConvertEbcdic(this.data, 1104, 8);
    }

    public String piwContainerName() {
        return Util.ConvertEbcdic(this.data, 1112, 16);
    }

    public long piwWebserviceUseCount() {
        return Util.ConvertUnsignedBinary4(this.data, 1144);
    }

    public String piwArchiveFile() {
        return Util.ConvertEbcdic(this.data, 1168, 255);
    }

    public String piwWebserviceDefineSource() {
        return Util.ConvertEbcdic(this.data, 1440, 8);
    }

    public LocalDateTime piwWebserviceChangeTime() {
        return Util.Binary8xStckLocalTime(this.data, 1448);
    }

    public BigInteger piwWebserviceChangeTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1448);
    }

    public String piwWebserviceChangeUserid() {
        return Util.ConvertEbcdic(this.data, 1456, 8);
    }

    public CIAgent piwWebserviceChangeAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 1464);
        return CIAgent.from(value);
    }

    public int piwWebserviceChangeAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 1464);
    }

    public CIAgent piwWebserviceInstallAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 1466);
        return CIAgent.from(value);
    }

    public int piwWebserviceInstallAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 1466);
    }

    public LocalDateTime piwWebserviceInstallTime() {
        return Util.Binary8xStckLocalTime(this.data, 1468);
    }

    public BigInteger piwWebserviceInstallTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1468);
    }

    public String piwWebserviceInstallUserid() {
        return Util.ConvertEbcdic(this.data, 1476, 8);
    }

    public boolean piwValidationYes() {
        return Util.ConvertEquateValue(this.data, this.piwMsgValidation(), 2);
    }

    public static PipelineWebserviceStatistics create(byte[] Data2, int offset, int length) {
        return new PipelineWebserviceStatistics(Data2, offset, length);
    }

    static enum Field {
        piwdsLen(0, 2),
        piwdsId(2, 2),
        piwdsVers(4, 1),
        piwWebserviceName(8, 32),
        piwProgramInterface(40, 1),
        piwMsgValidation(41, 1),
        piwPipelineName(48, 8),
        piwUrimapName(56, 8),
        piwWsbindFile(72, 255),
        piwWsdlFile(328, 255),
        piwWsdlBinding(584, 255),
        piwEndpointUri(840, 255),
        piwWebserviceProgram(1104, 8),
        piwContainerName(1112, 16),
        piwWebserviceUseCount(1144, 4),
        piwArchiveFile(1168, 255),
        piwWebserviceDefineSource(1440, 8),
        piwWebserviceChangeTime(1448, 8),
        piwWebserviceChangeUserid(1456, 8),
        piwWebserviceChangeAgent(1464, 2),
        piwWebserviceInstallAgent(1466, 2),
        piwWebserviceInstallTime(1468, 8),
        piwWebserviceInstallUserid(1476, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

