/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class RecoveryManagerGlobalStatistics
extends StatisticsDataSection {
    public static final int RMGIDE = 99;
    public static final int RMGVERS = 1;

    private RecoveryManagerGlobalStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int rmglen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int rmgid() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int rmgdvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public long rmgsyfwd() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public long rmgsybwd() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long rmgresyn() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long rmgtshin() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public Duration rmgtshti() {
        return Util.Binary8StckInterval(this.data, 24);
    }

    public double rmgtshtiSeconds() {
        return Util.ToSeconds(this.rmgtshti());
    }

    public long rmgtshtiRawValue() {
        return Util.ConvertSignedBinary8(this.data, 24);
    }

    public long rmgcshin() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public Duration rmgcshti() {
        return Util.Binary8StckInterval(this.data, 36);
    }

    public double rmgcshtiSeconds() {
        return Util.ToSeconds(this.rmgcshti());
    }

    public long rmgcshtiRawValue() {
        return Util.ConvertSignedBinary8(this.data, 36);
    }

    public long rmgtshro() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public Duration rmgtshtr() {
        return Util.Binary8StckInterval(this.data, 48);
    }

    public double rmgtshtrSeconds() {
        return Util.ToSeconds(this.rmgtshtr());
    }

    public long rmgtshtrRawValue() {
        return Util.ConvertSignedBinary8(this.data, 48);
    }

    public long rmgcshro() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public Duration rmgcshtr() {
        return Util.Binary8StckInterval(this.data, 60);
    }

    public double rmgcshtrSeconds() {
        return Util.ToSeconds(this.rmgcshtr());
    }

    public long rmgcshtrRawValue() {
        return Util.ConvertSignedBinary8(this.data, 60);
    }

    public long rmgiaftr() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public long rmgiafti() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public long rmgiafnw() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public long rmgiafop() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public long rmgiafot() {
        return Util.ConvertUnsignedBinary4(this.data, 84);
    }

    public long rmgiamis() {
        return Util.ConvertUnsignedBinary4(this.data, 88);
    }

    public long rmgnwtd() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    public long rmgnw61() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public long rmgnwmro() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    public long rmgnwrmi() {
        return Util.ConvertUnsignedBinary4(this.data, 104);
    }

    public long rmgnwoth() {
        return Util.ConvertUnsignedBinary4(this.data, 108);
    }

    public static RecoveryManagerGlobalStatistics create(byte[] Data2, int offset, int length) {
        return new RecoveryManagerGlobalStatistics(Data2, offset, length);
    }

    static enum Field {
        rmglen(0, 2),
        rmgid(2, 2),
        rmgdvers(4, 1),
        rmgsyfwd(8, 4),
        rmgsybwd(12, 4),
        rmgresyn(16, 4),
        rmgtshin(20, 4),
        rmgtshti(24, 8),
        rmgcshin(32, 4),
        rmgcshti(36, 8),
        rmgtshro(44, 4),
        rmgtshtr(48, 8),
        rmgcshro(56, 4),
        rmgcshtr(60, 8),
        rmgiaftr(68, 4),
        rmgiafti(72, 4),
        rmgiafnw(76, 4),
        rmgiafop(80, 4),
        rmgiafot(84, 4),
        rmgiamis(88, 4),
        rmgnwtd(92, 4),
        rmgnw61(96, 4),
        rmgnwmro(100, 4),
        rmgnwrmi(104, 4),
        rmgnwoth(108, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

