/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.CIAgent;
import com.blackhillsoftware.smf.cics.statistics.values.IpFamily;
import com.blackhillsoftware.smf.cics.statistics.values.SorAttachsec;
import com.blackhillsoftware.smf.cics.statistics.values.SorAuthenticate;
import com.blackhillsoftware.smf.cics.statistics.values.SorPrivacy;
import com.blackhillsoftware.smf.cics.statistics.values.SorSslSupport;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;

public final class SocketsServiceStatistics
extends StatisticsDataSection {
    public static final int SORDS_LENGTH = 504;
    public static final int SORIDR = 108;
    public static final int SOR_VERS = 1;

    private SocketsServiceStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int sordsLen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int sordsId() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int sordsVers() {
        return Util.ConvertSignedBinary1(this.data, 4);
    }

    public String sorServiceName() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public long sorTransAttached() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long sorCurrentConns() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long sorPeakConns() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public ZonedDateTime sorOpenGmt() {
        return Util.Binary8xStckTime(this.data, 28);
    }

    public BigInteger sorOpenGmtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 28);
    }

    public LocalDateTime sorOpenLocal() {
        return Util.Binary8xStckLocalTime(this.data, 36);
    }

    public BigInteger sorOpenLocalRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 36);
    }

    public ZonedDateTime sorCloseGmt() {
        return Util.Binary8xStckTime(this.data, 44);
    }

    public BigInteger sorCloseGmtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 44);
    }

    public LocalDateTime sorCloseLocal() {
        return Util.Binary8xStckLocalTime(this.data, 52);
    }

    public BigInteger sorCloseLocalRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 52);
    }

    public int sorPortNumber() {
        return Util.ConvertUnsignedBinary2(this.data, 60);
    }

    public SorSslSupport sorSslSupport() {
        int value = Util.ConvertUnsignedBinary1(this.data, 62);
        return SorSslSupport.from(value);
    }

    public int sorSslSupportRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 62);
    }

    public long sorBacklog() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public long sorSends() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public long sorBytesSent() {
        return Util.ConvertUnsignedBinary8(this.data, 72);
    }

    public BigInteger sorBytesSentAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 72);
    }

    public long sorReceives() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public long sorBytesReceived() {
        return Util.ConvertUnsignedBinary8(this.data, 84);
    }

    public BigInteger sorBytesReceivedAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 84);
    }

    public String sorWlmGroup() {
        return Util.ConvertEbcdic(this.data, 108, 18);
    }

    public String sorProtocol() {
        return Util.ConvertEbcdic(this.data, 128, 8);
    }

    public SorAuthenticate sorAuthenticate() {
        int value = Util.ConvertUnsignedBinary1(this.data, 136);
        return SorAuthenticate.from(value);
    }

    public int sorAuthenticateRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 136);
    }

    public SorPrivacy sorPrivacy() {
        int value = Util.ConvertUnsignedBinary1(this.data, 137);
        return SorPrivacy.from(value);
    }

    public int sorPrivacyRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 137);
    }

    public SorAttachsec sorAttachsec() {
        int value = Util.ConvertUnsignedBinary1(this.data, 138);
        return SorAttachsec.from(value);
    }

    public int sorAttachsecRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 138);
    }

    public long sorMaxdataLength() {
        return Util.ConvertUnsignedBinary4(this.data, 152);
    }

    public String sorTcpipsTranid() {
        return Util.ConvertEbcdic(this.data, 156, 4);
    }

    public String sorTcpipsUrm() {
        return Util.ConvertEbcdic(this.data, 160, 8);
    }

    public long sorTcpipsMaxPersist() {
        return Util.ConvertUnsignedBinary4(this.data, 168);
    }

    public long sorTcpipsNonPersist() {
        return Util.ConvertUnsignedBinary4(this.data, 172);
    }

    public String sorIpAddress() {
        return Util.ConvertEbcdic(this.data, 192, 39);
    }

    public InetAddress sorIpAddressAsInetAddress() throws UnknownHostException {
        return Util.ConvertInetTextAddress(this.data, 192, 39);
    }

    public IpFamily sorIpFamily() {
        int value = Util.ConvertUnsignedBinary1(this.data, 231);
        return IpFamily.from(value);
    }

    public int sorIpFamilyRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 231);
    }

    public String sorHostname() {
        return Util.ConvertEbcdic(this.data, 232, 116);
    }

    public String sorDefineSource() {
        return Util.ConvertEbcdic(this.data, 352, 8);
    }

    public LocalDateTime sorChangeTime() {
        return Util.Binary8xStckLocalTime(this.data, 360);
    }

    public BigInteger sorChangeTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 360);
    }

    public String sorChangeUserid() {
        return Util.ConvertEbcdic(this.data, 368, 8);
    }

    public CIAgent sorChangeAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 376);
        return CIAgent.from(value);
    }

    public int sorChangeAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 376);
    }

    public CIAgent sorInstallAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 378);
        return CIAgent.from(value);
    }

    public int sorInstallAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 378);
    }

    public LocalDateTime sorInstallTime() {
        return Util.Binary8xStckLocalTime(this.data, 380);
    }

    public BigInteger sorInstallTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 380);
    }

    public String sorInstallUserid() {
        return Util.ConvertEbcdic(this.data, 388, 8);
    }

    public long sorTotalConns() {
        return Util.ConvertUnsignedBinary4(this.data, 396);
    }

    public long sorNonpAtMaxpersist() {
        return Util.ConvertUnsignedBinary4(this.data, 400);
    }

    public long sorNonpAtTaskLimit() {
        return Util.ConvertUnsignedBinary4(this.data, 404);
    }

    public long sorDiscAtTaskLimit() {
        return Util.ConvertUnsignedBinary4(this.data, 408);
    }

    public long sorDiscAtMaxUses() {
        return Util.ConvertUnsignedBinary4(this.data, 412);
    }

    public long sorCurrBacklog() {
        return Util.ConvertUnsignedBinary4(this.data, 416);
    }

    public long sorConnsDropped() {
        return Util.ConvertUnsignedBinary4(this.data, 420);
    }

    public LocalDateTime sorConnLastDropped() {
        return Util.Binary8xStckLocalTime(this.data, 424);
    }

    public BigInteger sorConnLastDroppedRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 424);
    }

    public long sorCurrMaxBacklog() {
        return Util.ConvertUnsignedBinary4(this.data, 432);
    }

    public long sorRequests() {
        return Util.ConvertUnsignedBinary4(this.data, 436);
    }

    public String sorTcpipsOptionsPgm() {
        return Util.ConvertEbcdic(this.data, 440, 8);
    }

    public static SocketsServiceStatistics create(byte[] Data2, int offset, int length) {
        return new SocketsServiceStatistics(Data2, offset, length);
    }

    static enum Field {
        sordsLen(0, 2),
        sordsId(2, 2),
        sordsVers(4, 1),
        sorServiceName(8, 8),
        sorTransAttached(16, 4),
        sorCurrentConns(20, 4),
        sorPeakConns(24, 4),
        sorOpenGmt(28, 8),
        sorOpenLocal(36, 8),
        sorCloseGmt(44, 8),
        sorCloseLocal(52, 8),
        sorPortNumber(60, 2),
        sorSslSupport(62, 1),
        sorBacklog(64, 4),
        sorSends(68, 4),
        sorBytesSent(72, 8),
        sorReceives(80, 4),
        sorBytesReceived(84, 8),
        sorWlmGroup(108, 18),
        sorProtocol(128, 8),
        sorAuthenticate(136, 1),
        sorPrivacy(137, 1),
        sorAttachsec(138, 1),
        sorMaxdataLength(152, 4),
        sorTcpipsTranid(156, 4),
        sorTcpipsUrm(160, 8),
        sorTcpipsMaxPersist(168, 4),
        sorTcpipsNonPersist(172, 4),
        sorIpAddress(192, 39),
        sorIpFamily(231, 1),
        sorHostname(232, 116),
        sorDefineSource(352, 8),
        sorChangeTime(360, 8),
        sorChangeUserid(368, 8),
        sorChangeAgent(376, 2),
        sorInstallAgent(378, 2),
        sorInstallTime(380, 8),
        sorInstallUserid(388, 8),
        sorTotalConns(396, 4),
        sorNonpAtMaxpersist(400, 4),
        sorNonpAtTaskLimit(404, 4),
        sorDiscAtTaskLimit(408, 4),
        sorDiscAtMaxUses(412, 4),
        sorCurrBacklog(416, 4),
        sorConnsDropped(420, 4),
        sorConnLastDropped(424, 8),
        sorCurrMaxBacklog(432, 4),
        sorRequests(436, 4),
        sorTcpipsOptionsPgm(440, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

