/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.Location;
import com.blackhillsoftware.smf.cics.statistics.values.SmdAccess;
import com.blackhillsoftware.smf.cics.statistics.values.SmdDsaIndexes;
import com.blackhillsoftware.smf.cics.statistics.values.SmdETypes;
import com.blackhillsoftware.smf.internal.Util;

public final class StorageDomainSubpoolStatistics
extends StatisticsDataSection {
    public static final int SMDIDE = 19;
    public static final int SMDVERS = 1;

    private StorageDomainSubpoolStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int smdlen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smdid() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smddvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String smdspn() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public String smddsaname() {
        return Util.ConvertEbcdic(this.data, 16, 8);
    }

    public SmdETypes smdetype() {
        int value = Util.ConvertUnsignedBinary1(this.data, 24);
        return SmdETypes.from(value);
    }

    public int smdetypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 24);
    }

    public long smdflen() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public int smdelchn() {
        return Util.ConvertUnsignedBinary1(this.data, 32);
    }

    public long smdbndry() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public Location smdlocn() {
        int value = Util.ConvertUnsignedBinary1(this.data, 40);
        return Location.from(value);
    }

    public int smdlocnRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 40);
    }

    public SmdAccess smdaccess() {
        int value = Util.ConvertUnsignedBinary1(this.data, 41);
        return SmdAccess.from(value);
    }

    public int smdaccessRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 41);
    }

    public SmdDsaIndexes smddsaindex() {
        int value = Util.ConvertUnsignedBinary1(this.data, 42);
        return SmdDsaIndexes.from(value);
    }

    public int smddsaindexRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 42);
    }

    public long smdifree() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long smdgmreq() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long smdfmreq() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long smdces() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public long smdcps() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public long smdcelem() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public long smdhwmps() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public static StorageDomainSubpoolStatistics create(byte[] Data2, int offset, int length) {
        return new StorageDomainSubpoolStatistics(Data2, offset, length);
    }

    static enum Field {
        smdlen(0, 2),
        smdid(2, 2),
        smddvers(4, 1),
        smdspn(8, 8),
        smddsaname(16, 8),
        smdetype(24, 1),
        smdflen(28, 4),
        smdelchn(32, 1),
        smdbndry(36, 4),
        smdlocn(40, 1),
        smdaccess(41, 1),
        smddsaindex(42, 1),
        smdifree(44, 4),
        smdgmreq(48, 4),
        smdfmreq(52, 4),
        smdces(56, 4),
        smdcps(60, 4),
        smdcelem(64, 4),
        smdhwmps(68, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

