/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;

public final class TransactionManagerGlobalStatistics
extends StatisticsDataSection {
    public static final int XMGIDE = 10;
    public static final int XMGVERS = 1;
    public static final int XMGCAMXT = 128;

    private TransactionManagerGlobalStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int xmglen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int xmgid() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int xmgdvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public long xmgnum() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public long xmgmxt() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long xmgcat() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long xmgcqt() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long xmgtamxt() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long xmgpat() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public long xmgpqt() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long xmgtat() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long xmgtdt() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public Duration xmgtqtme() {
        return Util.Binary8StckInterval(this.data, 44);
    }

    public double xmgtqtmeSeconds() {
        return Util.ToSeconds(this.xmgtqtme());
    }

    public long xmgtqtmeRawValue() {
        return Util.ConvertSignedBinary8(this.data, 44);
    }

    public Duration xmgcqtme() {
        return Util.Binary8StckInterval(this.data, 52);
    }

    public double xmgcqtmeSeconds() {
        return Util.ToSeconds(this.xmgcqtme());
    }

    public long xmgcqtmeRawValue() {
        return Util.ConvertSignedBinary8(this.data, 52);
    }

    public long xmgtnum() {
        return Util.ConvertUnsignedBinary8(this.data, 64);
    }

    public BigInteger xmgtnumAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 64);
    }

    public ZonedDateTime xmggtat() {
        return Util.Binary8xStckTime(this.data, 72);
    }

    public BigInteger xmggtatRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 72);
    }

    public LocalDateTime xmgltat() {
        return Util.Binary8xStckLocalTime(this.data, 80);
    }

    public BigInteger xmgltatRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 80);
    }

    public ZonedDateTime xmggsmxt() {
        return Util.Binary8xStckTime(this.data, 88);
    }

    public BigInteger xmggsmxtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 88);
    }

    public LocalDateTime xmglsmxt() {
        return Util.Binary8xStckLocalTime(this.data, 96);
    }

    public BigInteger xmglsmxtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 96);
    }

    public ZonedDateTime xmggamxt() {
        return Util.Binary8xStckTime(this.data, 104);
    }

    public BigInteger xmggamxtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 104);
    }

    public LocalDateTime xmglamxt() {
        return Util.Binary8xStckLocalTime(this.data, 112);
    }

    public BigInteger xmglamxtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 112);
    }

    public int xmgatmxt() {
        return Util.ConvertUnsignedBinary1(this.data, 120);
    }

    public boolean xmgcamxt() {
        return Util.ConvertFlag(this.data, this.xmgatmxt(), 128);
    }

    public static TransactionManagerGlobalStatistics create(byte[] Data2, int offset, int length) {
        return new TransactionManagerGlobalStatistics(Data2, offset, length);
    }

    static enum Field {
        xmglen(0, 2),
        xmgid(2, 2),
        xmgdvers(4, 1),
        xmgnum(8, 4),
        xmgmxt(12, 4),
        xmgcat(16, 4),
        xmgcqt(20, 4),
        xmgtamxt(24, 4),
        xmgpat(28, 4),
        xmgpqt(32, 4),
        xmgtat(36, 4),
        xmgtdt(40, 4),
        xmgtqtme(44, 8),
        xmgcqtme(52, 8),
        xmgtnum(64, 8),
        xmggtat(72, 8),
        xmgltat(80, 8),
        xmggsmxt(88, 8),
        xmglsmxt(96, 8),
        xmggamxt(104, 8),
        xmglamxt(112, 8),
        xmgatmxt(120, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

