/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalTime;

public final class VtamGlobalStatistics
extends StatisticsDataSection {
    public static final int A03IDE = 21;
    public static final int A03VERS = 1;
    public static final int A03VON = 1;
    public static final int A03VOFF = 0;

    private VtamGlobalStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int a03len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int a03id() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int a03dvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int a03rplxt() {
        return Util.ConvertPacked4(this.data, 8);
    }

    public int a03rplx() {
        return Util.ConvertPacked2(this.data, 12);
    }

    public int a03vtsos() {
        return Util.ConvertUnsignedBinary2(this.data, 14);
    }

    public int a03doc() {
        return Util.ConvertUnsignedBinary2(this.data, 16);
    }

    public long a03lunum() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long a03luhwm() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long a03psic() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public long a03psnc() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long a03psoc() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long a03psuc() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long a03psec() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public String a03pstyp() {
        return Util.ConvertEbcdic(this.data, 48, 4);
    }

    public LocalTime a03psdin() {
        return Util.Packed_HHMMSS(this.data, 52);
    }

    public int a03psdinRawValue() {
        return Util.ConvertPacked4(this.data, 52);
    }

    public int a03bmvl() {
        return Util.ConvertUnsignedBinary1(this.data, 56);
    }

    public boolean a03von() {
        return Util.ConvertEquateValue(this.data, this.a03bmvl(), 1);
    }

    public long a03bmig() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public long a03bmlg() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public long a03bmab() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public static VtamGlobalStatistics create(byte[] Data2, int offset, int length) {
        return new VtamGlobalStatistics(Data2, offset, length);
    }

    static enum Field {
        a03len(0, 2),
        a03id(2, 2),
        a03dvers(4, 1),
        a03rplxt(8, 4),
        a03rplx(12, 2),
        a03vtsos(14, 2),
        a03doc(16, 2),
        a03lunum(20, 4),
        a03luhwm(24, 4),
        a03psic(28, 4),
        a03psnc(32, 4),
        a03psoc(36, 4),
        a03psuc(40, 4),
        a03psec(44, 4),
        a03pstyp(48, 4),
        a03psdin(52, 4),
        a03bmvl(56, 1),
        a03bmig(60, 4),
        a03bmlg(64, 4),
        a03bmab(68, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

