/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics.values;

import java.util.HashMap;
import java.util.Map;

public enum CIAgent {
    UNKNOWN(0),
    CSDAPI(1),
    CSDBATCH(2),
    DREPAPI(3),
    CREATE(4),
    GRPLIST(5),
    AUTOINSTALL(6),
    SYSTEM(7),
    DYNAMIC(8),
    BUNDLE(9),
    TABLE(10),
    NOT_DEFINED(-16);

    private static Map<Integer, CIAgent> valueMap;
    private final int value;

    private CIAgent(int value) {
        this.value = value;
    }

    public static CIAgent from(int value) {
        CIAgent result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int value() {
        return this.value;
    }

    static {
        valueMap = new HashMap<Integer, CIAgent>();
        for (CIAgent x : CIAgent.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.value, x);
        }
    }
}

