/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics.values;

import java.util.HashMap;
import java.util.Map;

public enum LdpLocation {
    NOCOPY(0),
    CDSA(1),
    LPA(3),
    ECDSA(4),
    ERDSA(6),
    ELPA(7),
    SDSA(8),
    ESDSA(9),
    RDSA(10),
    PCDSA(11),
    PUDSA(12),
    EPCDSA(13),
    EPUDSA(14),
    NOT_DEFINED(-16);

    private static Map<Integer, LdpLocation> valueMap;
    private final int ldplocation;

    private LdpLocation(int ldplocation) {
        this.ldplocation = ldplocation;
    }

    public static LdpLocation from(int value) {
        LdpLocation result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int ldplocation() {
        return this.ldplocation;
    }

    static {
        valueMap = new HashMap<Integer, LdpLocation>();
        for (LdpLocation x : LdpLocation.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.ldplocation, x);
        }
    }
}

