/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics.values;

import java.util.HashMap;
import java.util.Map;

public enum LgdDsaType {
    CDSA(1),
    ECDSA(2),
    SDSA(3),
    ESDSA(4),
    RDSA(5),
    ERDSA(6),
    NOT_DEFINED(-16);

    private static Map<Integer, LgdDsaType> valueMap;
    private final int lgddsatype;

    private LgdDsaType(int lgddsatype) {
        this.lgddsatype = lgddsatype;
    }

    public static LgdDsaType from(int value) {
        LgdDsaType result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int lgddsatype() {
        return this.lgddsatype;
    }

    static {
        valueMap = new HashMap<Integer, LgdDsaType>();
        for (LgdDsaType x : LgdDsaType.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.lgddsatype, x);
        }
    }
}

