/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics.values;

import java.util.HashMap;
import java.util.Map;

public enum SmsState {
    NORMAL(1),
    SOS(2),
    CONSTRAINED(3),
    NOT_DEFINED(-16);

    private static Map<Integer, SmsState> valueMap;
    private final int smsstate;

    private SmsState(int smsstate) {
        this.smsstate = smsstate;
    }

    public static SmsState from(int value) {
        SmsState result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int smsstate() {
        return this.smsstate;
    }

    static {
        valueMap = new HashMap<Integer, SmsState>();
        for (SmsState x : SmsState.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.smsstate, x);
        }
    }
}

