/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.counterid;

import java.util.HashMap;
import java.util.Map;

public enum NnpiCounters {
    NNPA_ADD(1),
    NNPA_SUB(2),
    NNPA_MUL(3),
    NNPA_DIV(4),
    NNPA_MIN(5),
    NNPA_MAX(6),
    NNPA_LOG(7),
    NNPA_EXP(8),
    NNPA_RELU(10),
    NNPA_TANH(11),
    NNPA_SIGMOID(12),
    NNPA_SOFTMAX(13),
    NNPA_BATCHNORM(14),
    NNPA_MAXPOOL2D(15),
    NNPA_AVGPOOL2D(16),
    NNPA_LSTMACT(17),
    NNPA_GRUACT(18),
    NNPA_CONVOLUTION(19),
    NNPA_MATMUL_OP(20),
    NNPA_MATMUL_OP_BCAST23(21),
    NNPA_Small_Batch(22),
    NNPA_Large_Dimension(23),
    NNPA_Very_Small_Tensor(24),
    NNPA_1M_Frame_Suitable(25),
    NNPA_2G_Frame_Suitable(26),
    NNPA_Access_Exception(27),
    NOT_DEFINED(-1);

    private static Map<Integer, NnpiCounters> valueMap;
    private final transient int nnpiCounter;

    private NnpiCounters(int nnpiCounter) {
        this.nnpiCounter = nnpiCounter;
    }

    public static NnpiCounters from(int value) {
        NnpiCounters result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int nnpiCounter() {
        return this.nnpiCounter;
    }

    static {
        valueMap = new HashMap<Integer, NnpiCounters>();
        for (NnpiCounters x : NnpiCounters.values()) {
            if (x.nnpiCounter < 0) continue;
            valueMap.put(x.nnpiCounter, x);
        }
    }
}

