/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.dataset;

import java.util.HashMap;
import java.util.Map;

public enum Dsorg {
    NULL(false),
    PS(false),
    DA(false),
    PO(false),
    GS(false),
    VS(false),
    CX(false),
    CQ(false),
    MQ(false),
    TX(false),
    TQ(false),
    TR(false),
    PSU(true),
    DAU(true),
    POU(true),
    NOT_DEFINED(false);

    transient boolean u;
    private static Map<Integer, Dsorg> dsorgValues;

    private Dsorg(boolean u) {
        this.u = u;
    }

    public boolean unmovable() {
        return this.u;
    }

    public static Dsorg fromDsorgBytes(int dsorgBytes) {
        if (dsorgBytes == 0) {
            return NULL;
        }
        Dsorg result = dsorgValues.get(dsorgBytes);
        if (result == null) {
            result = Dsorg.dsorgValue(dsorgBytes);
            dsorgValues.put(dsorgBytes, result);
        }
        return result;
    }

    private static Dsorg dsorgValue(int dsorgBytes) {
        int ps = dsorgBytes & 0x4000;
        int da = dsorgBytes & 0x2000;
        int cx = dsorgBytes & 0x1000;
        int cq = dsorgBytes & 0x800;
        int mq = dsorgBytes & 0x400;
        int po = dsorgBytes & 0x200;
        int u = dsorgBytes & 0x100;
        int gs = dsorgBytes & 0x80;
        int tx = dsorgBytes & 0x40;
        int tq = dsorgBytes & 0x20;
        int vs = dsorgBytes & 8;
        int tr = dsorgBytes & 4;
        Dsorg result = NOT_DEFINED;
        if (ps != 0) {
            result = u == 0 ? PS : PSU;
        } else if (po != 0) {
            result = u == 0 ? PO : POU;
        } else if (da != 0) {
            result = u == 0 ? DA : DAU;
        } else if (vs != 0) {
            result = VS;
        } else if (gs != 0) {
            result = GS;
        } else if (cx != 0) {
            result = CX;
        } else if (cq != 0) {
            result = CQ;
        } else if (mq != 0) {
            result = MQ;
        } else if (tx != 0) {
            result = TX;
        } else if (tq != 0) {
            result = TQ;
        } else if (tr != 0) {
            result = TR;
        }
        return result;
    }

    static {
        dsorgValues = new HashMap<Integer, Dsorg>();
    }
}

