/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.db2.section;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.db2.SmfDb2Record;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;

public final class Qbsp
extends SmfData {
    public static final int QBSPCON = 128;
    public static final int QBSPEND = 104;

    private Qbsp(byte[] Data2, int offset, int length, SmfDb2Record parent) {
        super(Data2, offset, length);
    }

    public long qbspbpid() {
        return Util.ConvertUnsignedBinary4(this.data, 0);
    }

    public int qbspflg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public boolean qbspcon() {
        return Util.ConvertFlag(this.data, this.qbspflg(), 128);
    }

    public long qbspius() {
        return Util.ConvertUnsignedBinary8(this.data, 8);
    }

    public BigInteger qbspiusAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 8);
    }

    public long qbsphus() {
        return Util.ConvertUnsignedBinary8(this.data, 16);
    }

    public BigInteger qbsphusAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 16);
    }

    public long qbspsus() {
        return Util.ConvertUnsignedBinary8(this.data, 24);
    }

    public BigInteger qbspsusAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 24);
    }

    public long qbsphsu() {
        return Util.ConvertUnsignedBinary8(this.data, 32);
    }

    public BigInteger qbsphsuAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 32);
    }

    public long qbspdrr() {
        return Util.ConvertUnsignedBinary8(this.data, 40);
    }

    public BigInteger qbspdrrAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 40);
    }

    public long qbspdrs() {
        return Util.ConvertUnsignedBinary8(this.data, 48);
    }

    public BigInteger qbspdrsAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 48);
    }

    public long qbspdra() {
        return Util.ConvertUnsignedBinary8(this.data, 56);
    }

    public BigInteger qbspdraAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 56);
    }

    public long qbspgrr() {
        return Util.ConvertUnsignedBinary8(this.data, 64);
    }

    public BigInteger qbspgrrAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 64);
    }

    public long qbspgrs() {
        return Util.ConvertUnsignedBinary8(this.data, 72);
    }

    public BigInteger qbspgrsAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 72);
    }

    public long qbspgra() {
        return Util.ConvertUnsignedBinary8(this.data, 80);
    }

    public BigInteger qbspgraAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 80);
    }

    public long qbspmvi() {
        return Util.ConvertUnsignedBinary8(this.data, 88);
    }

    public BigInteger qbspmviAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 88);
    }

    public Duration qbspdtm() {
        return Util.Binary8USSeconds(this.data, 96);
    }

    public double qbspdtmSeconds() {
        return Util.ToSeconds(this.qbspdtm());
    }

    public BigInteger qbspdtmRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 96);
    }

    public static Qbsp create(byte[] Data2, int offset, int length, SmfDb2Record parent) {
        return new Qbsp(Data2, offset, length, parent);
    }

    static enum Field {
        qbspbpid(0, 4),
        qbspflg(4, 1),
        qbspius(8, 8),
        qbsphus(16, 8),
        qbspsus(24, 8),
        qbsphsu(32, 8),
        qbspdrr(40, 8),
        qbspdrs(48, 8),
        qbspdra(56, 8),
        qbspgrr(64, 8),
        qbspgrs(72, 8),
        qbspgra(80, 8),
        qbspmvi(88, 8),
        qbspdtm(96, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

