/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.db2.section;

import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.db2.SmfDb2Record;
import com.blackhillsoftware.smf.internal.Util;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class Qdbp
extends SmfData {
    private int qwhsrn;
    public static final String QDBPCYC = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(232).array(), 3, 1);
    public static final String QDBPCNC = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(213).array(), 3, 1);
    public static final String QDBPVPC = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(215).array(), 3, 1);
    public static final String QDBPVDC = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(196).array(), 3, 1);
    public static final String QDBPPLC = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(211).array(), 3, 1);
    public static final String QDBPPFC = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(198).array(), 3, 1);
    public static final String QDBPPNC = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(213).array(), 3, 1);
    public static final String QDBPFYC = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(232).array(), 3, 1);
    public static final String QDBPFNC = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(213).array(), 3, 1);
    public static final int QDBPEND = 48;

    private Qdbp(byte[] Data2, int offset, int length, SmfDb2Record parent) {
        super(Data2, offset, length);
        this.qwhsrn = parent.qwhs().qwhsrn();
    }

    public String qdbpnm() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public long qdbpvpsz() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public int qdbpvpsh() {
        return Util.ConvertUnsignedBinary1(this.data, 16);
    }

    public int qdbpdwqt() {
        return Util.ConvertUnsignedBinary1(this.data, 18);
    }

    public int qdbpvdqt() {
        return Util.ConvertUnsignedBinary1(this.data, 19);
    }

    public int qdbppsqt() {
        return Util.ConvertUnsignedBinary1(this.data, 21);
    }

    public int qdbpxsqt() {
        return Util.ConvertUnsignedBinary1(this.data, 22);
    }

    public String qdbppfix() {
        return Util.ConvertEbcdic(this.data, 23, 1);
    }

    public int qdbpvdqb() {
        return Util.ConvertUnsignedBinary2(this.data, 24);
    }

    public int qdbpsla() {
        if (this.qwhsrn > 161) {
            throw new NotAvailableException("This method is only supported when qwhsrn <= A1)");
        }
        return Util.ConvertUnsignedBinary2(this.data, 26);
    }

    public String qdbppgst() {
        return Util.ConvertEbcdic(this.data, 28, 1);
    }

    public String qdbpasiz() {
        return Util.ConvertEbcdic(this.data, 29, 1);
    }

    public String qdbpfram() {
        return Util.ConvertEbcdic(this.data, 30, 2);
    }

    public long qdbpvpmi() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long qdbpvpma() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long qdbpspsz() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public int qdbpspst() {
        return Util.ConvertUnsignedBinary1(this.data, 44);
    }

    public static Qdbp create(byte[] Data2, int offset, int length, SmfDb2Record parent) {
        return new Qdbp(Data2, offset, length, parent);
    }

    static enum Field {
        qdbpnm(0, 8),
        qdbpvpsz(8, 4),
        qdbpvpsh(16, 1),
        qdbpdwqt(18, 1),
        qdbpvdqt(19, 1),
        qdbppsqt(21, 1),
        qdbpxsqt(22, 1),
        qdbppfix(23, 1),
        qdbpvdqb(24, 2),
        qdbpsla(26, 2),
        qdbppgst(28, 1),
        qdbpasiz(29, 1),
        qdbpfram(30, 2),
        qdbpvpmi(32, 4),
        qdbpvpma(36, 4),
        qdbpspsz(40, 4),
        qdbpspst(44, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

