/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.internal;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDateTime;

public final class DebExtension
extends SmfData {
    public static final int DEBXCDCB = 128;
    public static final int DEBXTSKC = 64;
    public static final int DEBXDSSI = 32;
    public static final int DEBXWIND = 16;
    public static final int DEBXACIS = 8;
    public static final int DEBXNFLS = 4;
    public static final int DEBXSYSB = 2;
    public static final int DEBXRACE = 1;
    public static final int DEBXRSAP = 128;
    public static final int DEBBYP = 64;
    public static final int DEBCHCMP = 32;
    public static final int DEBXENQA = 16;
    public static final int DEBXENQS = 8;
    public static final int DEBXIMSC = 4;
    public static final int DEBXCASV = 2;
    public static final int DEBXMVLF = 1;
    public static final int DEBNSHED = 128;
    public static final int DEBXVDEF = 64;
    public static final int DEBECKD = 192;
    public static final int DEBGAEX1 = 128;
    public static final int DEBGAEX2 = 64;
    public static final int DEBSTRTP = 32;
    public static final int DEBGA345 = 28;
    public static final int DEBGA1 = 16;
    public static final int DEBGA2 = 8;
    public static final int DEBGA3 = 4;
    public static final int DEBNCACH = 0;
    public static final int DEBBCACH = 4;
    public static final int DEBICACH = 8;
    public static final int DEBSCACH = 12;
    public static final int DEBXRFLG = 16;
    public static final int DEBRLC = 20;
    public static final int DEBNRD = 2;
    public static final int DEBINHFW = 1;
    public static final int DEBRMODE = 0;
    public static final int DEBRDATA = 64;
    public static final int DEBSKEY = 128;
    public static final int DEBDFTR0 = 4;
    public static final int DEBXTRNC = 128;
    public static final int DEBXNSEG = 64;
    public static final int DEBXSMSG = 32;
    public static final int DEBXDUDA = 16;
    public static final int DEBXCAP = 8;
    public static final int DEBXVTOC = 4;
    public static final int DEBXENQE = 2;
    public static final int DEBXUCNT = 1;
    public static final int DEBXABSS = 128;
    public static final int DEBXARBA = 64;
    public static final int DEBXAOEF = 32;
    public static final int DEBXAIB = 16;
    public static final int DEBXAENCCB = 8;
    public static final int DEBXADS = 128;
    public static final int DEBXAINP = 64;
    public static final int DEBXAOUT = 32;
    public static final int DEBXAOFO = 16;
    public static final int DEBXLGDS = 8;
    public static final int DEBXDEBLOCKX = 4;
    public static final int DEBXDEBLOCK = 4;
    public static final int DEBXIMG = 2;
    public static final int DEBXEXP = 1;
    public static final int DEBXLEN = 84;

    private DebExtension(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int debxlngh() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int debxflg1() {
        return Util.ConvertUnsignedBinary1(this.data, 2);
    }

    public boolean debxcdcb() {
        return Util.ConvertFlag(this.data, this.debxflg1(), 128);
    }

    public boolean debxtskc() {
        return Util.ConvertFlag(this.data, this.debxflg1(), 64);
    }

    public boolean debxdssi() {
        return Util.ConvertFlag(this.data, this.debxflg1(), 32);
    }

    public boolean debxwind() {
        return Util.ConvertFlag(this.data, this.debxflg1(), 16);
    }

    public boolean debxacis() {
        return Util.ConvertFlag(this.data, this.debxflg1(), 8);
    }

    public boolean debxnfls() {
        return Util.ConvertFlag(this.data, this.debxflg1(), 4);
    }

    public boolean debxsysb() {
        return Util.ConvertFlag(this.data, this.debxflg1(), 2);
    }

    public boolean debxrace() {
        return Util.ConvertFlag(this.data, this.debxflg1(), 1);
    }

    public int debxflg2() {
        return Util.ConvertUnsignedBinary1(this.data, 3);
    }

    public boolean debxrsap() {
        return Util.ConvertFlag(this.data, this.debxflg2(), 128);
    }

    public boolean debbyp() {
        return Util.ConvertFlag(this.data, this.debxflg2(), 64);
    }

    public boolean debchcmp() {
        return Util.ConvertFlag(this.data, this.debxflg2(), 32);
    }

    public boolean debxenqa() {
        return Util.ConvertFlag(this.data, this.debxflg2(), 16);
    }

    public boolean debxenqs() {
        return Util.ConvertFlag(this.data, this.debxflg2(), 8);
    }

    public boolean debximsc() {
        return Util.ConvertFlag(this.data, this.debxflg2(), 4);
    }

    public boolean debxcasv() {
        return Util.ConvertFlag(this.data, this.debxflg2(), 2);
    }

    public boolean debxmvlf() {
        return Util.ConvertFlag(this.data, this.debxflg2(), 1);
    }

    public long debxdsab() {
        return Util.ConvertUnsignedBinary4(this.data, 4);
    }

    public long debxdcbm() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public long debxdbpr() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public int debxdso1() {
        return Util.ConvertUnsignedBinary1(this.data, 16);
    }

    public int debxdso2() {
        return Util.ConvertUnsignedBinary1(this.data, 17);
    }

    public int debxmcf1() {
        return Util.ConvertUnsignedBinary1(this.data, 18);
    }

    public int debxmcf2() {
        return Util.ConvertUnsignedBinary1(this.data, 19);
    }

    public long debxxarg() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long debxopnj() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long debxsamb() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public LocalDateTime debxopet() {
        return Util.Binary8xStckLocalTime(this.data, 32);
    }

    public BigInteger debxopetRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 32);
    }

    public int debdefg1() {
        return Util.ConvertUnsignedBinary1(this.data, 40);
    }

    public boolean debnshed() {
        return Util.ConvertFlag(this.data, this.debdefg1(), 128);
    }

    public boolean debxvdef() {
        return Util.ConvertFlag(this.data, this.debdefg1(), 64);
    }

    public int debgattr() {
        return Util.ConvertUnsignedBinary1(this.data, 41);
    }

    public boolean debgaex1() {
        return Util.ConvertFlag(this.data, this.debgattr(), 128);
    }

    public boolean debgaex2() {
        return Util.ConvertFlag(this.data, this.debgattr(), 64);
    }

    public boolean debstrtp() {
        return Util.ConvertFlag(this.data, this.debgattr(), 32);
    }

    public boolean debga1() {
        return Util.ConvertFlag(this.data, this.debgattr(), 16);
    }

    public boolean debga2() {
        return Util.ConvertFlag(this.data, this.debgattr(), 8);
    }

    public boolean debga3() {
        return Util.ConvertFlag(this.data, this.debgattr(), 4);
    }

    public boolean debncach() {
        return Util.ConvertEquateValue(this.data, this.debgattr(), 0, 28);
    }

    public boolean debbcach() {
        return Util.ConvertEquateValue(this.data, this.debgattr(), 4, 28);
    }

    public boolean debicach() {
        return Util.ConvertEquateValue(this.data, this.debgattr(), 8, 28);
    }

    public boolean debscach() {
        return Util.ConvertEquateValue(this.data, this.debgattr(), 12, 28);
    }

    public boolean debxrflg() {
        return Util.ConvertEquateValue(this.data, this.debgattr(), 16, 28);
    }

    public boolean debrlc() {
        return Util.ConvertEquateValue(this.data, this.debgattr(), 20, 28);
    }

    public boolean debnrd() {
        return Util.ConvertFlag(this.data, this.debgattr(), 2);
    }

    public boolean debinhfw() {
        return Util.ConvertFlag(this.data, this.debgattr(), 1);
    }

    public int debblksz() {
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public long debextok() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public int debnrdid() {
        return Util.ConvertUnsignedBinary2(this.data, 44);
    }

    public int debgattx() {
        return Util.ConvertUnsignedBinary1(this.data, 47);
    }

    public boolean debrmode() {
        return Util.ConvertEquateValue(this.data, this.debgattx(), 0, 192);
    }

    public boolean debrdata() {
        return Util.ConvertEquateValue(this.data, this.debgattx(), 64, 192);
    }

    public boolean debskey() {
        return Util.ConvertEquateValue(this.data, this.debgattx(), 128, 192);
    }

    public boolean debdftr0() {
        return Util.ConvertFlag(this.data, this.debgattx(), 4);
    }

    public long debiopid() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long debblkid() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long debxcasf() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public int debxflg3() {
        return Util.ConvertUnsignedBinary1(this.data, 60);
    }

    public boolean debxtrnc() {
        return Util.ConvertFlag(this.data, this.debxflg3(), 128);
    }

    public boolean debxnseg() {
        return Util.ConvertFlag(this.data, this.debxflg3(), 64);
    }

    public boolean debxsmsg() {
        return Util.ConvertFlag(this.data, this.debxflg3(), 32);
    }

    public boolean debxduda() {
        return Util.ConvertFlag(this.data, this.debxflg3(), 16);
    }

    public boolean debxcap() {
        return Util.ConvertFlag(this.data, this.debxflg3(), 8);
    }

    public boolean debxvtoc() {
        return Util.ConvertFlag(this.data, this.debxflg3(), 4);
    }

    public boolean debxenqe() {
        return Util.ConvertFlag(this.data, this.debxflg3(), 2);
    }

    public boolean debxucnt() {
        return Util.ConvertFlag(this.data, this.debxflg3(), 1);
    }

    public int debxambf() {
        return Util.ConvertUnsignedBinary1(this.data, 61);
    }

    public boolean debxabss() {
        return Util.ConvertFlag(this.data, this.debxambf(), 128);
    }

    public boolean debxarba() {
        return Util.ConvertFlag(this.data, this.debxambf(), 64);
    }

    public boolean debxaoef() {
        return Util.ConvertFlag(this.data, this.debxambf(), 32);
    }

    public boolean debxaib() {
        return Util.ConvertFlag(this.data, this.debxambf(), 16);
    }

    public boolean debxaenccb() {
        return Util.ConvertFlag(this.data, this.debxambf(), 8);
    }

    public int debxscnt() {
        return Util.ConvertUnsignedBinary2(this.data, 62);
    }

    public long debxsacb() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public int debxaflg() {
        return Util.ConvertUnsignedBinary1(this.data, 68);
    }

    public boolean debxads() {
        return Util.ConvertFlag(this.data, this.debxaflg(), 128);
    }

    public boolean debxainp() {
        return Util.ConvertFlag(this.data, this.debxaflg(), 64);
    }

    public boolean debxaout() {
        return Util.ConvertFlag(this.data, this.debxaflg(), 32);
    }

    public boolean debxaofo() {
        return Util.ConvertFlag(this.data, this.debxaflg(), 16);
    }

    public boolean debxlgds() {
        return Util.ConvertFlag(this.data, this.debxaflg(), 8);
    }

    public boolean debxdeblockx() {
        return Util.ConvertFlag(this.data, this.debxaflg(), 4);
    }

    public boolean debxdeblock() {
        return Util.ConvertFlag(this.data, this.debxaflg(), 4);
    }

    public boolean debximg() {
        return Util.ConvertFlag(this.data, this.debxaflg(), 2);
    }

    public boolean debxexp() {
        return Util.ConvertFlag(this.data, this.debxaflg(), 1);
    }

    public int debxvlsq() {
        return Util.ConvertUnsignedBinary2(this.data, 70);
    }

    public long debxdssb() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public long debxamb() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public long debxsscb() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public long debxrdbk() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public long debxenccb() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public long debxrba() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public long debxdebx() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public static DebExtension create(byte[] Data2, int offset, int length) {
        return new DebExtension(Data2, offset, length);
    }

    static enum Field {
        debxlngh(0, 2),
        debxflg1(2, 1),
        debxflg2(3, 1),
        debxdsab(4, 4),
        debxdcbm(8, 4),
        debxdbpr(12, 4),
        debxdso1(16, 1),
        debxdso2(17, 1),
        debxmcf1(18, 1),
        debxmcf2(19, 1),
        debxxarg(20, 4),
        debxopnj(24, 4),
        debxsamb(28, 4),
        debxopet(32, 8),
        debdefg1(40, 1),
        debgattr(41, 1),
        debblksz(42, 2),
        debextok(44, 4),
        debnrdid(44, 2),
        debgattx(47, 1),
        debiopid(48, 4),
        debblkid(52, 4),
        debxcasf(56, 4),
        debxflg3(60, 1),
        debxambf(61, 1),
        debxscnt(62, 2),
        debxsacb(64, 4),
        debxaflg(68, 1),
        debxvlsq(70, 2),
        debxdssb(72, 4),
        debxamb(76, 4),
        debxsscb(76, 4),
        debxrdbk(76, 4),
        debxenccb(76, 4),
        debxrba(76, 4),
        debxdebx(80, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

