/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.internal;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;

public enum SmfTimeUnit implements TemporalUnit
{
    HUNDREDTHS("Hundredths of a second", Duration.of(10L, ChronoUnit.MILLIS)),
    MILLISECONDS16("16 Milliseconds", Duration.of(16L, ChronoUnit.MILLIS)),
    MICROSECONDS16("16 Microseconds", Duration.of(16L, ChronoUnit.MICROS)),
    MICROSECONDS128("128 Microseconds", Duration.of(128L, ChronoUnit.MICROS)),
    MICROSECONDS1024("1024 Microseconds", Duration.of(1024L, ChronoUnit.MICROS)),
    MICROSECONDS0_5("0.5 Microseconds", Duration.of(500L, ChronoUnit.NANOS)),
    MICROSECONDS2_5("2.5 Microseconds", Duration.of(2500L, ChronoUnit.NANOS)),
    CVTTZ("CVT Timezone Units", Duration.of(0x100000L, ChronoUnit.MICROS));

    private final transient String name;
    private final transient Duration duration;

    private SmfTimeUnit(String name, Duration estimatedDuration) {
        this.name = name;
        this.duration = estimatedDuration;
    }

    @Override
    public <R extends Temporal> R addTo(R arg0, long arg1) {
        return (R)arg0.plus(this.duration.multipliedBy(arg1));
    }

    @Override
    public long between(Temporal arg0, Temporal arg1) {
        return arg0.until(arg1, this);
    }

    @Override
    public Duration getDuration() {
        return this.duration;
    }

    @Override
    public boolean isDateBased() {
        return false;
    }

    @Override
    public boolean isDurationEstimated() {
        return false;
    }

    @Override
    public boolean isTimeBased() {
        return false;
    }

    @Override
    public String toString() {
        return this.name;
    }
}

