/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.internal;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.internal.Conversions;
import com.blackhillsoftware.smf.internal.ConversionsInternal;
import com.blackhillsoftware.smf.internal.ConversionsJzos;
import com.blackhillsoftware.smf.internal.CreateSection;
import com.blackhillsoftware.smf.internal.CreateSectionWithParm;
import com.blackhillsoftware.smf.internal.Ebcdic;
import com.blackhillsoftware.smf.internal.ObjectCache;
import com.blackhillsoftware.smf.internal.SmfTimeUnit;
import com.blackhillsoftware.smf.internal.ToDuration;
import com.blackhillsoftware.smf.internal.Triplet;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.IntSupplier;

public class Util {
    public static final long NANOSPERMILLI = Duration.ofMillis(1L).toNanos();
    public static final long MILLISPERSECOND = Duration.ofSeconds(1L).toMillis();
    public static final long NANOSPERMICRO = NANOSPERMILLI / 1000L;
    public static final long MICROSPERSECOND = MILLISPERSECOND * 1000L;
    public static final long NANOSPERSECOND = Duration.ofSeconds(1L).toNanos();
    private static Conversions convert;
    private static String[] singlechars;
    private static ObjectCache<Integer, String> stringCache4;
    private static ObjectCache<Long, String> stringCache8;
    private static ObjectCache<Integer, LocalDate> smfDateCache;
    static final int pivot = 70;
    private static final ZonedDateTime stckEpoch;
    private static final LocalDateTime localStckEpoch;
    private static BigInteger twelveBitMask;

    public static void UseJzos() {
        convert = new ConversionsJzos();
    }

    public static void UseInternal() {
        convert = new ConversionsInternal();
    }

    public static <T> List<T> sectionsFromTriplet(List<T> current, byte[] data, Triplet t, CreateSection<T> builder) {
        if (current != null) {
            return current;
        }
        if (t.getCount() == 0) {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>(t.getCount());
        for (int i = 0; i < t.getCount(); ++i) {
            result.add(builder.createSection(data, t.getOffset() + i * t.getLength(), t.getLength()));
        }
        return Collections.unmodifiableList(result);
    }

    public static <T> List<T> sectionsFromTriplet(List<T> current, byte[] data, IntSupplier offsetSupplier, IntSupplier lengthSupplier, IntSupplier countSupplier, CreateSection<T> builder) {
        if (current != null) {
            return current;
        }
        int count = countSupplier.getAsInt();
        if (count == 0) {
            return Collections.emptyList();
        }
        int length = lengthSupplier.getAsInt();
        int offset = offsetSupplier.getAsInt();
        ArrayList<T> result = new ArrayList<T>(count);
        for (int i = 0; i < count; ++i) {
            result.add(builder.createSection(data, offset + i * length, length));
        }
        return Collections.unmodifiableList(result);
    }

    public static <T, U> List<T> sectionsFromTriplet(List<T> current, byte[] data, IntSupplier offsetSupplier, IntSupplier lengthSupplier, IntSupplier countSupplier, CreateSectionWithParm<T, U> builder, U additionalParm) {
        if (current != null) {
            return current;
        }
        int count = countSupplier.getAsInt();
        if (count == 0) {
            return Collections.emptyList();
        }
        int length = lengthSupplier.getAsInt();
        int offset = offsetSupplier.getAsInt();
        ArrayList<T> result = new ArrayList<T>(count);
        for (int i = 0; i < count; ++i) {
            result.add(builder.createSection(data, offset + i * length, length, additionalParm));
        }
        return Collections.unmodifiableList(result);
    }

    public static <T> List<T> sectionsFrom422Triplet(List<T> current, byte[] data, int offsetPos, CreateSection<T> builder) {
        if (current != null) {
            return current;
        }
        int count = Util.ConvertUnsignedBinary2(data, offsetPos + 4);
        if (count == 0) {
            return Collections.emptyList();
        }
        int length = Util.ConvertUnsignedBinary2(data, offsetPos + 4 + 2);
        int offset = Util.ConvertSignedBinary4(data, offsetPos);
        ArrayList<T> result = new ArrayList<T>(count);
        for (int i = 0; i < count; ++i) {
            result.add(builder.createSection(data, offset + i * length, length));
        }
        return Collections.unmodifiableList(result);
    }

    public static <T> T sectionFromTriplet(T current, byte[] data, Triplet t, CreateSection<T> builder) {
        if (current != null) {
            return current;
        }
        if (t.getCount() == 0) {
            return null;
        }
        if (t.getCount() == 1) {
            return builder.createSection(data, t.getOffset(), t.getLength());
        }
        throw new IllegalArgumentException("Unexpected section count: " + Integer.toString(t.getCount()));
    }

    public static <T> T sectionFrom422Triplet(T current, byte[] data, int offsetPos, CreateSection<T> builder) {
        if (current != null) {
            return current;
        }
        int count = Util.ConvertUnsignedBinary2(data, offsetPos + 4);
        if (count == 0) {
            return null;
        }
        if (count == 1) {
            int length = Util.ConvertUnsignedBinary2(data, offsetPos + 4 + 2);
            int offset = Util.ConvertSignedBinary4(data, offsetPos);
            return builder.createSection(data, offset, length);
        }
        throw new IllegalArgumentException("Unexpected section count: " + Integer.toString(count));
    }

    public static <T> T sectionFrom42Doublet(T current, byte[] data, int offsetPos, CreateSection<T> builder) {
        if (current != null) {
            return current;
        }
        int length = Util.ConvertUnsignedBinary2(data, offsetPos + 4);
        int offset = Util.ConvertSignedBinary4(data, offsetPos);
        return builder.createSection(data, offset, length);
    }

    public static int ConvertUnsignedBits(byte[] data, int offset, int firstbit, int bits) {
        if (data.length < offset + 1) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        return convert.ConvertUnsignedBits(data, offset, firstbit, bits);
    }

    public static int ConvertUnsignedBinary1(byte[] data, int offset) {
        if (data.length < offset + 1) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        return convert.ConvertUnsignedBinary1(data, offset);
    }

    public static int ConvertUnsignedBinary1(byte[] data, int offset, int mask) {
        return Util.ConvertUnsignedBinary1(data, offset) & mask;
    }

    public static int ConvertUnsignedBinary2(byte[] data, int offset) {
        if (data.length < offset + 2) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        if (data[offset] == 0 && data[offset + 1] == 0) {
            return 0;
        }
        return convert.ConvertUnsignedBinary2(data, offset);
    }

    public static void WriteUnsignedBinary2(byte[] data, int offset, int value) {
        if (data.length < offset + 2) {
            throw new IndexOutOfBoundsException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        data[offset++] = (byte)((value & 0xFF00) >> 8);
        data[offset] = (byte)(value & 0xFF);
    }

    public static int ConvertUnsignedBinary2(byte[] data, int offset, int mask) {
        return Util.ConvertUnsignedBinary2(data, offset) & mask;
    }

    public static int ConvertUnsignedBinary3(byte[] data, int offset) {
        if (data.length < offset + 3) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        if (data[offset] == 0 && data[offset + 1] == 0 && data[offset + 2] == 0) {
            return 0;
        }
        return convert.ConvertUnsignedBinary3(data, offset);
    }

    public static int ConvertUnsignedBinary3(byte[] data, int offset, int mask) {
        return Util.ConvertUnsignedBinary3(data, offset) & mask;
    }

    public static long ConvertUnsignedBinary4(byte[] data, int offset) {
        if (data.length < offset + 4) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        if (data[offset] == 0 && data[offset + 1] == 0 && data[offset + 2] == 0 && data[offset + 3] == 0) {
            return 0L;
        }
        return convert.ConvertUnsignedBinary4(data, offset);
    }

    public static long ConvertUnsignedBinary4(byte[] data, int offset, int mask) {
        return Util.ConvertUnsignedBinary4(data, offset) & (long)mask;
    }

    public static long ConvertUnsignedBinary5(byte[] data, int offset) {
        if (data.length < offset + 5) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        if (data[offset] == 0 && data[offset + 1] == 0 && data[offset + 2] == 0 && data[offset + 3] == 0 && data[offset + 4] == 0) {
            return 0L;
        }
        return convert.ConvertUnsignedBinary5(data, offset);
    }

    public static long ConvertUnsignedBinary6(byte[] data, int offset) {
        if (data.length < offset + 6) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        if (data[offset] == 0 && data[offset + 1] == 0 && data[offset + 2] == 0 && data[offset + 3] == 0 && data[offset + 4] == 0 && data[offset + 5] == 0) {
            return 0L;
        }
        return convert.ConvertUnsignedBinary6(data, offset);
    }

    public static long ConvertUnsignedBinary7(byte[] data, int offset) {
        if (data.length < offset + 7) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        if (data[offset] == 0 && data[offset + 1] == 0 && data[offset + 2] == 0 && data[offset + 3] == 0 && data[offset + 4] == 0 && data[offset + 5] == 0 && data[offset + 6] == 0) {
            return 0L;
        }
        return convert.ConvertUnsignedBinary7(data, offset);
    }

    public static long ConvertUnsignedBinary8(byte[] data, int offset) {
        if (data.length < offset + 8) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        if (data[offset] == 0 && data[offset + 1] == 0 && data[offset + 2] == 0 && data[offset + 3] == 0 && data[offset + 4] == 0 && data[offset + 5] == 0 && data[offset + 6] == 0 && data[offset + 7] == 0) {
            return 0L;
        }
        return convert.ConvertUnsignedBinary8(data, offset);
    }

    public static long ConvertUnsignedBinary8(byte[] data, int offset, long mask) {
        return Util.ConvertUnsignedBinary8(data, offset) & mask;
    }

    public static int ConvertSignedBinary1(byte[] data, int offset) {
        if (data.length < offset + 1) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        return convert.ConvertSignedBinary1(data, offset);
    }

    public static int ConvertSignedBinary2(byte[] data, int offset) {
        if (data.length < offset + 2) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        if (data[offset] == 0 && data[offset + 1] == 0) {
            return 0;
        }
        return convert.ConvertSignedBinary2(data, offset);
    }

    public static int ConvertSignedBinary3(byte[] data, int offset) {
        if (data.length < offset + 3) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        if (data[offset] == 0 && data[offset + 1] == 0 && data[offset + 2] == 0) {
            return 0;
        }
        return convert.ConvertSignedBinary3(data, offset);
    }

    public static int ConvertSignedBinary4(byte[] data, int offset) {
        if (data.length < offset + 4) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        if (data[offset] == 0 && data[offset + 1] == 0 && data[offset + 2] == 0 && data[offset + 3] == 0) {
            return 0;
        }
        return convert.ConvertSignedBinary4(data, offset);
    }

    public static long ConvertSignedBinary5(byte[] data, int offset) {
        if (data.length < offset + 5) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        if (data[offset] == 0 && data[offset + 1] == 0 && data[offset + 2] == 0 && data[offset + 3] == 0 && data[offset + 4] == 0) {
            return 0L;
        }
        return convert.ConvertSignedBinary5(data, offset);
    }

    public static long ConvertSignedBinary6(byte[] data, int offset) {
        if (data.length < offset + 6) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        if (data[offset] == 0 && data[offset + 1] == 0 && data[offset + 2] == 0 && data[offset + 3] == 0 && data[offset + 4] == 0 && data[offset + 5] == 0) {
            return 0L;
        }
        return convert.ConvertSignedBinary6(data, offset);
    }

    public static long ConvertSignedBinary7(byte[] data, int offset) {
        if (data.length < offset + 7) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        if (data[offset] == 0 && data[offset + 1] == 0 && data[offset + 2] == 0 && data[offset + 3] == 0 && data[offset + 4] == 0 && data[offset + 5] == 0 && data[offset + 6] == 0) {
            return 0L;
        }
        return convert.ConvertSignedBinary7(data, offset);
    }

    public static long ConvertSignedBinary8(byte[] data, int offset) {
        if (data.length < offset + 8) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        if (data[offset] == 0 && data[offset + 1] == 0 && data[offset + 2] == 0 && data[offset + 3] == 0 && data[offset + 4] == 0 && data[offset + 5] == 0 && data[offset + 6] == 0 && data[offset + 7] == 0) {
            return 0L;
        }
        return convert.ConvertSignedBinary8(data, offset);
    }

    public static int ConvertPacked1(byte[] data, int offset) {
        if (data.length < offset + 1) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        if (data[offset] == 0) {
            return 0;
        }
        return convert.ConvertPacked1(data, offset);
    }

    public static int ConvertPacked2(byte[] data, int offset) {
        if (data.length < offset + 2) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        if (Util.ConvertUnsignedBinary2(data, offset) == 0) {
            return 0;
        }
        return convert.ConvertPacked2(data, offset);
    }

    public static int ConvertPacked3(byte[] data, int offset) {
        if (data.length < offset + 3) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        if (Util.ConvertUnsignedBinary3(data, offset) == 0) {
            return 0;
        }
        return convert.ConvertPacked3(data, offset);
    }

    public static int ConvertPacked4(byte[] data, int offset) {
        if (Util.ConvertUnsignedBinary4(data, offset) == 0L) {
            return 0;
        }
        return convert.ConvertPacked4(data, offset);
    }

    public static long ConvertPackedNoSign(byte[] data, int offset, int length) {
        if (data.length < offset + length) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        return convert.ConvertPackedNoSign(data, offset, length);
    }

    public static long ConvertPackedLong(byte[] data, int offset, int length) {
        return convert.ConvertPackedLong(data, offset, length);
    }

    public static BigInteger ConvertPackedBigInteger(byte[] data, int offset, int length) {
        return convert.ConvertPackedBigInteger(data, offset, length);
    }

    public static double ConvertLongFPHex(byte[] data, int offset) {
        if (data.length < offset + 8) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        return convert.ConvertDouble(data, offset);
    }

    public static float ConvertShortFPHex(byte[] data, int offset) {
        if (data.length < offset + 4) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        return convert.ConvertFloat(data, offset);
    }

    public static String ConvertEbcdic(byte[] data, int offset, int length) {
        switch (length) {
            case 1: {
                if (data.length < offset + length) {
                    throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
                }
                int value = Byte.toUnsignedInt(data[offset]);
                if (value == 0 || value == 64) {
                    return "";
                }
                return singlechars[value];
            }
            case 4: {
                int key = Util.ConvertSignedBinary4(data, offset);
                String result = stringCache4.tryGet(key);
                if (result == null) {
                    result = Util.buildString(data, offset, length);
                    stringCache4.put(key, result);
                }
                return result;
            }
            case 8: {
                long key = Util.ConvertSignedBinary8(data, offset);
                String result = stringCache8.tryGet(key);
                if (result == null) {
                    result = Util.buildString(data, offset, length);
                    stringCache8.put(key, result);
                }
                return result;
            }
        }
        if (data.length < offset + length) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        return Util.buildString(data, offset, length);
    }

    private static String buildString(byte[] data, int offset, int length) {
        char[] output = new char[length];
        for (int i = 0; i < length; ++i) {
            output[i] = Ebcdic.characters[Byte.toUnsignedInt(data[offset + i])];
        }
        while (length > 0 && output[length - 1] == ' ') {
            --length;
        }
        if (length == 0) {
            return "";
        }
        return new String(output, 0, length);
    }

    public static String ConvertEbcdicOrUtf8(byte[] data, int offset, int length, boolean utf8) {
        if (data.length < offset + length) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        if (!utf8) {
            return Util.ConvertEbcdic(data, offset, length);
        }
        return new String(data, offset, length, StandardCharsets.UTF_8);
    }

    public static String ConvertUtf8(byte[] data, int offset, int length) {
        if (data.length < offset + length) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        return new String(data, offset, length, StandardCharsets.UTF_8);
    }

    public static String ConvertEbcdicOrUtf8Variable(byte[] data, int offset, int length, boolean utf8) {
        if (data.length < offset + length) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        if (!utf8) {
            return Util.ConvertEbcdic(data, offset, length);
        }
        return new String(data, offset, length, StandardCharsets.UTF_8);
    }

    public static LocalDate SMFDate(byte[] data, int offset) {
        int key = Util.ConvertSignedBinary4(data, offset);
        LocalDate result = smfDateCache.tryGet(key);
        if (result == null) {
            int p = Util.ConvertPacked4(data, offset);
            if (p == 0) {
                return null;
            }
            int year = p / 1000 + 1900;
            int day = p % 1000;
            LocalDate d = LocalDate.of(year, 1, 1);
            result = d.plusDays(day - 1);
            smfDateCache.put(key, result);
        }
        return result;
    }

    public static LocalDate Binary3_YYDDDD_Date(byte[] data, int offset) {
        int p = Util.ConvertUnsignedBinary3(data, offset);
        if (p == 0) {
            return null;
        }
        int year = (p >> 16) + 1900;
        int day = p & 0xFFFF;
        LocalDate d = LocalDate.of(year, 1, 1);
        return d.plusDays(day - 1);
    }

    public static LocalTime Binary4x100STime(byte[] data, int offset) {
        long l = Util.ConvertUnsignedBinary4(data, offset);
        return LocalTime.MIDNIGHT.plus(Duration.of(l, SmfTimeUnit.HUNDREDTHS));
    }

    public static LocalTime Binary4SecondsTime(byte[] data, int offset) {
        long l = Util.ConvertUnsignedBinary4(data, offset);
        return LocalTime.MIDNIGHT.plusSeconds(l);
    }

    public static LocalTime Binary6UsSinceMidnight(byte[] data, int offset) {
        long l = Util.ConvertUnsignedBinary6(data, offset);
        return LocalTime.MIDNIGHT.plusNanos(l * 1000L);
    }

    public static LocalTime EBCDIC6hhmmss(byte[] data, int offset) {
        String s = Util.ConvertEbcdic(data, offset, 6);
        if (s.length() == 0) {
            return null;
        }
        int hh = Integer.parseInt(s.substring(0, 2));
        int mm = Integer.parseInt(s.substring(2, 4));
        int ss = Integer.parseInt(s.substring(4, 6));
        return LocalTime.of(hh, mm, ss);
    }

    public static LocalTime EBCDIC8hh_mm_ss(byte[] data, int offset) {
        String s = Util.ConvertEbcdic(data, offset, 8);
        if (s.length() == 0) {
            return null;
        }
        int hh = Integer.parseInt(s.substring(0, 2));
        int mm = Integer.parseInt(s.substring(3, 5));
        int ss = Integer.parseInt(s.substring(6, 8));
        return LocalTime.of(hh, mm, ss);
    }

    public static LocalDate EBCDIC8mmddyyyy(byte[] data, int offset) {
        String s = Util.ConvertEbcdic(data, offset, 8);
        if (s.length() == 0) {
            return null;
        }
        int mm = Integer.parseInt(s.substring(0, 2));
        int dd = Integer.parseInt(s.substring(2, 4));
        int yyyy = Integer.parseInt(s.substring(4, 8));
        return LocalDate.of(yyyy, mm, dd);
    }

    public static LocalDate EBCDIC10mm_dd_yyyy(byte[] data, int offset) {
        String s = Util.ConvertEbcdic(data, offset, 10);
        if (s.length() == 0) {
            return null;
        }
        int mm = Integer.parseInt(s.substring(0, 2));
        int dd = Integer.parseInt(s.substring(3, 5));
        int yyyy = Integer.parseInt(s.substring(6, 10));
        return LocalDate.of(yyyy, mm, dd);
    }

    public static LocalDate Dcollect_SMS_Date_10(byte[] data, int offset) {
        String s = Util.ConvertEbcdic(data, offset, 10);
        if (s.length() == 0) {
            return null;
        }
        int yyyy = Integer.parseInt(s.substring(0, 4));
        int mm = Integer.parseInt(s.substring(5, 7));
        int dd = Integer.parseInt(s.substring(8, 10));
        return LocalDate.of(yyyy, mm, dd);
    }

    public static LocalTime Dcollect_SMS_Time_8(byte[] data, int offset) {
        String s = Util.ConvertEbcdic(data, offset, 8);
        if (s.length() == 0) {
            return null;
        }
        int hh = Integer.parseInt(s.substring(0, 2));
        int mm = Integer.parseInt(s.substring(3, 5));
        int ss = 0;
        if (s.length() > 5) {
            ss = Integer.parseInt(s.substring(6, 8));
        }
        return LocalTime.of(hh, mm, ss);
    }

    public static LocalDate EBCDIC8mm_dd_yy(byte[] data, int offset) {
        String s = Util.ConvertEbcdic(data, offset, 8);
        if (s.length() == 0) {
            return null;
        }
        int mm = Integer.parseInt(s.substring(0, 2));
        int dd = Integer.parseInt(s.substring(3, 5));
        int yy = Integer.parseInt(s.substring(6, 8));
        yy = yy < 70 ? (yy += 2000) : (yy += 1900);
        return LocalDate.of(yy, mm, dd);
    }

    public static ZonedDateTime YYMMDDhhmmssZ(byte[] data, int offset) {
        String s = Util.ConvertEbcdic(data, offset, 12);
        if (s.length() == 0) {
            return null;
        }
        int YY = Integer.parseInt(s.substring(0, 2));
        int MM = Integer.parseInt(s.substring(2, 4));
        int DD2 = Integer.parseInt(s.substring(4, 6));
        int hh = Integer.parseInt(s.substring(6, 8));
        int mm = Integer.parseInt(s.substring(8, 10));
        int ss = Integer.parseInt(s.substring(10, 12));
        YY = YY < 70 ? (YY += 2000) : (YY += 1900);
        return ZonedDateTime.of(YY, MM, DD2, hh, mm, ss, 0, ZoneOffset.UTC);
    }

    public static ZonedDateTime YYYYMMDDhhmmssZ(byte[] data, int offset) {
        String s = Util.ConvertEbcdic(data, offset, 14);
        if (s.length() == 0) {
            return null;
        }
        int YYYY = Integer.parseInt(s.substring(0, 4));
        int MM = Integer.parseInt(s.substring(4, 6));
        int DD2 = Integer.parseInt(s.substring(6, 8));
        int hh = Integer.parseInt(s.substring(8, 10));
        int mm = Integer.parseInt(s.substring(10, 12));
        int ss = Integer.parseInt(s.substring(12, 14));
        return ZonedDateTime.of(YYYY, MM, DD2, hh, mm, ss, 0, ZoneOffset.UTC);
    }

    public static LocalDate Packed4YYYYDDD(byte[] data, int offset) {
        int value = Util.ConvertPacked4(data, offset);
        if (value == 0) {
            return null;
        }
        int yyyy = value / 1000;
        int ddd = value % 1000;
        return LocalDate.of(yyyy, 1, 1).plusDays(ddd - 1);
    }

    public static LocalDateTime Binary8_yyddhmsh(byte[] data, int offset) {
        int yy = Util.ConvertUnsignedBinary2(data, offset);
        int dd = Util.ConvertUnsignedBinary2(data, offset + 2);
        int ssss = Util.ConvertSignedBinary4(data, offset + 4);
        if (yy == 0 && dd == 0 && ssss == 0) {
            return null;
        }
        return LocalDate.of(1900 + yy, 1, 1).plusDays(dd - 1).atTime(LocalTime.of(0, 0, 0).plusSeconds(ssss));
    }

    public static LocalTime Binary4hhmmssth(byte[] data, int offset) {
        int hh = (int)Util.ConvertPackedNoSign(data, offset, 1);
        int mm = (int)Util.ConvertPackedNoSign(data, offset + 1, 1);
        int ss = (int)Util.ConvertPackedNoSign(data, offset + 2, 1);
        int th = (int)Util.ConvertPackedNoSign(data, offset + 3, 1);
        return LocalTime.of(hh, mm, ss).plus(th, SmfTimeUnit.HUNDREDTHS);
    }

    public static Duration EBCDIC4hhmm(byte[] data, int offset) {
        String s = Util.ConvertEbcdic(data, offset, 4);
        if (s.length() == 0) {
            return null;
        }
        int hh = Integer.parseInt(s.substring(0, 2));
        int mm = Integer.parseInt(s.substring(2, 4));
        return Duration.ofHours(hh).plusMinutes(mm);
    }

    public static Duration EBCDIC4mmss(byte[] data, int offset) {
        String s = Util.ConvertEbcdic(data, offset, 4);
        if (s.length() == 0) {
            return null;
        }
        int mm = Integer.parseInt(s.substring(0, 2));
        int ss = Integer.parseInt(s.substring(2, 4));
        return Duration.ofMinutes(mm).plusSeconds(ss);
    }

    public static Duration Binary4x100S(byte[] data, int offset) {
        return ToDuration.from100thsOfSecond(Util.ConvertUnsignedBinary4(data, offset));
    }

    public static Duration Binary2x100S(byte[] data, int offset) {
        return ToDuration.from100thsOfSecond(Util.ConvertUnsignedBinary2(data, offset));
    }

    public static Duration Binary2Minutes(byte[] data, int offset) {
        return ToDuration.fromMinutes(Util.ConvertUnsignedBinary2(data, offset));
    }

    public static Duration Binary4_Seconds(byte[] data, int offset) {
        return Duration.ofSeconds(Util.ConvertUnsignedBinary4(data, offset));
    }

    public static Duration Binary4_16_US(byte[] data, int offset) {
        return ToDuration.from16MicroSeconds(Util.ConvertUnsignedBinary4(data, offset));
    }

    public static Duration Binary8USSeconds(byte[] data, int offset) {
        return ToDuration.fromMicroSeconds(Util.ConvertUnsignedBinary8(data, offset));
    }

    public static Duration LongFpHex_1024_US(byte[] data, int offset) {
        return ToDuration.from1024MicroSeconds((long)Util.ConvertLongFPHex(data, offset));
    }

    public static Duration LongFpHex_US(byte[] data, int offset) {
        return ToDuration.fromMicroSeconds((long)Util.ConvertLongFPHex(data, offset));
    }

    public static Duration LongFpHex_16MS(byte[] data, int offset) {
        return ToDuration.from16MilliSeconds((long)Util.ConvertLongFPHex(data, offset));
    }

    public static Duration LongFpHex_MS(byte[] data, int offset) {
        return ToDuration.fromMilliSeconds((long)Util.ConvertLongFPHex(data, offset));
    }

    public static Duration LongFpHex_0_5_US(byte[] data, int offset) {
        return ToDuration.from0_5MicroSeconds((long)Util.ConvertLongFPHex(data, offset));
    }

    public static Duration LongFpHex_2_5_US(byte[] data, int offset) {
        return ToDuration.from2_5MicroSeconds((long)Util.ConvertLongFPHex(data, offset));
    }

    public static Duration LongFpHex_128_US(byte[] data, int offset) {
        return ToDuration.from128MicroSeconds((long)Util.ConvertLongFPHex(data, offset));
    }

    public static Duration ShortFpHex_MS(byte[] data, int offset) {
        return ToDuration.fromMilliSeconds((long)Util.ConvertShortFPHex(data, offset));
    }

    public static Duration ShortFpHex_US(byte[] data, int offset) {
        return ToDuration.fromMicroSeconds((long)Util.ConvertShortFPHex(data, offset));
    }

    public static Duration ShortFpHex_16_MS(byte[] data, int offset) {
        return ToDuration.from16MilliSeconds((long)Util.ConvertShortFPHex(data, offset));
    }

    public static Duration Binary4x1024MS(byte[] data, int offset) {
        return ToDuration.from1024MicroSeconds(Util.ConvertUnsignedBinary4(data, offset));
    }

    public static Duration Binary4US(byte[] data, int offset) {
        return ToDuration.fromMicroSeconds(Util.ConvertUnsignedBinary4(data, offset));
    }

    public static Duration Binary4MS(byte[] data, int offset) {
        return ToDuration.fromMilliSeconds(Util.ConvertUnsignedBinary4(data, offset));
    }

    public static Duration Binary4Minutes(byte[] data, int offset) {
        return ToDuration.fromMinutes(Util.ConvertUnsignedBinary4(data, offset));
    }

    public static Duration Binary8MSSeconds(byte[] data, int offset) {
        return ToDuration.fromMilliSeconds(Util.ConvertUnsignedBinary8(data, offset));
    }

    public static Duration Binary4_10MS(byte[] data, int offset) {
        return ToDuration.from10MilliSeconds(Util.ConvertUnsignedBinary4(data, offset));
    }

    public static Duration ConvertBinary2MS(byte[] data, int offset) {
        return ToDuration.fromMilliSeconds(Util.ConvertUnsignedBinary2(data, offset));
    }

    public static Duration Binary4x128US(byte[] data, int offset) {
        return ToDuration.from128MicroSeconds(Util.ConvertUnsignedBinary4(data, offset));
    }

    public static Duration Binary8x128US(byte[] data, int offset) {
        return ToDuration.from128MicroSeconds(Util.ConvertUnsignedBinary8(data, offset));
    }

    public static Duration Binary2Seconds(byte[] data, int offset) {
        return Duration.ofSeconds(Util.ConvertUnsignedBinary2(data, offset));
    }

    public static Duration SignedBinary2Seconds(byte[] data, int offset) {
        return Duration.ofSeconds(Util.ConvertSignedBinary2(data, offset));
    }

    public static LocalTime Packed_HHMMSS(byte[] data, int offset) {
        int time = Util.ConvertPacked4(data, offset);
        int ss = time % 100;
        int mm = time / 100 % 100;
        int hh = time / 10000;
        return LocalTime.of(hh, mm, ss);
    }

    public static Duration Packed_MMSSTTT(byte[] data, int offset) {
        int time = Util.ConvertPacked4(data, offset);
        int ttt = time % 1000;
        int ss = time / 1000 % 100;
        int mm = time / 100000;
        return Duration.ofMinutes(mm).plusSeconds(ss).plusMillis(ttt);
    }

    public static ZonedDateTime Binary8xStckTime(byte[] data, int offset) {
        long l = Util.ConvertSignedBinary8(data, offset);
        if (l == 0L) {
            return null;
        }
        return stckEpoch.plus(Util.stckDuration(l));
    }

    private static Duration stckDuration(long stck) {
        long microseconds = stck >>> 12;
        long remainder = stck & 0xFFFL;
        Duration d = Duration.of(microseconds, ChronoUnit.MICROS);
        Duration dn = Duration.ofNanos(remainder * 1000L / 4096L);
        d = d.plus(dn);
        return d;
    }

    public static ZonedDateTime Binary4HiStckTime(byte[] data, int offset) {
        long value = Util.ConvertUnsignedBinary4(data, offset);
        if (value == 0L) {
            return null;
        }
        return stckEpoch.plus(Util.stckDuration(value <<= 32));
    }

    public static LocalDateTime Binary8xStckLocalTime(byte[] data, int offset) {
        long value = Util.ConvertSignedBinary8(data, offset);
        if (value == 0L) {
            return null;
        }
        return localStckEpoch.plus(Util.stckDuration(value));
    }

    public static Duration Binary8StckInterval(byte[] data, int offset) {
        long value = Util.ConvertSignedBinary8(data, offset);
        if (value == 0L) {
            return Duration.ZERO;
        }
        return ToDuration.fromStckInterval(value);
    }

    public static ZoneOffset Binary8_STCK_GMT_Offset(byte[] data, int offset) {
        Duration d = Util.Binary8StckInterval(data, offset);
        double millis = d.toMillis();
        double seconds = millis / (double)MILLISPERSECOND;
        long rounded = Math.round(seconds);
        return ZoneOffset.ofTotalSeconds((int)rounded);
    }

    public static Duration Binary16StckeInterval(byte[] data, int offset) {
        if (data.length < offset + 16) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        boolean positive = true;
        BigInteger stcke = convert.ConvertSignedBigInteger(data, offset, 16);
        if (stcke.signum() == -1) {
            positive = false;
            stcke = stcke.negate();
        }
        long microseconds = stcke.shiftRight(68).longValueExact();
        long remainder = stcke.shiftRight(56).and(twelveBitMask).longValueExact();
        Duration d = Duration.of(microseconds, ChronoUnit.MICROS);
        Duration dn = Duration.ofNanos(remainder * 1000L / 4096L);
        d = d.plus(dn);
        return positive ? d : d.negated();
    }

    public static ZonedDateTime Binary16StckeTime(byte[] data, int offset) {
        Duration value = Util.Binary16StckeInterval(data, offset);
        if (value.equals(Duration.ZERO)) {
            return null;
        }
        return stckEpoch.plus(value);
    }

    public static ZonedDateTime Binary8HiStckeTime(byte[] data, int offset) {
        if (data.length < offset + 8) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        byte[] temp = new byte[16];
        System.arraycopy(data, offset, temp, 0, 8);
        Duration value = Util.Binary16StckeInterval(temp, 0);
        if (value.equals(Duration.ZERO)) {
            return null;
        }
        return stckEpoch.plus(value);
    }

    public static ZonedDateTime Binary6HiStckeTime(byte[] data, int offset) {
        if (data.length < offset + 6) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        byte[] temp = new byte[16];
        System.arraycopy(data, offset, temp, 0, 6);
        Duration value = Util.Binary16StckeInterval(temp, 0);
        if (value.equals(Duration.ZERO)) {
            return null;
        }
        return stckEpoch.plus(value);
    }

    public static LocalDateTime Binary16StckeLocalTime(byte[] data, int offset) {
        Duration value = Util.Binary16StckeInterval(data, offset);
        if (value.equals(Duration.ZERO)) {
            return null;
        }
        return localStckEpoch.plus(value);
    }

    public static ZoneOffset Binary16_STCKE_GMT_Offset(byte[] data, int offset) {
        Duration d = Util.Binary16StckeInterval(data, offset);
        double millis = d.toMillis();
        double seconds = millis / (double)MILLISPERSECOND;
        long rounded = Math.round(seconds);
        return ZoneOffset.ofTotalSeconds((int)rounded);
    }

    public static ZoneOffset Binary4_CVTTZ(byte[] data, int offset) {
        long value = Util.ConvertSignedBinary4(data, offset);
        Duration d = Duration.of(value, SmfTimeUnit.CVTTZ);
        double millis = d.toMillis();
        double seconds = millis / (double)MILLISPERSECOND;
        double rounded = Math.ceil(seconds);
        return ZoneOffset.ofTotalSeconds((int)rounded);
    }

    public static ZonedDateTime Db2TimeStamp(byte[] data, int offset) {
        long date = Util.ConvertPackedNoSign(data, offset, 4);
        long time = Util.ConvertPackedNoSign(data, offset + 4, 6);
        if (date == 0L && time == 0L) {
            return null;
        }
        long yyyypos = 10000L;
        long mmpos = 100L;
        long hhpos = 10000000000L;
        long minpos = 100000000L;
        long secpos = 1000000L;
        int yyyy = (int)(date / yyyypos);
        int mm = (int)((date -= (long)yyyy * yyyypos) / mmpos);
        int dd = (int)(date -= (long)mm * mmpos);
        int hh = (int)(time / hhpos);
        int min = (int)((time -= (long)hh * hhpos) / minpos);
        int sec = (int)((time -= (long)min * minpos) / secpos);
        int micros = (int)(time -= (long)sec * secpos);
        return ZonedDateTime.of(yyyy, mm, dd, hh, min, sec, micros * 1000, ZoneOffset.UTC);
    }

    public static BigInteger ConvertUnsignedBinary8BigInteger(byte[] data, int offset) {
        if (data.length < offset + 8) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        return convert.ConvertUnsignedBinary8BigInteger(data, offset);
    }

    public static BigInteger ConvertUnsignedBinary4BigInteger(byte[] data, int offset) {
        if (data.length < offset + 4) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        return convert.ConvertUnsignedBinary4BigInteger(data, offset);
    }

    public static BigInteger ConvertUnsignedBinary2BigInteger(byte[] data, int offset) {
        if (data.length < offset + 2) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        return convert.ConvertUnsignedBinary2BigInteger(data, offset);
    }

    public static InetAddress ConvertInetV4Address(byte[] data, int offset) {
        InetAddress result;
        if (data.length < offset + 4) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        byte[] work = new byte[4];
        System.arraycopy(data, offset, work, 0, 4);
        try {
            result = InetAddress.getByAddress(work);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static InetAddress ConvertInetV6Address(byte[] data, int offset) {
        InetAddress result;
        if (data.length < offset + 16) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        byte[] work = new byte[16];
        System.arraycopy(data, offset, work, 0, 16);
        try {
            result = InetAddress.getByAddress(work);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static InetAddress ConvertInetTextAddress(byte[] data, int offset, int length) throws UnknownHostException {
        if (data.length < offset + length) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        String text = Util.ConvertEbcdic(data, offset, length);
        InetAddress result = InetAddress.getByName(text);
        return result;
    }

    public static BigInteger ConvertBigInteger(byte[] data, int offset, int length) {
        if (data.length < offset + length) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        return convert.ConvertBigInteger(data, offset, length);
    }

    public static BigInteger ConvertSignedBigInteger(byte[] data, int offset, int length) {
        if (data.length < offset + length) {
            throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(offset) + " Data length: " + Integer.toString(data.length));
        }
        return convert.ConvertSignedBigInteger(data, offset, length);
    }

    public static Duration LongFpHex_x100S(byte[] data, int offset) {
        return ToDuration.from100thsOfSecond((long)Util.ConvertLongFPHex(data, offset));
    }

    public static Duration LongFPHex_SecondsScaled(byte[] data, int offset, double scale) {
        return ToDuration.fromSeconds(Util.ConvertLongFPHex(data, offset) * scale);
    }

    public static Duration ShortFpHex_10_MS(byte[] data, int offset) {
        return ToDuration.from10MilliSeconds((long)Util.ConvertShortFPHex(data, offset));
    }

    public static Duration ShortFpHex_128_US(byte[] data, int offset) {
        return ToDuration.from128MicroSeconds((long)Util.ConvertShortFPHex(data, offset));
    }

    public static Duration Binary8CPUTimer(byte[] data, int offset) {
        return ToDuration.fromCpuTimer(Util.ConvertUnsignedBinary8(data, offset));
    }

    public static ZonedDateTime Binary8MillisSinceEpochTime(byte[] data, int offset) {
        long l = Util.ConvertSignedBinary8(data, offset);
        if (l == 0L) {
            return null;
        }
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(l), ZoneOffset.UTC);
    }

    public static ZonedDateTime Binary8MicrosSinceEpochTime(byte[] data, int offset) {
        long l = Util.ConvertSignedBinary8(data, offset);
        if (l == 0L) {
            return null;
        }
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(l / 1000L), ZoneOffset.UTC).plus(l % 1000L, ChronoUnit.MICROS);
    }

    public static Duration Binary8NanoSeconds(byte[] data, int offset) {
        return Duration.ofNanos(Util.ConvertSignedBinary8(data, offset));
    }

    public static boolean ConvertFlag(byte[] data, int field, int value) {
        if (value == 0) {
            return false;
        }
        return (field & value) == value;
    }

    public static boolean ConvertFlag(byte[] data, long field, long value) {
        if (value == 0L) {
            return false;
        }
        return (field & value) == value;
    }

    public static boolean ConvertFlag(byte[] data, int field, int value, int flagfieldlength, int flagoffset) {
        if (value == 0) {
            return false;
        }
        assert ((value & 0xFFFFFF00) == 0);
        int shift = (flagfieldlength - 1 - flagoffset) * 8;
        return ((field >>= shift) & value) == value;
    }

    public static boolean ConvertFlag(byte[] data, long field, int value, int flagfieldlength, int flagoffset) {
        if (value == 0) {
            return false;
        }
        assert ((value & 0xFFFFFF00) == 0);
        int shift = (flagfieldlength - 1 - flagoffset) * 8;
        return ((field >>= shift) & (long)value) == (long)value;
    }

    public static boolean ConvertEquateValue(byte[] data, int field, int value) {
        return field == value;
    }

    public static boolean ConvertEquateValue(byte[] data, int field, int value, int mask) {
        return (field & mask) == value;
    }

    public static boolean ConvertEquateValue(byte[] data, long field, long value) {
        return field == value;
    }

    public static boolean ConvertEquateValue(byte[] data, long field, long value, long mask) {
        return (field & mask) == value;
    }

    public static boolean ConvertEquateValue(byte[] data, int field, int value, int flagfieldlength, int flagoffset) {
        assert ((value & 0xFFFFFF00) == 0);
        int shift = (flagfieldlength - 1 - flagoffset) * 8;
        field >>= shift;
        return (field &= 0xFF) == value;
    }

    public static boolean ConvertEquateValue(byte[] data, long field, int value, int flagfieldlength, int flagoffset) {
        assert ((value & 0xFFFFFF00) == 0);
        int shift = (flagfieldlength - 1 - flagoffset) * 8;
        field >>= shift;
        return (field &= 0xFFL) == (long)value;
    }

    public static boolean ConvertEquateValue(byte[] data, int field, int value, int flagfieldlength, int flagoffset, int mask) {
        assert ((value & 0xFFFFFF00) == 0);
        assert ((mask & 0xFFFFFF00) == 0);
        int shift = (flagfieldlength - 1 - flagoffset) * 8;
        field >>= shift;
        return (field &= mask) == value;
    }

    public static boolean ConvertEquateValue(byte[] data, long field, int value, int flagfieldlength, int flagoffset, int mask) {
        assert ((value & 0xFFFFFF00) == 0);
        assert ((mask & 0xFFFFFF00) == 0);
        int shift = (flagfieldlength - 1 - flagoffset) * 8;
        field >>= shift;
        return (field &= (long)mask) == (long)value;
    }

    public static double Binary8USSquared(byte[] data, int offset) {
        double perSecond = 1000000.0;
        double value = Util.ConvertUnsignedBinary8(data, offset);
        double seconds = value / (perSecond * perSecond);
        return seconds;
    }

    public static double Binary16MSSquared(byte[] data, int offset) {
        double perSecond = 1000.0;
        double value = Util.ConvertBigInteger(data, offset, 16).doubleValue();
        double seconds = value / (perSecond * perSecond);
        return seconds;
    }

    public static double Binary16USSquared(byte[] data, int offset) {
        double perSecond = 1000000.0;
        double value = Util.ConvertBigInteger(data, offset, 16).doubleValue();
        double seconds = value / (perSecond * perSecond);
        return seconds;
    }

    public static double LongFpHex_1024_US_Squared(byte[] data, int offset) {
        double perSecond = 976.0;
        double value = Util.ConvertLongFPHex(data, offset);
        double seconds = value / (perSecond * perSecond);
        return seconds;
    }

    public static double LongFpHex_US_Squared(byte[] data, int offset) {
        double perSecond = 1000000.0;
        double value = Util.ConvertLongFPHex(data, offset);
        double seconds = value / (perSecond * perSecond);
        return seconds;
    }

    public static double ToSeconds(Duration d) {
        double nanos = d.toNanos();
        return nanos / 1.0E9;
    }

    static {
        try {
            Class.forName("com.ibm.jzos.fields.BinaryAsIntField");
            convert = new ConversionsJzos();
        }
        catch (ClassNotFoundException e) {
            convert = new ConversionsInternal();
        }
        singlechars = new String[256];
        for (int i = 0; i < 256; ++i) {
            Util.singlechars[i] = new String(Ebcdic.characters, i, 1);
        }
        stringCache4 = new ObjectCache();
        stringCache8 = new ObjectCache();
        smfDateCache = new ObjectCache();
        stckEpoch = ZonedDateTime.of(1900, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
        localStckEpoch = LocalDateTime.of(1900, 1, 1, 0, 0, 0);
        twelveBitMask = BigInteger.valueOf(4095L);
    }
}

