/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf10;

import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf10.Device;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;

public final class Smf10Record
extends SmfRecord {
    public static final int SMFRCD10 = 0;

    public Smf10Record(byte[] data) {
        super(data);
        if (this.recordType() != 10) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public Smf10Record(SmfRecord record) {
        super(record);
        if (this.recordType() != 10) {
            throw new IllegalArgumentException("Incorrect record type - record is record type " + Integer.toString(this.recordType()));
        }
    }

    public static Smf10Record from(SmfRecord record) {
        return new Smf10Record(record);
    }

    public static Smf10Record from(byte[] data) {
        return new Smf10Record(data);
    }

    List<Device> Devices() {
        ArrayList<Device> result = new ArrayList<Device>();
        for (int i = 0; i < (this.smf10ln() - 2) / 4; ++i) {
            result.add(Device.create(this.data, Field.smf10ln.offset() + 2 + i * 4, 4));
        }
        return result;
    }

    public int smf10len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int smf10seg() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smf10flg() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf10rty() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public LocalTime smf10tme() {
        return Util.Binary4x100STime(this.data, 6);
    }

    public long smf10tmeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 6);
    }

    public LocalDate smf10dte() {
        return Util.SMFDate(this.data, 10);
    }

    public int smf10dteRawValue() {
        return Util.ConvertPacked4(this.data, 10);
    }

    public String smf10sid() {
        return Util.ConvertEbcdic(this.data, 14, 4);
    }

    public String smf10jbn() {
        return Util.ConvertEbcdic(this.data, 18, 8);
    }

    public LocalTime smf10rst() {
        return Util.Binary4x100STime(this.data, 26);
    }

    public long smf10rstRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 26);
    }

    public LocalDate smf10rsd() {
        return Util.SMFDate(this.data, 30);
    }

    public int smf10rsdRawValue() {
        return Util.ConvertPacked4(this.data, 30);
    }

    public String smf10uif() {
        return Util.ConvertEbcdic(this.data, 34, 8);
    }

    public int smf10ln() {
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    static enum Field {
        smf10len(0, 2),
        smf10seg(2, 2),
        smf10flg(4, 1),
        smf10rty(5, 1),
        smf10tme(6, 4),
        smf10dte(10, 4),
        smf10sid(14, 4),
        smf10jbn(18, 8),
        smf10rst(26, 4),
        smf10rsd(30, 4),
        smf10uif(34, 8),
        smf10ln(42, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

