/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf119;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf119.values.ConnectionTerminationCode;
import com.blackhillsoftware.smf.smf119.values.SmcReason;
import com.blackhillsoftware.smf.smf119.values.SmcStatus;
import com.blackhillsoftware.smf.smf119.values.SocketStatus;
import com.blackhillsoftware.smf.smf119.values.TLSConnectionStatus;
import com.blackhillsoftware.smf.smf119.values.TLSPolicyStatus;
import java.math.BigInteger;
import java.net.InetAddress;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;

public final class ConnectionTermination
extends SmfData {
    public static final int SMF119AP_TTSMCRSNRMT = 128;
    public static final int SMF119AP_TTSMCCached = 64;
    public static final int SMF119AP_TTSMCDRSNRMT = 32;
    public static final int SMF119AP_TTSMCDCACHED = 16;
    public static final int SMF119AP_TTSMCVersion_1 = 16;
    public static final int SMF119AP_TTSMCVersion_2 = 32;
    public static final int SMF119AP_TTIPsecurityEnbl = 128;
    public static final int SMF119AP_TTIPv6securityEnbl = 64;
    public static final int SMF119AP_TTIPFltrIncl = 32;

    private ConnectionTermination(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smf119apTtRname() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public long smf119apTtConnId() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public TLSConnectionStatus smf119apTtTlsCs() {
        int value = Util.ConvertUnsignedBinary1(this.data, 12);
        return TLSConnectionStatus.from(value);
    }

    public int smf119apTtTlsCsRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 12);
    }

    public TLSPolicyStatus smf119apTtTlsPs() {
        int value = Util.ConvertUnsignedBinary1(this.data, 13);
        return TLSPolicyStatus.from(value);
    }

    public int smf119apTtTlsPsRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 13);
    }

    public ConnectionTerminationCode smf119apTtTermCode() {
        int value = Util.ConvertUnsignedBinary1(this.data, 14);
        return ConnectionTerminationCode.from(value);
    }

    public int smf119apTtTermCodeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 14);
    }

    public SmcStatus smf119apTtSmcStatus() {
        int value = Util.ConvertUnsignedBinary1(this.data, 15);
        return SmcStatus.from(value);
    }

    public int smf119apTtSmcStatusRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 15);
    }

    public long smf119apTtSubtask() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public LocalTime smf119apTtStime() {
        return Util.Binary4x100STime(this.data, 20);
    }

    public long smf119apTtStimeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public LocalDate smf119apTtSdate() {
        return Util.SMFDate(this.data, 24);
    }

    public int smf119apTtSdateRawValue() {
        return Util.ConvertPacked4(this.data, 24);
    }

    public LocalTime smf119apTtEtime() {
        return Util.Binary4x100STime(this.data, 28);
    }

    public long smf119apTtEtimeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public LocalDate smf119apTtEdate() {
        return Util.SMFDate(this.data, 32);
    }

    public int smf119apTtEdateRawValue() {
        return Util.ConvertPacked4(this.data, 32);
    }

    public InetAddress smf119apTtRip() {
        return Util.ConvertInetV6Address(this.data, 36);
    }

    public BigInteger smf119apTtRipRawValue() {
        return Util.ConvertBigInteger(this.data, 36, 16);
    }

    public int smf119apTTRIPFmt() {
        return Util.ConvertUnsignedBinary2(this.data, 46);
    }

    public InetAddress smf119apTtLip() {
        return Util.ConvertInetV6Address(this.data, 52);
    }

    public BigInteger smf119apTtLipRawValue() {
        return Util.ConvertBigInteger(this.data, 52, 16);
    }

    public int smf119apTtLipFmt() {
        return Util.ConvertUnsignedBinary2(this.data, 62);
    }

    public int smf119apTtRPort() {
        return Util.ConvertUnsignedBinary2(this.data, 68);
    }

    public int smf119apTtLPort() {
        return Util.ConvertUnsignedBinary2(this.data, 70);
    }

    public long smf119apTtInBytes() {
        return Util.ConvertUnsignedBinary8(this.data, 72);
    }

    public BigInteger smf119apTtInBytesAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 72);
    }

    public long smf119apTtOutBytes() {
        return Util.ConvertUnsignedBinary8(this.data, 80);
    }

    public BigInteger smf119apTtOutBytesAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 80);
    }

    public long smf119apTtSWS() {
        return Util.ConvertUnsignedBinary4(this.data, 88);
    }

    public long smf119apTtMSWS() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    public long smf119apTtCWS() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public long smf119apTtSMS() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    public Duration smf119apTtRTT() {
        return Util.Binary4MS(this.data, 104);
    }

    public double smf119apTtRTTSeconds() {
        return Util.ToSeconds(this.smf119apTtRTT());
    }

    public long smf119apTtRTTRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 104);
    }

    public Duration smf119apTtRVA() {
        return Util.Binary4MS(this.data, 108);
    }

    public double smf119apTtRVASeconds() {
        return Util.ToSeconds(this.smf119apTtRVA());
    }

    public long smf119apTtRVARawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 108);
    }

    public SocketStatus smf119apTtStatus() {
        int value = Util.ConvertUnsignedBinary1(this.data, 112);
        return SocketStatus.from(value);
    }

    public int smf119apTtStatusRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 112);
    }

    public int smf119apTtToS() {
        return Util.ConvertUnsignedBinary1(this.data, 113);
    }

    public String smf119apTtProf() {
        return Util.ConvertEbcdic(this.data, 116, 32);
    }

    public String smf119apTtPol() {
        return Util.ConvertEbcdic(this.data, 148, 32);
    }

    public long smf119apTtInSeg() {
        return Util.ConvertUnsignedBinary8(this.data, 180);
    }

    public BigInteger smf119apTtInSegAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 180);
    }

    public long smf119apTtOutSeg() {
        return Util.ConvertUnsignedBinary8(this.data, 188);
    }

    public BigInteger smf119apTtOutSegAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 188);
    }

    public ZonedDateTime smf119apTtSStck() {
        return Util.Binary8xStckTime(this.data, 196);
    }

    public BigInteger smf119apTtSStckRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 196);
    }

    public ZonedDateTime smf119apTtEStck() {
        return Util.Binary8xStckTime(this.data, 204);
    }

    public BigInteger smf119apTtEStckRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 204);
    }

    public long smf119apTtDupAcksRcvd() {
        return Util.ConvertUnsignedBinary4(this.data, 212);
    }

    public long smf119apTtLclSmcLinkId() {
        return Util.ConvertUnsignedBinary4(this.data, 216);
    }

    public long smf119apTtRmtSmcLinkId() {
        return Util.ConvertUnsignedBinary4(this.data, 220);
    }

    public SmcReason smf119apTtSmcReason() {
        int value = Util.ConvertSignedBinary4(this.data, 224);
        return SmcReason.from(value);
    }

    public int smf119apTtSmcReasonRawValue() {
        return Util.ConvertSignedBinary4(this.data, 224);
    }

    public int smf119apTtSmcFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 228);
    }

    public boolean smf119apTtSmcRsnRmt() {
        return Util.ConvertFlag(this.data, this.smf119apTtSmcFlags(), 128);
    }

    public boolean smf119apTtSmcCached() {
        return Util.ConvertFlag(this.data, this.smf119apTtSmcFlags(), 64);
    }

    public boolean smf119apTtSmcDRsnRmt() {
        return Util.ConvertFlag(this.data, this.smf119apTtSmcFlags(), 32);
    }

    public boolean smf119apTtSmcDCached() {
        return Util.ConvertFlag(this.data, this.smf119apTtSmcFlags(), 16);
    }

    public SmcStatus smf119apTtSmcDStatus() {
        int value = Util.ConvertUnsignedBinary1(this.data, 229);
        return SmcStatus.from(value);
    }

    public int smf119apTtSmcDStatusRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 229);
    }

    public int smf119apTtSmcFlags2() {
        return Util.ConvertUnsignedBinary1(this.data, 230);
    }

    public boolean smf119apTtSmcVersion1() {
        return Util.ConvertFlag(this.data, this.smf119apTtSmcFlags2(), 16);
    }

    public boolean smf119apTtSmcVersion2() {
        return Util.ConvertFlag(this.data, this.smf119apTtSmcFlags2(), 32);
    }

    public int smf119apTtIpSecurityFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 231);
    }

    public boolean smf119apTtIpSecurityEnbl() {
        return Util.ConvertFlag(this.data, this.smf119apTtIpSecurityFlags(), 128);
    }

    public boolean smf119apTtIPv6SecurityEnbl() {
        return Util.ConvertFlag(this.data, this.smf119apTtIpSecurityFlags(), 64);
    }

    public boolean smf119apTtIpFltrIncl() {
        return Util.ConvertFlag(this.data, this.smf119apTtIpSecurityFlags(), 32);
    }

    public long smf119apTtLclSmcBufSz() {
        return Util.ConvertUnsignedBinary4(this.data, 232);
    }

    public long smf119apTtRmtSmcBufSz() {
        return Util.ConvertUnsignedBinary4(this.data, 236);
    }

    public long smf119apTtXrt32() {
        return Util.ConvertUnsignedBinary4(this.data, 240);
    }

    public SmcReason smf119apTtSmcDReason() {
        int value = Util.ConvertSignedBinary4(this.data, 244);
        return SmcReason.from(value);
    }

    public int smf119apTtSmcDReasonRawValue() {
        return Util.ConvertSignedBinary4(this.data, 244);
    }

    public String smf119apTtSmcV2Eid() {
        return Util.ConvertEbcdic(this.data, 248, 32);
    }

    public String smf119apTtSmcDEid() {
        return Util.ConvertEbcdic(this.data, 248, 32);
    }

    public SmcReason smf119apTtSmvRV2Reason() {
        int value = Util.ConvertSignedBinary4(this.data, 280);
        return SmcReason.from(value);
    }

    public int smf119apTtSmvRV2ReasonRawValue() {
        return Util.ConvertSignedBinary4(this.data, 280);
    }

    public SmcReason smf119apTtSmcDV2Reason() {
        int value = Util.ConvertSignedBinary4(this.data, 284);
        return SmcReason.from(value);
    }

    public int smf119apTtSmcDV2ReasonRawValue() {
        return Util.ConvertSignedBinary4(this.data, 284);
    }

    public static ConnectionTermination create(byte[] Data2, int offset, int length) {
        return new ConnectionTermination(Data2, offset, length);
    }

    static enum Field {
        smf119apTtRname(0, 8),
        smf119apTtConnId(8, 4),
        smf119apTtTlsCs(12, 1),
        smf119apTtTlsPs(13, 1),
        smf119apTtTermCode(14, 1),
        smf119apTtSmcStatus(15, 1),
        smf119apTtSubtask(16, 4),
        smf119apTtStime(20, 4),
        smf119apTtSdate(24, 4),
        smf119apTtEtime(28, 4),
        smf119apTtEdate(32, 4),
        smf119apTtRip(36, 16),
        smf119apTTRIPFmt(46, 2),
        smf119apTtLip(52, 16),
        smf119apTtLipFmt(62, 2),
        smf119apTtRPort(68, 2),
        smf119apTtLPort(70, 2),
        smf119apTtInBytes(72, 8),
        smf119apTtOutBytes(80, 8),
        smf119apTtSWS(88, 4),
        smf119apTtMSWS(92, 4),
        smf119apTtCWS(96, 4),
        smf119apTtSMS(100, 4),
        smf119apTtRTT(104, 4),
        smf119apTtRVA(108, 4),
        smf119apTtStatus(112, 1),
        smf119apTtToS(113, 1),
        smf119apTtProf(116, 32),
        smf119apTtPol(148, 32),
        smf119apTtInSeg(180, 8),
        smf119apTtOutSeg(188, 8),
        smf119apTtSStck(196, 8),
        smf119apTtEStck(204, 8),
        smf119apTtDupAcksRcvd(212, 4),
        smf119apTtLclSmcLinkId(216, 4),
        smf119apTtRmtSmcLinkId(220, 4),
        smf119apTtSmcReason(224, 4),
        smf119apTtSmcFlags(228, 1),
        smf119apTtSmcDStatus(229, 1),
        smf119apTtSmcFlags2(230, 1),
        smf119apTtIpSecurityFlags(231, 1),
        smf119apTtLclSmcBufSz(232, 4),
        smf119apTtRmtSmcBufSz(236, 4),
        smf119apTtXrt32(240, 4),
        smf119apTtSmcDReason(244, 4),
        smf119apTtSmcV2Eid(248, 32),
        smf119apTtSmcDEid(248, 32),
        smf119apTtSmvRV2Reason(280, 4),
        smf119apTtSmcDV2Reason(284, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

