/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf119;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf119.values.TelnetLUSelection;
import com.blackhillsoftware.smf.smf119.values.TelnetSessionType;
import com.blackhillsoftware.smf.smf119.values.TelnetSslStatus;
import java.math.BigInteger;
import java.net.InetAddress;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;

public final class TN3270SNASessionTermination
extends SmfData {
    public static final int SMF119TN_NTCopt3270E = 128;
    public static final int SMF119TN_NTCoptTERM = 64;
    public static final int SMF119TN_NTCoptEOR = 32;
    public static final int SMF119TN_NTCoptBIN = 16;
    public static final int SMF119TN_NTCoptECHO = 8;
    public static final int SMF119TN_NTCoptGOAH = 4;
    public static final int SMF119TN_NTCoptTIME = 2;
    public static final int SMF119TN_NTCoptNENV = 1;
    public static final int SMF119TN_NT32optBind = 32768;
    public static final int SMF119TN_NT32optSysRq = 16384;
    public static final int SMF119TN_NT32optResp = 8192;
    public static final int SMF119TN_NT32optSCS = 4096;
    public static final int SMF119TN_NT32optDCS = 2048;
    public static final int SMF119TN_NT32optContR = 1024;
    public static final int SMF119TN_NT32optFMH = 512;
    public static final int SMF119TN_NT32optSNA = 256;
    public static final int SMF119TN_NT32optBytDb = 128;

    private TN3270SNASessionTermination(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String smf119tnNtlu() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public String smf119tnNTAppl() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public long smf119tnNTLDev() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public InetAddress smf119tnNtRip() {
        return Util.ConvertInetV6Address(this.data, 20);
    }

    public BigInteger smf119tnNtRipRawValue() {
        return Util.ConvertBigInteger(this.data, 20, 16);
    }

    public int smf119tnNtRipRFmt() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public InetAddress smf119tnNtripIPv4() {
        return Util.ConvertInetV4Address(this.data, 32);
    }

    public BigInteger smf119tnNtripIPv4RawValue() {
        return Util.ConvertBigInteger(this.data, 32, 4);
    }

    public InetAddress smf119tnNtLip() {
        return Util.ConvertInetV6Address(this.data, 36);
    }

    public BigInteger smf119tnNtLipRawValue() {
        return Util.ConvertBigInteger(this.data, 36, 16);
    }

    public int smf119tnNtLipRFmt() {
        return Util.ConvertUnsignedBinary2(this.data, 46);
    }

    public InetAddress smf119tnNtLipIPv4() {
        return Util.ConvertInetV4Address(this.data, 48);
    }

    public BigInteger smf119tnNtLipIPv4RawValue() {
        return Util.ConvertBigInteger(this.data, 48, 4);
    }

    public int smf119tnNtRPort() {
        return Util.ConvertUnsignedBinary2(this.data, 52);
    }

    public int smf119tnNtLPort() {
        return Util.ConvertUnsignedBinary2(this.data, 54);
    }

    public String smf119tnNtHostNm() {
        return Util.ConvertEbcdic(this.data, 56, 8);
    }

    public long smf119tnNtInByte() {
        return Util.ConvertUnsignedBinary8(this.data, 64);
    }

    public BigInteger smf119tnNtInByteAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 64);
    }

    public long smf119tnNtOutByte() {
        return Util.ConvertUnsignedBinary8(this.data, 72);
    }

    public BigInteger smf119tnNtOutByteAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 72);
    }

    public LocalTime smf119tnNtITime() {
        return Util.Binary4x100STime(this.data, 80);
    }

    public long smf119tnNtITimeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public LocalDate smf119tnNtIDate() {
        return Util.SMFDate(this.data, 84);
    }

    public int smf119tnNtIDateRawValue() {
        return Util.ConvertPacked4(this.data, 84);
    }

    public LocalTime smf119tnNtTTime() {
        return Util.Binary4x100STime(this.data, 88);
    }

    public long smf119tnNtTTimeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 88);
    }

    public LocalDate smf119tnNtTDate() {
        return Util.SMFDate(this.data, 92);
    }

    public int smf119tnNtTDateRawValue() {
        return Util.ConvertPacked4(this.data, 92);
    }

    public Duration smf119tnNtDur() {
        return Util.Binary4x100S(this.data, 96);
    }

    public double smf119tnNtDurSeconds() {
        return Util.ToSeconds(this.smf119tnNtDur());
    }

    public long smf119tnNtDurRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public TelnetSessionType smf119tnNtSType() {
        int value = Util.ConvertUnsignedBinary1(this.data, 100);
        return TelnetSessionType.from(value);
    }

    public int smf119tnNtSTypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 100);
    }

    public TelnetLUSelection smf119tnNtLUSel() {
        int value = Util.ConvertUnsignedBinary1(this.data, 101);
        return TelnetLUSelection.from(value);
    }

    public int smf119tnNtLUSelRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 101);
    }

    public TelnetSslStatus smf119tnNtSsl() {
        int value = Util.ConvertUnsignedBinary1(this.data, 102);
        return TelnetSslStatus.from(value);
    }

    public int smf119tnNtSslRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 102);
    }

    public int smf119tnNtCOpt() {
        return Util.ConvertUnsignedBinary1(this.data, 104);
    }

    public boolean smf119tnNtCOpt3270E() {
        return Util.ConvertFlag(this.data, this.smf119tnNtCOpt(), 128);
    }

    public boolean smf119tnNtCOptTERM() {
        return Util.ConvertFlag(this.data, this.smf119tnNtCOpt(), 64);
    }

    public boolean smf119tnNtCOptEOR() {
        return Util.ConvertFlag(this.data, this.smf119tnNtCOpt(), 32);
    }

    public boolean smf119tnNtCOptBIN() {
        return Util.ConvertFlag(this.data, this.smf119tnNtCOpt(), 16);
    }

    public boolean smf119tnNtCOptECHO() {
        return Util.ConvertFlag(this.data, this.smf119tnNtCOpt(), 8);
    }

    public boolean smf119tnNtCOptGOAH() {
        return Util.ConvertFlag(this.data, this.smf119tnNtCOpt(), 4);
    }

    public boolean smf119tnNtCOptTIME() {
        return Util.ConvertFlag(this.data, this.smf119tnNtCOpt(), 2);
    }

    public boolean smf119tnNtCOptNENV() {
        return Util.ConvertFlag(this.data, this.smf119tnNtCOpt(), 1);
    }

    public int smf119tnNt32Opt() {
        return Util.ConvertUnsignedBinary2(this.data, 106);
    }

    public boolean smf119tnNt32OptBind() {
        return Util.ConvertFlag(this.data, this.smf119tnNt32Opt(), 32768);
    }

    public boolean smf119tnNt32OptSysRq() {
        return Util.ConvertFlag(this.data, this.smf119tnNt32Opt(), 16384);
    }

    public boolean smf119tnNt32OptResp() {
        return Util.ConvertFlag(this.data, this.smf119tnNt32Opt(), 8192);
    }

    public boolean smf119tnNt32OptSCS() {
        return Util.ConvertFlag(this.data, this.smf119tnNt32Opt(), 4096);
    }

    public boolean smf119tnNt32OptDCS() {
        return Util.ConvertFlag(this.data, this.smf119tnNt32Opt(), 2048);
    }

    public boolean smf119tnNt32OptContR() {
        return Util.ConvertFlag(this.data, this.smf119tnNt32Opt(), 1024);
    }

    public boolean smf119tnNt32OptFMH() {
        return Util.ConvertFlag(this.data, this.smf119tnNt32Opt(), 512);
    }

    public boolean smf119tnNt32OptSNA() {
        return Util.ConvertFlag(this.data, this.smf119tnNt32Opt(), 256);
    }

    public boolean smf119tnNt32OptBytDb() {
        return Util.ConvertFlag(this.data, this.smf119tnNt32Opt(), 128, Field.smf119tnNt32Opt.length, 1);
    }

    public String smf119tnNtRCode() {
        return Util.ConvertEbcdic(this.data, 108, 8);
    }

    public String smf119tnNtLMode() {
        return Util.ConvertEbcdic(this.data, 116, 8);
    }

    public String smf119tnNtDevt() {
        return Util.ConvertEbcdic(this.data, 124, 20);
    }

    public static TN3270SNASessionTermination create(byte[] Data2, int offset, int length) {
        return new TN3270SNASessionTermination(Data2, offset, length);
    }

    static enum Field {
        smf119tnNtlu(0, 8),
        smf119tnNTAppl(8, 8),
        smf119tnNTLDev(16, 4),
        smf119tnNtRip(20, 16),
        smf119tnNtRipRFmt(30, 2),
        smf119tnNtripIPv4(32, 4),
        smf119tnNtLip(36, 16),
        smf119tnNtLipRFmt(46, 2),
        smf119tnNtLipIPv4(48, 4),
        smf119tnNtRPort(52, 2),
        smf119tnNtLPort(54, 2),
        smf119tnNtHostNm(56, 8),
        smf119tnNtInByte(64, 8),
        smf119tnNtOutByte(72, 8),
        smf119tnNtITime(80, 4),
        smf119tnNtIDate(84, 4),
        smf119tnNtTTime(88, 4),
        smf119tnNtTDate(92, 4),
        smf119tnNtDur(96, 4),
        smf119tnNtSType(100, 1),
        smf119tnNtLUSel(101, 1),
        smf119tnNtSsl(102, 1),
        smf119tnNtCOpt(104, 1),
        smf119tnNt32Opt(106, 2),
        smf119tnNtRCode(108, 8),
        smf119tnNtLMode(116, 8),
        smf119tnNtDevt(124, 20);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

