/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf119;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;

public final class TN3270SNASessionTerminationRoundTripPerformance
extends SmfData {
    public static final int SMF119TN_NTRDR_Used = 128;
    public static final int SMF119TN_NTRTM_Used = 64;

    private TN3270SNASessionTerminationRoundTripPerformance(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public long smf119tnNtrRts() {
        return Util.ConvertUnsignedBinary4(this.data, 0);
    }

    public long smf119tnNtrIpRts() {
        return Util.ConvertUnsignedBinary4(this.data, 4);
    }

    public long smf119tnNtrCountTrans() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public long smf119tnNtrCountIp() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long smf119tnNtrElapsRndTrpSq() {
        return Util.ConvertUnsignedBinary8(this.data, 16);
    }

    public BigInteger smf119tnNtrElapsRndTrpSqAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 16);
    }

    public long smf119tnNtrElapsIpRtSq() {
        return Util.ConvertUnsignedBinary8(this.data, 24);
    }

    public BigInteger smf119tnNtrElapsIpRtSqAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 24);
    }

    public long smf119tnNtrElapsSnaRtSq() {
        return Util.ConvertUnsignedBinary8(this.data, 32);
    }

    public BigInteger smf119tnNtrElapsSnaRtSqAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 32);
    }

    public long smf119tnNtrGrpIndex() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public int smf119tnNtrDR() {
        return Util.ConvertUnsignedBinary1(this.data, 44);
    }

    public boolean smf119tnNtrDRUsed() {
        return Util.ConvertFlag(this.data, this.smf119tnNtrDR(), 128);
    }

    public boolean smf119tnNtrTMUsed() {
        return Util.ConvertFlag(this.data, this.smf119tnNtrDR(), 64);
    }

    public static TN3270SNASessionTerminationRoundTripPerformance create(byte[] Data2, int offset, int length) {
        return new TN3270SNASessionTerminationRoundTripPerformance(Data2, offset, length);
    }

    static enum Field {
        smf119tnNtrRts(0, 4),
        smf119tnNtrIpRts(4, 4),
        smf119tnNtrCountTrans(8, 4),
        smf119tnNtrCountIp(12, 4),
        smf119tnNtrElapsRndTrpSq(16, 8),
        smf119tnNtrElapsIpRtSq(24, 8),
        smf119tnNtrElapsSnaRtSq(32, 8),
        smf119tnNtrGrpIndex(40, 4),
        smf119tnNtrDR(44, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

