/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf119;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf119.zert.DetailEvent;
import com.blackhillsoftware.smf.smf119.zert.IPProtocol;
import java.math.BigInteger;
import java.net.InetAddress;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public final class ZertDetailCommonSection
extends SmfData {
    public static final int SMF119SC_SASecProto_TLS = 128;
    public static final int SMF119SC_SASecProto_SSH = 64;
    public static final int SMF119SC_SASecProto_IPSec = 32;
    public static final int SMF119SC_SAIPv6 = 128;
    public static final int SMF119SC_SAATTLS_Optimized = 64;
    public static final int SMF119SC_SAEnforcement = 32;
    public static final int SMF119SC_SAIPSec_On = 128;
    public static final int SMF119SC_SAIPSec_IPv6_On = 64;
    public static final int SMF119SC_SAIPFiltering = 32;
    public static final int SMF119SC_SASecProto_None = 0;

    private ZertDetailCommonSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public DetailEvent smf119scSaEventType() {
        int value = Util.ConvertUnsignedBinary1(this.data, 0);
        return DetailEvent.from(value);
    }

    public int smf119scSaEventTypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public int smf119scSaSecProtos() {
        return Util.ConvertUnsignedBinary1(this.data, 1);
    }

    public boolean smf119scSaSecProtoTls() {
        return Util.ConvertFlag(this.data, this.smf119scSaSecProtos(), 128);
    }

    public boolean smf119scSaSecProtoSsh() {
        return Util.ConvertFlag(this.data, this.smf119scSaSecProtos(), 64);
    }

    public boolean smf119scSaSecProtoIPSec() {
        return Util.ConvertFlag(this.data, this.smf119scSaSecProtos(), 32);
    }

    public int smf119scSaFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 2);
    }

    public boolean smf119scSaIPv6() {
        return Util.ConvertFlag(this.data, this.smf119scSaFlags(), 128);
    }

    public boolean smf119scSaAttlsOptimized() {
        return Util.ConvertFlag(this.data, this.smf119scSaFlags(), 64);
    }

    public boolean smf119scSaEnforcement() {
        return Util.ConvertFlag(this.data, this.smf119scSaFlags(), 32);
    }

    public int smf119scSaSecFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 3);
    }

    public boolean smf119scSaIPSecOn() {
        return Util.ConvertFlag(this.data, this.smf119scSaSecFlags(), 128);
    }

    public boolean smf119scSaIPSecIPv6On() {
        return Util.ConvertFlag(this.data, this.smf119scSaSecFlags(), 64);
    }

    public boolean smf119scSaIpFiltering() {
        return Util.ConvertFlag(this.data, this.smf119scSaSecFlags(), 32);
    }

    public IPProtocol smf119scSaIpProto() {
        int value = Util.ConvertUnsignedBinary1(this.data, 4);
        return IPProtocol.from(value);
    }

    public int smf119scSaIpProtoRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String smf119scSaJobname() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public String smf119scSaJobID() {
        return Util.ConvertEbcdic(this.data, 16, 8);
    }

    public String smf119scSaUserID() {
        return Util.ConvertEbcdic(this.data, 24, 8);
    }

    public LocalTime smf119scSaSTime() {
        return Util.Binary4x100STime(this.data, 32);
    }

    public long smf119scSaSTimeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public LocalDate smf119scSaSDate() {
        return Util.SMFDate(this.data, 36);
    }

    public int smf119scSaSDateRawValue() {
        return Util.ConvertPacked4(this.data, 36);
    }

    public ZonedDateTime smf119scSaSDateTime() {
        return this.smf119scSaSDate() != null ? this.smf119scSaSDate().atTime(this.smf119scSaSTime()).atZone(ZoneOffset.UTC) : null;
    }

    public LocalTime smf119scSaETime() {
        return Util.Binary4x100STime(this.data, 40);
    }

    public long smf119scSaETimeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public LocalDate smf119scSaEDate() {
        return Util.SMFDate(this.data, 44);
    }

    public int smf119scSaEDateRawValue() {
        return Util.ConvertPacked4(this.data, 44);
    }

    public ZonedDateTime smf119scSaEDateTime() {
        return this.smf119scSaEDate() != null ? this.smf119scSaEDate().atTime(this.smf119scSaETime()).atZone(ZoneOffset.UTC) : null;
    }

    public InetAddress smf119scSaRip() {
        return this.smf119scSaIPv6() ? this.smf119scSaRipIPv6() : this.smf119scSaRipIPv4();
    }

    public BigInteger smf119scSaRipRawValue() {
        return Util.ConvertBigInteger(this.data, 48, 16);
    }

    private InetAddress smf119scSaRipIPv4() {
        return Util.ConvertInetV4Address(this.data, 48);
    }

    private BigInteger smf119scSaRipIPv4RawValue() {
        return Util.ConvertBigInteger(this.data, 48, 4);
    }

    private InetAddress smf119scSaRipIPv6() {
        return Util.ConvertInetV6Address(this.data, 48);
    }

    private BigInteger smf119scSaRipIPv6RawValue() {
        return Util.ConvertBigInteger(this.data, 48, 16);
    }

    public InetAddress smf119scSaLip() {
        return this.smf119scSaIPv6() ? this.smf119scSaLipIPv6() : this.smf119scSaLipIPv4();
    }

    public BigInteger smf119scSaLipRawValue() {
        return Util.ConvertBigInteger(this.data, 64, 16);
    }

    private InetAddress smf119scSaLipIPv4() {
        return Util.ConvertInetV4Address(this.data, 64);
    }

    private BigInteger smf119scSaLipIPv4RawValue() {
        return Util.ConvertBigInteger(this.data, 64, 4);
    }

    private InetAddress smf119scSaLipIPv6() {
        return Util.ConvertInetV6Address(this.data, 64);
    }

    private BigInteger smf119scSaLipIPv6RawValue() {
        return Util.ConvertBigInteger(this.data, 64, 16);
    }

    public int smf119scSaRPort() {
        return Util.ConvertUnsignedBinary2(this.data, 80);
    }

    public int smf119scSaLPort() {
        return Util.ConvertUnsignedBinary2(this.data, 82);
    }

    public long smf119scSaConnID() {
        return Util.ConvertUnsignedBinary4(this.data, 84);
    }

    public long smf119scSaInBytes() {
        return Util.ConvertUnsignedBinary8(this.data, 88);
    }

    public BigInteger smf119scSaInBytesAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 88);
    }

    public long smf119scSaOutBytes() {
        return Util.ConvertUnsignedBinary8(this.data, 96);
    }

    public BigInteger smf119scSaOutBytesAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 96);
    }

    public long smf119scSaInSegDG() {
        return Util.ConvertUnsignedBinary8(this.data, 104);
    }

    public BigInteger smf119scSaInSegDGAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 104);
    }

    public long smf119scSaOutSegDG() {
        return Util.ConvertUnsignedBinary8(this.data, 112);
    }

    public BigInteger smf119scSaOutSegDGAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 112);
    }

    public boolean smf119scSASecProtoNone() {
        return Util.ConvertEquateValue(this.data, this.smf119scSaSecProtos(), 0);
    }

    public static ZertDetailCommonSection create(byte[] Data2, int offset, int length) {
        return new ZertDetailCommonSection(Data2, offset, length);
    }

    static enum Field {
        smf119scSaEventType(0, 1),
        smf119scSaSecProtos(1, 1),
        smf119scSaFlags(2, 1),
        smf119scSaSecFlags(3, 1),
        smf119scSaIpProto(4, 1),
        smf119scSaJobname(8, 8),
        smf119scSaJobID(16, 8),
        smf119scSaUserID(24, 8),
        smf119scSaSTime(32, 4),
        smf119scSaSDate(36, 4),
        smf119scSaETime(40, 4),
        smf119scSaEDate(44, 4),
        smf119scSaRip(48, 16),
        smf119scSaRipIPv4(48, 4),
        smf119scSaRipIPv6(48, 16),
        smf119scSaLip(64, 16),
        smf119scSaLipIPv4(64, 4),
        smf119scSaLipIPv6(64, 16),
        smf119scSaRPort(80, 2),
        smf119scSaLPort(82, 2),
        smf119scSaConnID(84, 4),
        smf119scSaInBytes(88, 8),
        smf119scSaOutBytes(96, 8),
        smf119scSaInSegDG(104, 8),
        smf119scSaOutSegDG(112, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

