/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf119;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.Token;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf119.zert.CertDigestAlgorithm;
import com.blackhillsoftware.smf.smf119.zert.CertEncryptionMethod;
import com.blackhillsoftware.smf.smf119.zert.EncryptionAlgorithm;
import com.blackhillsoftware.smf.smf119.zert.FipsMode;
import com.blackhillsoftware.smf.smf119.zert.KeyType;
import com.blackhillsoftware.smf.smf119.zert.MessageAuthAlgorithm;
import com.blackhillsoftware.smf.smf119.zert.SSHAuthMethod;
import com.blackhillsoftware.smf.smf119.zert.SSHKexMethod;
import com.blackhillsoftware.smf.smf119.zert.SSHProtocolVersion;
import com.blackhillsoftware.smf.smf119.zert.SignatureMethod;
import com.blackhillsoftware.smf.smf119.zert.Source;
import com.blackhillsoftware.smf.smf119.zert.TimeType;
import java.time.ZonedDateTime;

public final class ZertDetailSSHSection
extends SmfData {
    public static final int SMF119SC_SSH_Enc_Then_Mac_In = 128;
    public static final int SMF119SC_SSH_Enc_Then_Mac_Out = 64;

    private ZertDetailSSHSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public SSHProtocolVersion smf119scSshProtVer() {
        int value = Util.ConvertUnsignedBinary1(this.data, 0);
        return SSHProtocolVersion.from(value);
    }

    public int smf119scSshProtVerRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 0);
    }

    public Source smf119scSshSource() {
        int value = Util.ConvertUnsignedBinary1(this.data, 1);
        return Source.from(value);
    }

    public int smf119scSshSourceRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 1);
    }

    public FipsMode smf119scSshFipsMode() {
        int value = Util.ConvertUnsignedBinary1(this.data, 2);
        return FipsMode.from(value);
    }

    public int smf119scSshFipsModeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 2);
    }

    public int smf119scSshCryptoFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 3);
    }

    public boolean smf119scSshEncThenMacIn() {
        return Util.ConvertFlag(this.data, this.smf119scSshCryptoFlags(), 128);
    }

    public boolean smf119scSshEncThenMacOut() {
        return Util.ConvertFlag(this.data, this.smf119scSshCryptoFlags(), 64);
    }

    public String smf119scSshComp() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public String smf119scSshProtocolProvider() {
        return Util.ConvertEbcdic(this.data, 16, 16);
    }

    public SSHAuthMethod smf119scSshAuthMethod() {
        int value = Util.ConvertUnsignedBinary2(this.data, 32);
        return SSHAuthMethod.from(value);
    }

    public int smf119scSshAuthMethodRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 32);
    }

    public SSHAuthMethod smf119scSshAuthMethod2() {
        int value = Util.ConvertUnsignedBinary2(this.data, 34);
        return SSHAuthMethod.from(value);
    }

    public int smf119scSshAuthMethod2RawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 34);
    }

    public EncryptionAlgorithm smf119scSshInEncAlg() {
        int value = Util.ConvertUnsignedBinary2(this.data, 36);
        return EncryptionAlgorithm.from(value);
    }

    public int smf119scSshInEncAlgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 36);
    }

    public MessageAuthAlgorithm smf119scSshInMsgAuth() {
        int value = Util.ConvertUnsignedBinary2(this.data, 38);
        return MessageAuthAlgorithm.from(value);
    }

    public int smf119scSshInMsgAuthRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 38);
    }

    public SSHKexMethod smf119scSshKexMethod() {
        int value = Util.ConvertUnsignedBinary2(this.data, 40);
        return SSHKexMethod.from(value);
    }

    public int smf119scSshKexMethodRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 40);
    }

    public EncryptionAlgorithm smf119scSshOutEncAlg() {
        int value = Util.ConvertUnsignedBinary2(this.data, 42);
        return EncryptionAlgorithm.from(value);
    }

    public int smf119scSshOutEncAlgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 42);
    }

    public MessageAuthAlgorithm smf119scSshOutMsgAuth() {
        int value = Util.ConvertUnsignedBinary2(this.data, 44);
        return MessageAuthAlgorithm.from(value);
    }

    public int smf119scSshOutMsgAuthRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 44);
    }

    public KeyType smf119scSshSKeyType() {
        int value = Util.ConvertUnsignedBinary2(this.data, 48);
        return KeyType.from(value);
    }

    public int smf119scSshSKeyTypeRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public int smf119scSshSKeyLen() {
        return Util.ConvertUnsignedBinary2(this.data, 50);
    }

    public KeyType smf119scSshCKeyType() {
        int value = Util.ConvertUnsignedBinary2(this.data, 52);
        return KeyType.from(value);
    }

    public int smf119scSshCKeyTypeRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 52);
    }

    public int smf119scSshCKeyLen() {
        return Util.ConvertUnsignedBinary2(this.data, 54);
    }

    public int smf119scSshSKeyFpLen() {
        return Util.ConvertUnsignedBinary2(this.data, 56);
    }

    public int smf119scSshCKeyFpLen() {
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    public Token smf119scSshSKeyFp() {
        if (this.smf119scSshSKeyFpLen() == 0) {
            return null;
        }
        if (this.data.length >= 60 + this.smf119scSshSKeyFpLen()) {
            return new Token(this.data, 60, this.smf119scSshSKeyFpLen());
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(60) + " Data length: " + Integer.toString(this.smf119scSshSKeyFpLen()));
    }

    public Token smf119scSshCKeyFp() {
        if (this.smf119scSshCKeyFpLen() == 0) {
            return null;
        }
        if (this.data.length >= 124 + this.smf119scSshCKeyFpLen()) {
            return new Token(this.data, 124, this.smf119scSshCKeyFpLen());
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(124) + " Data length: " + Integer.toString(this.smf119scSshCKeyFpLen()));
    }

    public SignatureMethod smf119scSshSCertSignatureMethod() {
        int value = Util.ConvertUnsignedBinary2(this.data, 188);
        return SignatureMethod.from(value);
    }

    public int smf119scSshSCertSignatureMethodRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 188);
    }

    public CertEncryptionMethod smf119scSshSCertEncMethod() {
        int value = Util.ConvertUnsignedBinary2(this.data, 190);
        return CertEncryptionMethod.from(value);
    }

    public int smf119scSshSCertEncMethodRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 190);
    }

    public CertDigestAlgorithm smf119scSshSCertDigestAlg() {
        int value = Util.ConvertUnsignedBinary2(this.data, 192);
        return CertDigestAlgorithm.from(value);
    }

    public int smf119scSshSCertDigestAlgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 192);
    }

    public int smf119scSshSCertSerialLen() {
        return Util.ConvertUnsignedBinary1(this.data, 195);
    }

    public Token smf119scSshSCertSerial() {
        if (this.smf119scSshSCertSerialLen() == 0) {
            return null;
        }
        if (this.data.length >= 196 + this.smf119scSshSCertSerialLen()) {
            return new Token(this.data, 196, this.smf119scSshSCertSerialLen());
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(196) + " Data length: " + Integer.toString(this.smf119scSshSCertSerialLen()));
    }

    public TimeType smf119scSshSCertTimeType() {
        int value = Util.ConvertUnsignedBinary1(this.data, 216);
        return TimeType.from(value);
    }

    public int smf119scSshSCertTimeTypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 216);
    }

    public ZonedDateTime smf119scSshSCertTime() {
        switch (this.smf119scSshSCertTimeType()) {
            case GT: {
                return this.smf119scSshSCertTimeGt();
            }
            case UTC: {
                return this.smf119scSshSCertTimeUtc();
            }
        }
        return null;
    }

    public String smf119scSshSCertTimeRawValue() {
        return Util.ConvertEbcdic(this.data, 217, 15);
    }

    private ZonedDateTime smf119scSshSCertTimeUtc() {
        return Util.YYMMDDhhmmssZ(this.data, 217);
    }

    private String smf119scSshSCertTimeUtcRawValue() {
        return Util.ConvertEbcdic(this.data, 217, 13);
    }

    private ZonedDateTime smf119scSshSCertTimeGt() {
        return Util.YYYYMMDDhhmmssZ(this.data, 217);
    }

    private String smf119scSshSCertTimeGtRawValue() {
        return Util.ConvertEbcdic(this.data, 217, 15);
    }

    public KeyType smf119scSshSCertKeyType() {
        int value = Util.ConvertUnsignedBinary2(this.data, 232);
        return KeyType.from(value);
    }

    public int smf119scSshSCertKeyTypeRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 232);
    }

    public int smf119scSshSCertKeyLen() {
        return Util.ConvertUnsignedBinary2(this.data, 234);
    }

    public SignatureMethod smf119scSshCCertSignatureMethod() {
        int value = Util.ConvertUnsignedBinary2(this.data, 236);
        return SignatureMethod.from(value);
    }

    public int smf119scSshCCertSignatureMethodRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 236);
    }

    public CertEncryptionMethod smf119scSshCCertEncMethod() {
        int value = Util.ConvertUnsignedBinary2(this.data, 238);
        return CertEncryptionMethod.from(value);
    }

    public int smf119scSshCCertEncMethodRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 238);
    }

    public CertDigestAlgorithm smf119scSshCCertDigestAlg() {
        int value = Util.ConvertUnsignedBinary2(this.data, 240);
        return CertDigestAlgorithm.from(value);
    }

    public int smf119scSshCCertDigestAlgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 240);
    }

    public int smf119scSshCCertSerialLen() {
        return Util.ConvertUnsignedBinary1(this.data, 243);
    }

    public Token smf119scSshCCertSerial() {
        if (this.smf119scSshCCertSerialLen() == 0) {
            return null;
        }
        if (this.data.length >= 244 + this.smf119scSshCCertSerialLen()) {
            return new Token(this.data, 244, this.smf119scSshCCertSerialLen());
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(244) + " Data length: " + Integer.toString(this.smf119scSshCCertSerialLen()));
    }

    public TimeType smf119scSshCCertTimeType() {
        int value = Util.ConvertUnsignedBinary1(this.data, 264);
        return TimeType.from(value);
    }

    public int smf119scSshCCertTimeTypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 264);
    }

    public ZonedDateTime smf119scSshCCertTime() {
        switch (this.smf119scSshCCertTimeType()) {
            case GT: {
                return this.smf119scSshCCertTimeGt();
            }
            case UTC: {
                return this.smf119scSshCCertTimeUtc();
            }
        }
        return null;
    }

    public String smf119scSshCCertTimeRawValue() {
        return Util.ConvertEbcdic(this.data, 265, 15);
    }

    private ZonedDateTime smf119scSshCCertTimeUtc() {
        return Util.YYMMDDhhmmssZ(this.data, 265);
    }

    private String smf119scSshCCertTimeUtcRawValue() {
        return Util.ConvertEbcdic(this.data, 265, 13);
    }

    private ZonedDateTime smf119scSshCCertTimeGt() {
        return Util.YYYYMMDDhhmmssZ(this.data, 265);
    }

    private String smf119scSshCCertTimeGtRawValue() {
        return Util.ConvertEbcdic(this.data, 265, 15);
    }

    public KeyType smf119scSshCCertKeyType() {
        int value = Util.ConvertUnsignedBinary2(this.data, 280);
        return KeyType.from(value);
    }

    public int smf119scSshCCertKeyTypeRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 280);
    }

    public int smf119scSshCCertKeyLen() {
        return Util.ConvertUnsignedBinary2(this.data, 282);
    }

    public static ZertDetailSSHSection create(byte[] Data2, int offset, int length) {
        return new ZertDetailSSHSection(Data2, offset, length);
    }

    static enum Field {
        smf119scSshProtVer(0, 1),
        smf119scSshSource(1, 1),
        smf119scSshFipsMode(2, 1),
        smf119scSshCryptoFlags(3, 1),
        smf119scSshComp(8, 8),
        smf119scSshProtocolProvider(16, 16),
        smf119scSshAuthMethod(32, 2),
        smf119scSshAuthMethod2(34, 2),
        smf119scSshInEncAlg(36, 2),
        smf119scSshInMsgAuth(38, 2),
        smf119scSshKexMethod(40, 2),
        smf119scSshOutEncAlg(42, 2),
        smf119scSshOutMsgAuth(44, 2),
        smf119scSshSKeyType(48, 2),
        smf119scSshSKeyLen(50, 2),
        smf119scSshCKeyType(52, 2),
        smf119scSshCKeyLen(54, 2),
        smf119scSshSKeyFpLen(56, 2),
        smf119scSshCKeyFpLen(58, 2),
        smf119scSshSKeyFp(60, 0),
        smf119scSshCKeyFp(124, 0),
        smf119scSshSCertSignatureMethod(188, 2),
        smf119scSshSCertEncMethod(190, 2),
        smf119scSshSCertDigestAlg(192, 2),
        smf119scSshSCertSerialLen(195, 1),
        smf119scSshSCertSerial(196, 0),
        smf119scSshSCertTimeType(216, 1),
        smf119scSshSCertTime(217, 15),
        smf119scSshSCertTimeUtc(217, 13),
        smf119scSshSCertTimeGt(217, 15),
        smf119scSshSCertKeyType(232, 2),
        smf119scSshSCertKeyLen(234, 2),
        smf119scSshCCertSignatureMethod(236, 2),
        smf119scSshCCertEncMethod(238, 2),
        smf119scSshCCertDigestAlg(240, 2),
        smf119scSshCCertSerialLen(243, 1),
        smf119scSshCCertSerial(244, 0),
        smf119scSshCCertTimeType(264, 1),
        smf119scSshCCertTime(265, 15),
        smf119scSshCCertTimeUtc(265, 13),
        smf119scSshCCertTimeGt(265, 15),
        smf119scSshCCertKeyType(280, 2),
        smf119scSshCCertKeyLen(282, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

