/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf119;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.Token;
import com.blackhillsoftware.smf.internal.Util;
import com.blackhillsoftware.smf.smf119.zert.CertDigestAlgorithm;
import com.blackhillsoftware.smf.smf119.zert.CertEncryptionMethod;
import com.blackhillsoftware.smf.smf119.zert.EncryptionAlgorithm;
import com.blackhillsoftware.smf.smf119.zert.FipsMode;
import com.blackhillsoftware.smf.smf119.zert.KeyType;
import com.blackhillsoftware.smf.smf119.zert.MessageAuthAlgorithm;
import com.blackhillsoftware.smf.smf119.zert.SignatureMethod;
import com.blackhillsoftware.smf.smf119.zert.Source;
import com.blackhillsoftware.smf.smf119.zert.TLSHandshakeRole;
import com.blackhillsoftware.smf.smf119.zert.TLSHandshakeType;
import com.blackhillsoftware.smf.smf119.zert.TLSKexAlgorithm;
import com.blackhillsoftware.smf.smf119.zert.TLSNegotiatedkeyShare;
import com.blackhillsoftware.smf.smf119.zert.TLSProtocolVersion;
import com.blackhillsoftware.smf.smf119.zert.TimeType;
import java.time.ZonedDateTime;

public final class ZertDetailTLSSection
extends SmfData {
    public static final int SMF119SC_TLS_Enc_Then_Mac = 128;
    public static final int SMF119SC_TLS_Raw_Public_Key_Auth = 64;
    public static final int SMF119SC_TLS_Preshared_Key = 32;
    public static final int SMF119SC_TLS_Preshared_Key_Auth = 16;

    private ZertDetailTLSSection(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public TLSProtocolVersion smf119scTlsProtVer() {
        int value = Util.ConvertUnsignedBinary2(this.data, 0);
        return TLSProtocolVersion.from(value);
    }

    public int smf119scTlsProtVerRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public Source smf119scTlsSource() {
        int value = Util.ConvertUnsignedBinary1(this.data, 2);
        return Source.from(value);
    }

    public int smf119scTlsSourceRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 2);
    }

    public TLSHandshakeType smf119scTlsHandshakeType() {
        int value = Util.ConvertUnsignedBinary1(this.data, 3);
        return TLSHandshakeType.from(value);
    }

    public int smf119scTlsHandshakeTypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 3);
    }

    public TLSHandshakeRole smf119scTlsHandshakeRole() {
        int value = Util.ConvertUnsignedBinary1(this.data, 4);
        return TLSHandshakeRole.from(value);
    }

    public int smf119scTlsHandshakeRoleRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smf119scTlsSessionIdLen() {
        return Util.ConvertUnsignedBinary1(this.data, 7);
    }

    public Token smf119scTlsSessionId() {
        if (this.smf119scTlsSessionIdLen() == 0) {
            return null;
        }
        if (this.data.length >= 8 + this.smf119scTlsSessionIdLen()) {
            return new Token(this.data, 8, this.smf119scTlsSessionIdLen());
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(8) + " Data length: " + Integer.toString(this.smf119scTlsSessionIdLen()));
    }

    public String smf119scTlsProtocolProvider() {
        return Util.ConvertEbcdic(this.data, 40, 16);
    }

    public String smf119scTlsNegCipher() {
        return Util.ConvertEbcdic(this.data, 56, 6);
    }

    public EncryptionAlgorithm smf119scTlsCSEncAlg() {
        int value = Util.ConvertUnsignedBinary2(this.data, 62);
        return EncryptionAlgorithm.from(value);
    }

    public int smf119scTlsCSEncAlgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 62);
    }

    public MessageAuthAlgorithm smf119scTlsCSMsgAuth() {
        int value = Util.ConvertUnsignedBinary2(this.data, 64);
        return MessageAuthAlgorithm.from(value);
    }

    public int smf119scTlsCSMsgAuthRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 64);
    }

    public TLSKexAlgorithm smf119scTlsCSKexAlg() {
        int value = Util.ConvertUnsignedBinary2(this.data, 66);
        return TLSKexAlgorithm.from(value);
    }

    public int smf119scTlsCSKexAlgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 66);
    }

    public FipsMode smf119scTlsFipsMode() {
        int value = Util.ConvertUnsignedBinary1(this.data, 68);
        return FipsMode.from(value);
    }

    public int smf119scTlsFipsModeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 68);
    }

    public int smf119scTlsCryptoFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 69);
    }

    public boolean smf119scTlsEncThenMac() {
        return Util.ConvertFlag(this.data, this.smf119scTlsCryptoFlags(), 128);
    }

    public boolean smf119scTlsRawPublicKeyAuth() {
        return Util.ConvertFlag(this.data, this.smf119scTlsCryptoFlags(), 64);
    }

    public boolean smf119scTlsPresharedKey() {
        return Util.ConvertFlag(this.data, this.smf119scTlsCryptoFlags(), 32);
    }

    public boolean smf119scTlsPresharedKeyAuth() {
        return Util.ConvertFlag(this.data, this.smf119scTlsCryptoFlags(), 16);
    }

    public SignatureMethod smf119scTlsSCertSignatureMethod() {
        int value = Util.ConvertUnsignedBinary2(this.data, 72);
        return SignatureMethod.from(value);
    }

    public int smf119scTlsSCertSignatureMethodRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 72);
    }

    public CertEncryptionMethod smf119scTlsSCertEncMethod() {
        int value = Util.ConvertUnsignedBinary2(this.data, 74);
        return CertEncryptionMethod.from(value);
    }

    public int smf119scTlsSCertEncMethodRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 74);
    }

    public CertDigestAlgorithm smf119scTlsSCertDigestAlg() {
        int value = Util.ConvertUnsignedBinary2(this.data, 76);
        return CertDigestAlgorithm.from(value);
    }

    public int smf119scTlsSCertDigestAlgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 76);
    }

    public int smf119scTlsSCertSerialLen() {
        return Util.ConvertUnsignedBinary1(this.data, 79);
    }

    public Token smf119scTlsSCertSerial() {
        if (this.smf119scTlsSCertSerialLen() == 0) {
            return null;
        }
        if (this.data.length >= 80 + this.smf119scTlsSCertSerialLen()) {
            return new Token(this.data, 80, this.smf119scTlsSCertSerialLen());
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(80) + " Data length: " + Integer.toString(this.smf119scTlsSCertSerialLen()));
    }

    public TimeType smf119scTlsSCertTimeType() {
        int value = Util.ConvertUnsignedBinary1(this.data, 100);
        return TimeType.from(value);
    }

    public int smf119scTlsSCertTimeTypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 100);
    }

    public ZonedDateTime smf119scTlsSCertTime() {
        switch (this.smf119scTlsSCertTimeType()) {
            case GT: {
                return this.smf119scTlsSCertTimeGt();
            }
            case UTC: {
                return this.smf119scTlsSCertTimeUtc();
            }
        }
        return null;
    }

    public String smf119scTlsSCertTimeRawValue() {
        return Util.ConvertEbcdic(this.data, 101, 15);
    }

    private ZonedDateTime smf119scTlsSCertTimeUtc() {
        return Util.YYMMDDhhmmssZ(this.data, 101);
    }

    private String smf119scTlsSCertTimeUtcRawValue() {
        return Util.ConvertEbcdic(this.data, 101, 13);
    }

    private ZonedDateTime smf119scTlsSCertTimeGt() {
        return Util.YYYYMMDDhhmmssZ(this.data, 101);
    }

    private String smf119scTlsSCertTimeGtRawValue() {
        return Util.ConvertEbcdic(this.data, 101, 15);
    }

    public KeyType smf119scTlsSCertKeyType() {
        int value = Util.ConvertUnsignedBinary2(this.data, 116);
        return KeyType.from(value);
    }

    public int smf119scTlsSCertKeyTypeRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 116);
    }

    public int smf119scTlsSCertKeyLen() {
        return Util.ConvertUnsignedBinary2(this.data, 118);
    }

    public SignatureMethod smf119scTlsCCertSignatureMethod() {
        int value = Util.ConvertUnsignedBinary2(this.data, 120);
        return SignatureMethod.from(value);
    }

    public int smf119scTlsCCertSignatureMethodRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 120);
    }

    public CertEncryptionMethod smf119scTlsCCertEncMethod() {
        int value = Util.ConvertUnsignedBinary2(this.data, 122);
        return CertEncryptionMethod.from(value);
    }

    public int smf119scTlsCCertEncMethodRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 122);
    }

    public CertDigestAlgorithm smf119scTlsCCertDigestAlg() {
        int value = Util.ConvertUnsignedBinary2(this.data, 124);
        return CertDigestAlgorithm.from(value);
    }

    public int smf119scTlsCCertDigestAlgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 124);
    }

    public int smf119scTlsCCertSerialLen() {
        return Util.ConvertUnsignedBinary1(this.data, 127);
    }

    public Token smf119scTlsCCertSerial() {
        if (this.smf119scTlsCCertSerialLen() == 0) {
            return null;
        }
        if (this.data.length >= 128 + this.smf119scTlsCCertSerialLen()) {
            return new Token(this.data, 128, this.smf119scTlsCCertSerialLen());
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(128) + " Data length: " + Integer.toString(this.smf119scTlsCCertSerialLen()));
    }

    public TimeType smf119scTlsCCertTimeType() {
        int value = Util.ConvertUnsignedBinary1(this.data, 148);
        return TimeType.from(value);
    }

    public int smf119scTlsCCertTimeTypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 148);
    }

    public ZonedDateTime smf119scTlsCCertTime() {
        switch (this.smf119scTlsCCertTimeType()) {
            case GT: {
                return this.smf119scTlsCCertTimeGt();
            }
            case UTC: {
                return this.smf119scTlsCCertTimeUtc();
            }
        }
        return null;
    }

    public String smf119scTlsCCertTimeRawValue() {
        return Util.ConvertEbcdic(this.data, 149, 15);
    }

    private ZonedDateTime smf119scTlsCCertTimeUtc() {
        return Util.YYMMDDhhmmssZ(this.data, 149);
    }

    private String smf119scTlsCCertTimeUtcRawValue() {
        return Util.ConvertEbcdic(this.data, 149, 13);
    }

    private ZonedDateTime smf119scTlsCCertTimeGt() {
        return Util.YYYYMMDDhhmmssZ(this.data, 149);
    }

    private String smf119scTlsCCertTimeGtRawValue() {
        return Util.ConvertEbcdic(this.data, 149, 15);
    }

    public KeyType smf119scTlsCCertKeyType() {
        int value = Util.ConvertUnsignedBinary2(this.data, 164);
        return KeyType.from(value);
    }

    public int smf119scTlsCCertKeyTypeRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 164);
    }

    public int smf119scTlsCCertKeyLen() {
        return Util.ConvertUnsignedBinary2(this.data, 166);
    }

    public SignatureMethod smf119scTlsServerHsSigMethod() {
        int value = Util.ConvertUnsignedBinary2(this.data, 168);
        return SignatureMethod.from(value);
    }

    public int smf119scTlsServerHsSigMethodRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 168);
    }

    public SignatureMethod smf119scTlsClientHsSigMethod() {
        int value = Util.ConvertUnsignedBinary2(this.data, 170);
        return SignatureMethod.from(value);
    }

    public int smf119scTlsClientHsSigMethodRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 170);
    }

    public TLSNegotiatedkeyShare smf119scTlsNegKeyShare() {
        int value = Util.ConvertUnsignedBinary2(this.data, 172);
        return TLSNegotiatedkeyShare.from(value);
    }

    public int smf119scTlsNegKeyShareRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 172);
    }

    public static ZertDetailTLSSection create(byte[] Data2, int offset, int length) {
        return new ZertDetailTLSSection(Data2, offset, length);
    }

    static enum Field {
        smf119scTlsProtVer(0, 2),
        smf119scTlsSource(2, 1),
        smf119scTlsHandshakeType(3, 1),
        smf119scTlsHandshakeRole(4, 1),
        smf119scTlsSessionIdLen(7, 1),
        smf119scTlsSessionId(8, 32),
        smf119scTlsProtocolProvider(40, 16),
        smf119scTlsNegCipher(56, 6),
        smf119scTlsCSEncAlg(62, 2),
        smf119scTlsCSMsgAuth(64, 2),
        smf119scTlsCSKexAlg(66, 2),
        smf119scTlsFipsMode(68, 1),
        smf119scTlsCryptoFlags(69, 1),
        smf119scTlsSCertSignatureMethod(72, 2),
        smf119scTlsSCertEncMethod(74, 2),
        smf119scTlsSCertDigestAlg(76, 2),
        smf119scTlsSCertSerialLen(79, 1),
        smf119scTlsSCertSerial(80, 0),
        smf119scTlsSCertTimeType(100, 1),
        smf119scTlsSCertTime(101, 15),
        smf119scTlsSCertTimeUtc(101, 13),
        smf119scTlsSCertTimeGt(101, 15),
        smf119scTlsSCertKeyType(116, 2),
        smf119scTlsSCertKeyLen(118, 2),
        smf119scTlsCCertSignatureMethod(120, 2),
        smf119scTlsCCertEncMethod(122, 2),
        smf119scTlsCCertDigestAlg(124, 2),
        smf119scTlsCCertSerialLen(127, 1),
        smf119scTlsCCertSerial(128, 0),
        smf119scTlsCCertTimeType(148, 1),
        smf119scTlsCCertTime(149, 15),
        smf119scTlsCCertTimeUtc(149, 13),
        smf119scTlsCCertTimeGt(149, 15),
        smf119scTlsCCertKeyType(164, 2),
        smf119scTlsCCertKeyLen(166, 2),
        smf119scTlsServerHsSigMethod(168, 2),
        smf119scTlsClientHsSigMethod(170, 2),
        smf119scTlsNegKeyShare(172, 2);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

