/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.smf119.internal.zertsummary;

import java.util.HashMap;
import java.util.Map;

enum MessageAuthAlgorithm {
    UNKNOWN(0),
    NONE(1),
    MD2(2),
    HMAC_MD5(3),
    HMAC_SHA1(4),
    HMAC_SHA2_224(5),
    HMAC_SHA2_256(6),
    HMAC_SHA2_384(7),
    HMAC_SHA2_512(8),
    AES_GMAC_128(9),
    AES_GMAC_256(10),
    AES_128_XCBC_96(11),
    HMAC_SHA2_256_128(12),
    HMAC_SHA2_384_192(13),
    HMAC_SHA2_512_256(14),
    HMAC_MD5_96(15),
    HMAC_SHA1_96(16),
    UMAC_64(17),
    UMAC_128(18),
    RIPEMD_160(19),
    NOT_DEFINED(-16);

    private static Map<Integer, MessageAuthAlgorithm> valueMap;
    private final int messageauthalgorithm;

    private MessageAuthAlgorithm(int messageauthalgorithm) {
        this.messageauthalgorithm = messageauthalgorithm;
    }

    public static MessageAuthAlgorithm from(int value) {
        MessageAuthAlgorithm result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int messageauthalgorithm() {
        return this.messageauthalgorithm;
    }

    static {
        valueMap = new HashMap<Integer, MessageAuthAlgorithm>();
        for (MessageAuthAlgorithm x : MessageAuthAlgorithm.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.messageauthalgorithm, x);
        }
    }
}

